package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueStatusBuilder extends QueueStatusFluentImpl<QueueStatusBuilder> implements VisitableBuilder<QueueStatus,QueueStatusBuilder>{
  public QueueStatusBuilder() {
    this(false);
  }
  public QueueStatusBuilder(Boolean validationEnabled) {
    this(new QueueStatus(), validationEnabled);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QueueStatus(), validationEnabled);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,QueueStatus instance) {
    this(fluent, instance, false);
  }
  public QueueStatusBuilder(QueueStatusFluent<?> fluent,QueueStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withInqueue(instance.getInqueue()); 
    fluent.withPending(instance.getPending()); 
    fluent.withRunning(instance.getRunning()); 
    fluent.withState(instance.getState()); 
    fluent.withUnknown(instance.getUnknown()); 
    this.validationEnabled = validationEnabled; 
  }
  public QueueStatusBuilder(QueueStatus instance) {
    this(instance,false);
  }
  public QueueStatusBuilder(QueueStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withInqueue(instance.getInqueue()); 
    this.withPending(instance.getPending()); 
    this.withRunning(instance.getRunning()); 
    this.withState(instance.getState()); 
    this.withUnknown(instance.getUnknown()); 
    this.validationEnabled = validationEnabled; 
  }
  QueueStatusFluent<?> fluent;
  Boolean validationEnabled;
  public QueueStatus build() {
    QueueStatus buildable = new QueueStatus(fluent.getInqueue(),fluent.getPending(),fluent.getRunning(),fluent.getState(),fluent.getUnknown());
    return buildable;
  }
  
}