package io.fabric8.volcano.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueSpecBuilder extends QueueSpecFluentImpl<QueueSpecBuilder> implements VisitableBuilder<QueueSpec,QueueSpecBuilder>{
  public QueueSpecBuilder() {
    this(false);
  }
  public QueueSpecBuilder(Boolean validationEnabled) {
    this(new QueueSpec(), validationEnabled);
  }
  public QueueSpecBuilder(QueueSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueSpecBuilder(QueueSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QueueSpec(), validationEnabled);
  }
  public QueueSpecBuilder(QueueSpecFluent<?> fluent,QueueSpec instance) {
    this(fluent, instance, false);
  }
  public QueueSpecBuilder(QueueSpecFluent<?> fluent,QueueSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCapability(instance.getCapability());
      fluent.withReclaimable(instance.getReclaimable());
      fluent.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  public QueueSpecBuilder(QueueSpec instance) {
    this(instance,false);
  }
  public QueueSpecBuilder(QueueSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCapability(instance.getCapability());
      this.withReclaimable(instance.getReclaimable());
      this.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  QueueSpecFluent<?> fluent;
  Boolean validationEnabled;
  public QueueSpec build() {
    QueueSpec buildable = new QueueSpec(fluent.getCapability(),fluent.getReclaimable(),fluent.getWeight());
    return buildable;
  }
  
}