/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentList;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class VolumeSnapshotContentListFluentImpl<A extends VolumeSnapshotContentListFluent<A>>
extends BaseFluent<A>
implements VolumeSnapshotContentListFluent<A> {
    private String apiVersion;
    private List<VolumeSnapshotContentBuilder> items;
    private String kind;
    private ListMeta metadata;

    public VolumeSnapshotContentListFluentImpl() {
    }

    public VolumeSnapshotContentListFluentImpl(VolumeSnapshotContentList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, VolumeSnapshotContent item) {
        if (this.items == null) {
            this.items = new ArrayList<VolumeSnapshotContentBuilder>();
        }
        VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, VolumeSnapshotContent item) {
        if (this.items == null) {
            this.items = new ArrayList<VolumeSnapshotContentBuilder>();
        }
        VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(VolumeSnapshotContent ... items) {
        if (this.items == null) {
            this.items = new ArrayList<VolumeSnapshotContentBuilder>();
        }
        for (VolumeSnapshotContent item : items) {
            VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<VolumeSnapshotContent> items) {
        if (this.items == null) {
            this.items = new ArrayList<VolumeSnapshotContentBuilder>();
        }
        for (VolumeSnapshotContent item : items) {
            VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(VolumeSnapshotContent ... items) {
        for (VolumeSnapshotContent item : items) {
            VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<VolumeSnapshotContent> items) {
        for (VolumeSnapshotContent item : items) {
            VolumeSnapshotContentBuilder builder = new VolumeSnapshotContentBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<VolumeSnapshotContentBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<VolumeSnapshotContentBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            VolumeSnapshotContentBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeSnapshotContent> getItems() {
        return VolumeSnapshotContentListFluentImpl.build(this.items);
    }

    @Override
    public List<VolumeSnapshotContent> buildItems() {
        return VolumeSnapshotContentListFluentImpl.build(this.items);
    }

    @Override
    public VolumeSnapshotContent buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public VolumeSnapshotContent buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public VolumeSnapshotContent buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public VolumeSnapshotContent buildMatchingItem(Predicate<VolumeSnapshotContentBuilder> predicate) {
        for (VolumeSnapshotContentBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<VolumeSnapshotContentBuilder> predicate) {
        for (VolumeSnapshotContentBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<VolumeSnapshotContent> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<VolumeSnapshotContentBuilder>();
            for (VolumeSnapshotContent item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(VolumeSnapshotContent ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (VolumeSnapshotContent item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> addNewItemLike(VolumeSnapshotContent item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> setNewItemLike(Integer index, VolumeSnapshotContent item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public VolumeSnapshotContentListFluent.ItemsNested<A> editMatchingItem(Predicate<VolumeSnapshotContentBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSnapshotContentListFluentImpl that = (VolumeSnapshotContentListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends VolumeSnapshotContentFluentImpl<VolumeSnapshotContentListFluent.ItemsNested<N>>
    implements VolumeSnapshotContentListFluent.ItemsNested<N>,
    Nested<N> {
        VolumeSnapshotContentBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, VolumeSnapshotContent item) {
            this.index = index;
            this.builder = new VolumeSnapshotContentBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeSnapshotContentBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotContentListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

