/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotError;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotErrorBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotErrorFluentImpl;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotStatus;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotStatusFluent;
import java.util.Objects;

public class VolumeSnapshotStatusFluentImpl<A extends VolumeSnapshotStatusFluent<A>>
extends BaseFluent<A>
implements VolumeSnapshotStatusFluent<A> {
    private String boundVolumeSnapshotContentName;
    private String creationTime;
    private VolumeSnapshotErrorBuilder error;
    private Boolean readyToUse;
    private Quantity restoreSize;

    public VolumeSnapshotStatusFluentImpl() {
    }

    public VolumeSnapshotStatusFluentImpl(VolumeSnapshotStatus instance) {
        this.withBoundVolumeSnapshotContentName(instance.getBoundVolumeSnapshotContentName());
        this.withCreationTime(instance.getCreationTime());
        this.withError(instance.getError());
        this.withReadyToUse(instance.getReadyToUse());
        this.withRestoreSize(instance.getRestoreSize());
    }

    @Override
    public String getBoundVolumeSnapshotContentName() {
        return this.boundVolumeSnapshotContentName;
    }

    @Override
    public A withBoundVolumeSnapshotContentName(String boundVolumeSnapshotContentName) {
        this.boundVolumeSnapshotContentName = boundVolumeSnapshotContentName;
        return (A)this;
    }

    @Override
    public Boolean hasBoundVolumeSnapshotContentName() {
        return this.boundVolumeSnapshotContentName != null;
    }

    @Override
    @Deprecated
    public A withNewBoundVolumeSnapshotContentName(String arg0) {
        return this.withBoundVolumeSnapshotContentName(new String(arg0));
    }

    @Override
    public String getCreationTime() {
        return this.creationTime;
    }

    @Override
    public A withCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTime() {
        return this.creationTime != null;
    }

    @Override
    @Deprecated
    public A withNewCreationTime(String arg0) {
        return this.withCreationTime(new String(arg0));
    }

    @Override
    @Deprecated
    public VolumeSnapshotError getError() {
        return this.error != null ? this.error.build() : null;
    }

    @Override
    public VolumeSnapshotError buildError() {
        return this.error != null ? this.error.build() : null;
    }

    @Override
    public A withError(VolumeSnapshotError error) {
        this._visitables.get((Object)"error").remove(this.error);
        if (error != null) {
            this.error = new VolumeSnapshotErrorBuilder(error);
            this._visitables.get((Object)"error").add(this.error);
        }
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    public A withNewError(String message, String time) {
        return this.withError(new VolumeSnapshotError(message, time));
    }

    @Override
    public VolumeSnapshotStatusFluent.ErrorNested<A> withNewError() {
        return new ErrorNestedImpl();
    }

    @Override
    public VolumeSnapshotStatusFluent.ErrorNested<A> withNewErrorLike(VolumeSnapshotError item) {
        return new ErrorNestedImpl(item);
    }

    @Override
    public VolumeSnapshotStatusFluent.ErrorNested<A> editError() {
        return this.withNewErrorLike(this.getError());
    }

    @Override
    public VolumeSnapshotStatusFluent.ErrorNested<A> editOrNewError() {
        return this.withNewErrorLike(this.getError() != null ? this.getError() : new VolumeSnapshotErrorBuilder().build());
    }

    @Override
    public VolumeSnapshotStatusFluent.ErrorNested<A> editOrNewErrorLike(VolumeSnapshotError item) {
        return this.withNewErrorLike(this.getError() != null ? this.getError() : item);
    }

    @Override
    public Boolean getReadyToUse() {
        return this.readyToUse;
    }

    @Override
    public A withReadyToUse(Boolean readyToUse) {
        this.readyToUse = readyToUse;
        return (A)this;
    }

    @Override
    public Boolean hasReadyToUse() {
        return this.readyToUse != null;
    }

    @Override
    public Quantity getRestoreSize() {
        return this.restoreSize;
    }

    @Override
    public A withRestoreSize(Quantity restoreSize) {
        this.restoreSize = restoreSize;
        return (A)this;
    }

    @Override
    public Boolean hasRestoreSize() {
        return this.restoreSize != null;
    }

    @Override
    public A withNewRestoreSize(String amount, String format) {
        return this.withRestoreSize(new Quantity(amount, format));
    }

    @Override
    public A withNewRestoreSize(String amount) {
        return this.withRestoreSize(new Quantity(amount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeSnapshotStatusFluentImpl that = (VolumeSnapshotStatusFluentImpl)o;
        if (this.boundVolumeSnapshotContentName != null ? !this.boundVolumeSnapshotContentName.equals(that.boundVolumeSnapshotContentName) : that.boundVolumeSnapshotContentName != null) {
            return false;
        }
        if (this.creationTime != null ? !this.creationTime.equals(that.creationTime) : that.creationTime != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.readyToUse != null ? !this.readyToUse.equals(that.readyToUse) : that.readyToUse != null) {
            return false;
        }
        return !(this.restoreSize != null ? !this.restoreSize.equals((Object)that.restoreSize) : that.restoreSize != null);
    }

    public int hashCode() {
        return Objects.hash(this.boundVolumeSnapshotContentName, this.creationTime, this.error, this.readyToUse, this.restoreSize, super.hashCode());
    }

    public class ErrorNestedImpl<N>
    extends VolumeSnapshotErrorFluentImpl<VolumeSnapshotStatusFluent.ErrorNested<N>>
    implements VolumeSnapshotStatusFluent.ErrorNested<N>,
    Nested<N> {
        VolumeSnapshotErrorBuilder builder;

        ErrorNestedImpl(VolumeSnapshotError item) {
            this.builder = new VolumeSnapshotErrorBuilder(this, item);
        }

        ErrorNestedImpl() {
            this.builder = new VolumeSnapshotErrorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VolumeSnapshotStatusFluentImpl.this.withError(this.builder.build());
        }

        @Override
        public N endError() {
            return this.and();
        }
    }
}

