/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.volumesnapshot.api.model.EditableVolumeSnapshotSpec;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSpec;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSpecFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotSpecFluentImpl;
import java.util.Objects;

public class VolumeSnapshotSpecBuilder
extends VolumeSnapshotSpecFluentImpl<VolumeSnapshotSpecBuilder>
implements VisitableBuilder<VolumeSnapshotSpec, VolumeSnapshotSpecBuilder> {
    VolumeSnapshotSpecFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeSnapshotSpecBuilder() {
        this(true);
    }

    public VolumeSnapshotSpecBuilder(Boolean validationEnabled) {
        this(new VolumeSnapshotSpec(), validationEnabled);
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeSnapshotSpec(), validationEnabled);
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpecFluent<?> fluent, VolumeSnapshotSpec instance) {
        this(fluent, instance, true);
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpecFluent<?> fluent, VolumeSnapshotSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSource(instance.getSource());
        fluent.withVolumeSnapshotClassName(instance.getVolumeSnapshotClassName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpec instance) {
        this(instance, (Boolean)true);
    }

    public VolumeSnapshotSpecBuilder(VolumeSnapshotSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSource(instance.getSource());
        this.withVolumeSnapshotClassName(instance.getVolumeSnapshotClassName());
        this.validationEnabled = validationEnabled;
    }

    public EditableVolumeSnapshotSpec build() {
        EditableVolumeSnapshotSpec buildable = new EditableVolumeSnapshotSpec(this.fluent.getSource(), this.fluent.getVolumeSnapshotClassName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeSnapshotSpecBuilder that = (VolumeSnapshotSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

