/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volumesnapshot.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSource;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSourceBuilder;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSourceFluent;
import io.fabric8.volumesnapshot.api.model.VolumeSnapshotContentSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VolumeSnapshotContentSpecFluent<A extends VolumeSnapshotContentSpecFluent<A>>
extends BaseFluent<A> {
    private String deletionPolicy;
    private String driver;
    private VolumeSnapshotContentSourceBuilder source;
    private String volumeSnapshotClassName;
    private ObjectReferenceBuilder volumeSnapshotRef;
    private Map<String, Object> additionalProperties;

    public VolumeSnapshotContentSpecFluent() {
    }

    public VolumeSnapshotContentSpecFluent(VolumeSnapshotContentSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VolumeSnapshotContentSpec instance) {
        VolumeSnapshotContentSpec volumeSnapshotContentSpec = instance = instance != null ? instance : new VolumeSnapshotContentSpec();
        if (instance != null) {
            this.withDeletionPolicy(instance.getDeletionPolicy());
            this.withDriver(instance.getDriver());
            this.withSource(instance.getSource());
            this.withVolumeSnapshotClassName(instance.getVolumeSnapshotClassName());
            this.withVolumeSnapshotRef(instance.getVolumeSnapshotRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public A withDeletionPolicy(String deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
        return (A)((Object)this);
    }

    public boolean hasDeletionPolicy() {
        return this.deletionPolicy != null;
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public VolumeSnapshotContentSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(VolumeSnapshotContentSource source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new VolumeSnapshotContentSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String snapshotHandle, String volumeHandle) {
        return this.withSource(new VolumeSnapshotContentSource(snapshotHandle, volumeHandle));
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(VolumeSnapshotContentSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new VolumeSnapshotContentSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(VolumeSnapshotContentSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public String getVolumeSnapshotClassName() {
        return this.volumeSnapshotClassName;
    }

    public A withVolumeSnapshotClassName(String volumeSnapshotClassName) {
        this.volumeSnapshotClassName = volumeSnapshotClassName;
        return (A)((Object)this);
    }

    public boolean hasVolumeSnapshotClassName() {
        return this.volumeSnapshotClassName != null;
    }

    public ObjectReference buildVolumeSnapshotRef() {
        return this.volumeSnapshotRef != null ? this.volumeSnapshotRef.build() : null;
    }

    public A withVolumeSnapshotRef(ObjectReference volumeSnapshotRef) {
        this._visitables.remove((Object)"volumeSnapshotRef");
        if (volumeSnapshotRef != null) {
            this.volumeSnapshotRef = new ObjectReferenceBuilder(volumeSnapshotRef);
            this._visitables.get((Object)"volumeSnapshotRef").add(this.volumeSnapshotRef);
        } else {
            this.volumeSnapshotRef = null;
            this._visitables.get((Object)"volumeSnapshotRef").remove(this.volumeSnapshotRef);
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeSnapshotRef() {
        return this.volumeSnapshotRef != null;
    }

    public VolumeSnapshotRefNested<A> withNewVolumeSnapshotRef() {
        return new VolumeSnapshotRefNested(null);
    }

    public VolumeSnapshotRefNested<A> withNewVolumeSnapshotRefLike(ObjectReference item) {
        return new VolumeSnapshotRefNested(item);
    }

    public VolumeSnapshotRefNested<A> editVolumeSnapshotRef() {
        return this.withNewVolumeSnapshotRefLike(Optional.ofNullable(this.buildVolumeSnapshotRef()).orElse(null));
    }

    public VolumeSnapshotRefNested<A> editOrNewVolumeSnapshotRef() {
        return this.withNewVolumeSnapshotRefLike(Optional.ofNullable(this.buildVolumeSnapshotRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public VolumeSnapshotRefNested<A> editOrNewVolumeSnapshotRefLike(ObjectReference item) {
        return this.withNewVolumeSnapshotRefLike(Optional.ofNullable(this.buildVolumeSnapshotRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeSnapshotContentSpecFluent that = (VolumeSnapshotContentSpecFluent)((Object)o);
        if (!Objects.equals(this.deletionPolicy, that.deletionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!Objects.equals(this.volumeSnapshotClassName, that.volumeSnapshotClassName)) {
            return false;
        }
        if (!Objects.equals(this.volumeSnapshotRef, that.volumeSnapshotRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deletionPolicy, this.driver, this.source, this.volumeSnapshotClassName, this.volumeSnapshotRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deletionPolicy != null) {
            sb.append("deletionPolicy:");
            sb.append(this.deletionPolicy + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append((Object)((Object)this.source) + ",");
        }
        if (this.volumeSnapshotClassName != null) {
            sb.append("volumeSnapshotClassName:");
            sb.append(this.volumeSnapshotClassName + ",");
        }
        if (this.volumeSnapshotRef != null) {
            sb.append("volumeSnapshotRef:");
            sb.append(this.volumeSnapshotRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VolumeSnapshotRefNested<N>
    extends ObjectReferenceFluent<VolumeSnapshotRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        VolumeSnapshotRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)VolumeSnapshotContentSpecFluent.this.withVolumeSnapshotRef(this.builder.build());
        }

        public N endVolumeSnapshotRef() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends VolumeSnapshotContentSourceFluent<SourceNested<N>>
    implements Nested<N> {
        VolumeSnapshotContentSourceBuilder builder;

        SourceNested(VolumeSnapshotContentSource item) {
            this.builder = new VolumeSnapshotContentSourceBuilder(this, item);
        }

        public N and() {
            return (N)VolumeSnapshotContentSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

