/*
 * Decompiled with CFR 0.152.
 */
package io.fares.bind.xjc.plugins.jackson;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import io.fares.bind.xjc.plugins.jackson.EnumAnnotationProcessor;
import io.fares.bind.xjc.plugins.jackson.FixedAttributeValueProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class JacksonPlugin
extends AbstractParameterizablePlugin {
    public static final String NS = "http://jaxb2-commons.dev.java.net/basic/jackson";
    private EnumAnnotationProcessor enumAnnotationProcessor = new EnumAnnotationProcessor();
    private FixedAttributeValueProcessor fixedAttributeValueProcessor = new FixedAttributeValueProcessor();

    public String getOptionName() {
        return "Xjackson";
    }

    public String getUsage() {
        return "  -Xjackson          : enable jackson annotation generation";
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(NS);
    }

    public Collection<QName> getCustomizationElementNames() {
        return Collections.emptyList();
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        for (CClassInfo classInfo : model.beans().values()) {
            this.postProcessClassInfo(model, classInfo);
        }
    }

    private void postProcessClassInfo(Model model, CClassInfo classInfo) {
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        JCodeModel model = outline.getCodeModel();
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.enumAnnotationProcessor.process(model, enumOutline);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.fixedAttributeValueProcessor.process(classOutline);
        }
        return true;
    }
}

