/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.Map;
import org.boon.Str;
import org.boon.StringScanner;
import org.boon.collections.LazyMap;
import org.boon.core.reflection.FastStringUtils;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.boon.primitive.CharScanner;

public class BoonCommandArgumentParser {
    final JsonParserAndMapper jsonParser = new JsonParserFactory().lax().create();

    public Map<String, Object> parseArguments(String args) {
        char[] chars = FastStringUtils.toCharArray(args);
        int index = CharScanner.skipWhiteSpace(chars);
        char c = ' ';
        if (index != chars.length) {
            c = chars[index];
        }
        if (c == '{') {
            return this.jsonParser.parseMap(chars);
        }
        if (c == '[') {
            LazyMap map = new LazyMap(1);
            map.put("varargs", this.jsonParser.parse(chars));
            return map;
        }
        boolean collectName = true;
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        LazyMap params = new LazyMap();
        params.put("commandArgs", args);
        int closeQuoteToMatch = 34;
        block5: for (index = 0; index < chars.length; ++index) {
            c = chars[index];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                case '=': {
                    collectName = false;
                    if (chars[index + 1] != '\'' && chars[index + 1] != '\"') {
                        int start = index + 1;
                        int end = -1;
                        if (chars[index + 1] == '$' && chars[index + 2] == '{') {
                            end = CharScanner.findChar('}', start, chars);
                            if (end != -1) {
                                ++end;
                            }
                        } else if (chars[index + 1] == '{' && chars[index + 2] == '{') {
                            end = CharScanner.findChar('}', start, chars);
                            if (end != -1) {
                                end += 2;
                            }
                        } else {
                            end = CharScanner.findWhiteSpace(start, chars);
                        }
                        if (end == -1) {
                            end = chars.length;
                        }
                        String v = Str.slc(args, start, end);
                        params.put(name.toString(), v);
                        index += v.length();
                        name = new StringBuilder();
                        collectName = true;
                        value = new StringBuilder();
                        continue block5;
                    }
                    closeQuoteToMatch = chars[index + 1];
                    ++index;
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    if (c == closeQuoteToMatch) {
                        collectName = true;
                        ++index;
                        params.put(name.toString(), value.toString());
                        name = new StringBuilder();
                        value = new StringBuilder();
                        continue block5;
                    }
                }
                default: {
                    if (collectName) {
                        name.append(c);
                        continue block5;
                    }
                    value.append(c);
                }
            }
        }
        if (params.size() == 1) {
            params.put("varargs", StringScanner.splitByChars(args, ' ', '\t', '\n'));
        }
        return params;
    }
}

