/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.ArrayList;
import java.util.List;
import org.boon.Boon;
import org.boon.Str;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharScanner;
import org.boon.template.TemplateParser;
import org.boon.template.support.Token;
import org.boon.template.support.TokenTypes;

public class BoonCoreTemplateParser
implements TemplateParser {
    char[] charArray;
    int index;
    char ch;
    private List<Token> tokenList = new ArrayList<Token>();

    @Override
    public void parse(String string) {
        this.charArray = FastStringUtils.toCharArray(string);
        this.index = 0;
        this.tokenList.clear();
        this.processLoop();
    }

    private void processLoop() {
        Token text = Token.text(this.index, -1);
        while (this.index < this.charArray.length) {
            this.ch = this.charArray[this.index];
            if (this.ch == '<') {
                if (CharScanner.matchChars(TokenTypes.COMMAND_START.jstlStyle(), this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.COMMAND_START.jstlStyle().length;
                    this.handleCommand();
                }
            } else if (this.ch == '$') {
                char ch1 = this.charArray[this.index + 1];
                if (ch1 == '{') {
                    if (CharScanner.matchChars(TokenTypes.EXPRESSION_START.jstlStyle(), this.index, this.charArray)) {
                        text = this.textToken(text);
                        this.index += TokenTypes.EXPRESSION_START.jstlStyle().length;
                        this.handleCurlyExpression();
                        text = Token.text(this.index, -1);
                        --this.index;
                    }
                } else {
                    text = this.textToken(text);
                    ++this.index;
                    this.handleExpression(null);
                    text = Token.text(this.index, -1);
                    --this.index;
                }
            } else if (text == null) {
                text = Token.text(this.index, -1);
            }
            ++this.index;
        }
        if (text != null) {
            text.stop(this.charArray.length);
            this.tokenList.add(text);
        }
    }

    private void handleCurlyExpression() {
        int startIndex = this.index;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.jstlStyle(), this.index, this.charArray);
        if (this.index > 0) {
            this.tokenList.add(Token.expression(startIndex, this.index));
            this.index += TokenTypes.EXPRESSION_END.jstlStyle().length;
        }
    }

    private void handleExpression(String term) {
        int startIndex = this.index;
        this.index = CharScanner.findWhiteSpace(this.index, this.charArray);
        if (term != null && this.index == -1) {
            this.index = startIndex;
            this.index = CharScanner.findChars(term.toCharArray(), this.index, this.charArray);
        }
        if (this.index == -1) {
            this.index = this.charArray.length;
        }
        this.tokenList.add(Token.expression(startIndex, this.index));
    }

    private void handleCommand() {
        int startIndex = this.index;
        boolean noBody = false;
        this.index = CharScanner.findChars(TokenTypes.COMMAND_END_START.jstlStyle(), this.index, this.charArray);
        if (this.index == -1) {
            return;
        }
        int foundIndex = CharScanner.findChars(TokenTypes.COMMAND_START_TAG_END.jstlStyle(), this.index - 1, this.charArray);
        if (foundIndex != -1) {
            noBody = true;
        }
        if (noBody) {
            --this.index;
        }
        this.tokenList.add(Token.commandStart(startIndex, this.index));
        this.index += TokenTypes.COMMAND_END_START.jstlStyle().length;
        if (noBody) {
            this.tokenList.add(Token.commandBody(this.index, this.index));
            return;
        }
        Token commandBody = Token.commandBody(this.index, this.index);
        this.tokenList.add(commandBody);
        Token text = Token.text(this.index, -1);
        while (this.index < this.charArray.length) {
            this.ch = this.charArray[this.index];
            if (this.ch == '<') {
                if (CharScanner.matchChars(TokenTypes.COMMAND_START.jstlStyle(), this.index, this.charArray)) {
                    text = this.textToken(text);
                    this.index += TokenTypes.COMMAND_START.jstlStyle().length;
                    this.handleCommand();
                } else if (CharScanner.matchChars(TokenTypes.COMMAND_START_END.jstlStyle(), this.index, this.charArray)) {
                    text = this.textToken(text);
                    commandBody.stop(this.index);
                    ++this.index;
                    this.index = CharScanner.findChar('>', this.index, this.charArray);
                    break;
                }
            } else if (this.ch == '$') {
                char ch1 = this.charArray[this.index + 1];
                if (ch1 == '{') {
                    if (CharScanner.matchChars(TokenTypes.EXPRESSION_START.jstlStyle(), this.index, this.charArray)) {
                        text = this.textToken(text);
                        this.index += TokenTypes.EXPRESSION_START.jstlStyle().length;
                        this.handleCurlyExpression();
                        text = Token.text(this.index, -1);
                        --this.index;
                    }
                } else {
                    text = this.textToken(text);
                    ++this.index;
                    this.handleExpression("</");
                    text = Token.text(this.index, -1);
                    --this.index;
                }
            } else if (text == null) {
                text = Token.text(this.index, -1);
            }
            ++this.index;
        }
        if (commandBody.stop() == -1) {
            commandBody.stop(this.index);
        }
        if (text != null) {
            text.stop(this.charArray.length);
            this.tokenList.add(text);
        }
    }

    private Token textToken(Token text) {
        if (text != null) {
            text.stop(this.index);
            if (text.start() != text.stop()) {
                this.tokenList.add(text);
            }
            text = null;
        }
        return text;
    }

    @Override
    public List<Token> getTokenList() {
        return this.tokenList;
    }

    @Override
    public void displayTokens(String template) {
        for (Token token : this.getTokenList()) {
            Boon.puts("token", token, Str.slc(template, token.start(), token.stop()));
        }
    }
}

