/*
 * Decompiled with CFR 0.152.
 */
package org.boon.core.reflection.fields;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.boon.Exceptions;
import org.boon.core.Typ;
import org.boon.core.reflection.fields.BaseField;
import sun.misc.Unsafe;

public abstract class UnsafeField
extends BaseField {
    protected long offset;
    protected final Object base;
    private final Field field;
    protected static final Unsafe unsafe = UnsafeField.getUnsafe();

    protected UnsafeField(Field field) {
        super(field);
        if (super.isStatic()) {
            this.base = unsafe.staticFieldBase(field);
            this.offset = unsafe.staticFieldOffset(field);
        } else {
            this.offset = unsafe.objectFieldOffset(field);
            this.base = null;
        }
        this.field = field;
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            return (Unsafe)f.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static UnsafeField createUnsafeField(Field field) {
        Class<?> type = field.getType();
        boolean isVolatile = Modifier.isVolatile(field.getModifiers());
        if (!isVolatile) {
            if (type == Typ.intgr) {
                return new IntUnsafeField(field);
            }
            if (type == Typ.lng) {
                return new LongUnsafeField(field);
            }
            if (type == Typ.bt) {
                return new ByteUnsafeField(field);
            }
            if (type == Typ.shrt) {
                return new ShortUnsafeField(field);
            }
            if (type == Typ.chr) {
                return new CharUnsafeField(field);
            }
            if (type == Typ.dbl) {
                return new DoubleUnsafeField(field);
            }
            if (type == Typ.flt) {
                return new FloatUnsafeField(field);
            }
            if (type == Typ.bln) {
                return new BooleanUnsafeField(field);
            }
            return new ObjectUnsafeField(field);
        }
        if (type == Typ.intgr) {
            return new VolatileIntUnsafeField(field);
        }
        if (type == Typ.lng) {
            return new VolatileLongUnsafeField(field);
        }
        if (type == Typ.bt) {
            return new VolatileByteUnsafeField(field);
        }
        if (type == Typ.shrt) {
            return new VolatileShortUnsafeField(field);
        }
        if (type == Typ.chr) {
            return new VolatileCharUnsafeField(field);
        }
        if (type == Typ.dbl) {
            return new VolatileDoubleUnsafeField(field);
        }
        if (type == Typ.flt) {
            return new VolatileFloatUnsafeField(field);
        }
        if (type == Typ.bln) {
            return new VolatileBooleanUnsafeField(field);
        }
        return new ObjectUnsafeField(field);
    }

    @Override
    public void setStaticValue(Object newValue) {
        try {
            this.field.set(null, newValue);
        }
        catch (IllegalAccessException e) {
            Exceptions.handle(e);
        }
    }

    @Override
    public int getInt(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0;
    }

    @Override
    public boolean getBoolean(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return false;
    }

    @Override
    public short getShort(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0;
    }

    @Override
    public char getChar(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return '\u0000';
    }

    @Override
    public long getLong(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0L;
    }

    @Override
    public double getDouble(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0.0;
    }

    @Override
    public float getFloat(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0.0f;
    }

    @Override
    public byte getByte(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
        return 0;
    }

    @Override
    public Object getObject(Object obj) {
        Exceptions.die(String.format("Can't call this method on this type %s for field %s", this.type, this.name));
        return 0;
    }

    public boolean getStaticBoolean() {
        return this.getBoolean(this.base);
    }

    public int getStaticInt() {
        return this.getInt(this.base);
    }

    public short getStaticShort() {
        return this.getShort(this.base);
    }

    public long getStaticLong() {
        return this.getLong(this.base);
    }

    public double getStaticDouble() {
        return this.getDouble(this.base);
    }

    public float getStaticFloat() {
        return this.getFloat(this.base);
    }

    public byte getStaticByte() {
        return this.getByte(this.base);
    }

    public Object getObject() {
        return this.getObject(this.base);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public Object getBase() {
        return this.base;
    }

    @Override
    public void setBoolean(Object obj, boolean value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setInt(Object obj, int value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setShort(Object obj, short value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setChar(Object obj, char value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setLong(Object obj, long value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setDouble(Object obj, double value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setFloat(Object obj, float value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setByte(Object obj, byte value) {
        Exceptions.die(String.format("Can't call this method on this type %s", this.type));
    }

    @Override
    public void setObject(Object obj, Object value) {
        Exceptions.die(String.format("Can't call this method on this type %s name = %s  value type = %s", this.type, this.name, value == null ? "null" : value.getClass()));
    }

    private static class VolatileDoubleUnsafeField
    extends UnsafeField {
        protected VolatileDoubleUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setDouble(Object obj, double value) {
            unsafe.putDoubleVolatile(obj, this.offset, value);
        }

        @Override
        public double getDouble(Object obj) {
            return unsafe.getDoubleVolatile(obj, this.offset);
        }
    }

    private static class VolatileFloatUnsafeField
    extends UnsafeField {
        protected VolatileFloatUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setFloat(Object obj, float value) {
            unsafe.putFloatVolatile(obj, this.offset, value);
        }

        @Override
        public float getFloat(Object obj) {
            return unsafe.getFloatVolatile(obj, this.offset);
        }
    }

    private static class VolatileObjectUnsafeField
    extends UnsafeField {
        protected VolatileObjectUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setObject(Object obj, Object value) {
            unsafe.putObjectVolatile(obj, this.offset, value);
        }

        @Override
        public Object getObject(Object obj) {
            return unsafe.getObjectVolatile(obj, this.offset);
        }
    }

    private static class VolatileShortUnsafeField
    extends UnsafeField {
        protected VolatileShortUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setShort(Object obj, short value) {
            unsafe.putShortVolatile(obj, this.offset, value);
        }

        @Override
        public short getShort(Object obj) {
            return unsafe.getShortVolatile(obj, this.offset);
        }
    }

    private static class VolatileByteUnsafeField
    extends UnsafeField {
        protected VolatileByteUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setByte(Object obj, byte value) {
            unsafe.putByteVolatile(obj, this.offset, value);
        }

        @Override
        public byte getByte(Object obj) {
            return unsafe.getByteVolatile(obj, this.offset);
        }
    }

    private static class VolatileCharUnsafeField
    extends UnsafeField {
        protected VolatileCharUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setChar(Object obj, char value) {
            unsafe.putCharVolatile(obj, this.offset, value);
        }

        @Override
        public char getChar(Object obj) {
            return unsafe.getCharVolatile(obj, this.offset);
        }
    }

    private static class VolatileLongUnsafeField
    extends UnsafeField {
        protected VolatileLongUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setLong(Object obj, long value) {
            unsafe.putLongVolatile(obj, this.offset, value);
        }

        @Override
        public long getLong(Object obj) {
            return unsafe.getLongVolatile(obj, this.offset);
        }
    }

    private static class VolatileBooleanUnsafeField
    extends UnsafeField {
        protected VolatileBooleanUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setBoolean(Object obj, boolean value) {
            unsafe.putBooleanVolatile(obj, this.offset, value);
        }

        @Override
        public boolean getBoolean(Object obj) {
            return unsafe.getBooleanVolatile(obj, this.offset);
        }
    }

    private static class VolatileIntUnsafeField
    extends UnsafeField {
        protected VolatileIntUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setInt(Object obj, int value) {
            unsafe.putIntVolatile(obj, this.offset, value);
        }

        @Override
        public int getInt(Object obj) {
            return unsafe.getIntVolatile(obj, this.offset);
        }
    }

    private static class BooleanUnsafeField
    extends UnsafeField {
        protected BooleanUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setBoolean(Object obj, boolean value) {
            unsafe.putBoolean(obj, this.offset, value);
        }

        @Override
        public boolean getBoolean(Object obj) {
            return unsafe.getBoolean(obj, this.offset);
        }
    }

    private static class DoubleUnsafeField
    extends UnsafeField {
        protected DoubleUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setDouble(Object obj, double value) {
            unsafe.putDouble(obj, this.offset, value);
        }

        @Override
        public double getDouble(Object obj) {
            return unsafe.getDouble(obj, this.offset);
        }
    }

    private static class FloatUnsafeField
    extends UnsafeField {
        protected FloatUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setFloat(Object obj, float value) {
            unsafe.putFloat(obj, this.offset, value);
        }

        @Override
        public float getFloat(Object obj) {
            return unsafe.getFloat(obj, this.offset);
        }
    }

    private static class ObjectUnsafeField
    extends UnsafeField {
        protected ObjectUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setObject(Object obj, Object value) {
            unsafe.putObject(obj, this.offset, value);
        }

        @Override
        public Object getObject(Object obj) {
            return unsafe.getObject(obj, this.offset);
        }
    }

    private static class ShortUnsafeField
    extends UnsafeField {
        protected ShortUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setShort(Object obj, short value) {
            unsafe.putShort(obj, this.offset, value);
        }

        @Override
        public short getShort(Object obj) {
            return unsafe.getShort(obj, this.offset);
        }
    }

    private static class ByteUnsafeField
    extends UnsafeField {
        protected ByteUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setByte(Object obj, byte value) {
            unsafe.putByte(obj, this.offset, value);
        }

        @Override
        public byte getByte(Object obj) {
            return unsafe.getByte(obj, this.offset);
        }
    }

    private static class CharUnsafeField
    extends UnsafeField {
        protected CharUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setChar(Object obj, char value) {
            unsafe.putChar(obj, this.offset, value);
        }

        @Override
        public char getChar(Object obj) {
            return unsafe.getChar(obj, this.offset);
        }
    }

    private static class LongUnsafeField
    extends UnsafeField {
        protected LongUnsafeField(Field f) {
            super(f);
        }

        @Override
        public void setLong(Object obj, long value) {
            unsafe.putLong(obj, this.offset, value);
        }

        @Override
        public long getLong(Object obj) {
            return unsafe.getLong(obj, this.offset);
        }
    }

    private static final class IntUnsafeField
    extends UnsafeField {
        protected IntUnsafeField(Field f) {
            super(f);
        }

        @Override
        public final void setInt(Object obj, int value) {
            unsafe.putInt(obj, this.offset, value);
        }

        @Override
        public final int getInt(Object obj) {
            return unsafe.getInt(obj, this.offset);
        }
    }
}

