/*
 * Decompiled with CFR 0.152.
 */
package org.boon.datarepo.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.criteria.Update;
import org.boon.datarepo.DataRepoException;
import org.boon.datarepo.ObjectEditor;
import org.boon.datarepo.SearchableCollection;
import org.boon.datarepo.spi.ObjectEditorComposer;

public class ObjectEditorDefault<KEY, ITEM>
implements ObjectEditorComposer<KEY, ITEM>,
ObjectEditor<KEY, ITEM> {
    private Logger log = Logger.getLogger(ObjectEditorDefault.class.getName());
    protected SearchableCollection<KEY, ITEM> query;
    protected Map<String, FieldAccess> fields = new LinkedHashMap<String, FieldAccess>();
    private boolean hashCodeOptimization;
    private boolean lookupAndExcept;

    @Override
    public void put(ITEM item) {
        if (!this.add(item)) {
            throw new DataRepoException("Unable to addObject item " + item);
        }
    }

    @Override
    public void removeByKey(KEY key) {
        this.query.removeByKey(key);
    }

    @Override
    public void removeAll(ITEM ... items) {
        for (ITEM item : items) {
            this.delete(item);
        }
    }

    @Override
    public void removeAllAsync(Collection<ITEM> items) {
        for (ITEM item : items) {
            this.delete(item);
        }
    }

    @Override
    public void addAll(ITEM ... items) {
        for (ITEM item : items) {
            this.add(item);
        }
    }

    @Override
    public void addAllAsync(Collection<ITEM> items) {
        this.query.addAll(items);
    }

    @Override
    public void modifyAll(ITEM ... items) {
        for (ITEM item : items) {
            this.modify(item);
        }
    }

    @Override
    public void modifyAll(Collection<ITEM> items) {
        for (ITEM item : items) {
            this.modify(item);
        }
    }

    @Override
    public void modify(ITEM item) {
        KEY key = this.query.getKey(item);
        ITEM oldItem = this.doGet(key);
        if (oldItem != null) {
            this.delete(oldItem);
        } else {
            this.log.warning(String.format("An original item was not in the repo %s", item));
        }
        this.query.validateIndexes(item);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("This item %s was modified like this %s", oldItem, item));
        }
    }

    @Override
    public void update(ITEM item) {
        KEY key = this.query.getKey(item);
        ITEM oldItem = this.doGet(key);
        if (oldItem == null) {
            throw new DataRepoException("Unable to perform update, the object does not exist");
        }
        this.query.delete(oldItem);
        this.query.validateIndexes(item);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.format("This item %s was modified like this %s", oldItem, item));
        }
    }

    @Override
    public void modify(ITEM item, String property, Object value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setObject(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    private void optimizeHash(ITEM item) {
        if (!this.hashCodeOptimization) {
            return;
        }
        FieldAccess hashCode = this.fields.get("_hashCode");
        if (hashCode == null) {
            return;
        }
        hashCode.setInt(item, -1);
        hashCode.setInt(item, item.hashCode());
    }

    @Override
    public void modifyByValue(ITEM item, String property, String value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setValue(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, int value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setInt(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, long value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setLong(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, char value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setChar(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, short value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setShort(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, byte value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setByte(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, float value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setFloat(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, String property, double value) {
        item = this.lookupAndExpect(item);
        this.query.invalidateIndex(property, item);
        this.fields.get(property).setDouble(item, value);
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void modify(ITEM item, Update ... values) {
        item = this.lookupAndExpect(item);
        for (Update value : values) {
            this.query.invalidateIndex(value.getName(), item);
            value.doSet(this, item);
            this.optimizeHash(item);
            this.query.validateIndex(value.getName(), item);
        }
    }

    @Override
    public void update(KEY key, String property, Object value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, value);
        } else {
            fieldAccess.setObject(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void updateByValue(KEY key, String property, String value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setValue(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, int value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setInt(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, long value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setLong(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, char value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)Character.valueOf(value));
        } else {
            fieldAccess.setChar(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, short value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setShort(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, byte value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setByte(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, float value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)Float.valueOf(value));
        } else {
            fieldAccess.setFloat(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, String property, double value) {
        ITEM item = this.lookupAndExpectByKey(key);
        this.query.invalidateIndex(property, item);
        FieldAccess fieldAccess = this.fields.get(property);
        if (fieldAccess == null) {
            BeanUtils.idx(item, property, (Object)value);
        } else {
            fieldAccess.setDouble(item, value);
        }
        this.optimizeHash(item);
        this.query.validateIndex(property, item);
    }

    @Override
    public void update(KEY key, Update ... values) {
        ITEM item = this.lookupAndExpectByKey(key);
        for (Update value : values) {
            this.query.invalidateIndex(value.getName(), item);
            value.doSet(this, item);
            this.optimizeHash(item);
            this.query.validateIndex(value.getName(), item);
        }
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, Object compare, Object value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getObject(item).equals(compare)) {
            this.query.invalidateIndex(property, item);
            field.setObject(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, int compare, int value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getInt(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setInt(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, long compare, long value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getLong(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setLong(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, char compare, char value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getChar(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setChar(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, short compare, short value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getShort(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setShort(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, byte compare, byte value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getByte(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setByte(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, float compare, float value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getFloat(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setFloat(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndUpdate(KEY key, String property, double compare, double value) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getDouble(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setDouble(item, value);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, int compare) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getInt(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setInt(item, compare + 1);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, long compare) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getLong(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setLong(item, compare + 1L);
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, short compare) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getShort(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setShort(item, (short)(compare + 1));
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public boolean compareAndIncrement(KEY key, String property, byte compare) {
        ITEM item = this.lookupAndExpectByKey(key);
        FieldAccess field = this.fields.get(property);
        boolean set = false;
        if (field.getByte(item) == compare) {
            this.query.invalidateIndex(property, item);
            field.setByte(item, (byte)(compare + 1));
            set = true;
            this.optimizeHash(item);
            this.query.validateIndex(property, item);
        }
        return set;
    }

    @Override
    public void addAll(List<ITEM> items) {
        this.query.addAll(items);
    }

    @Override
    public boolean add(ITEM item) {
        return this.query.add(item);
    }

    @Override
    public void setFields(Map<String, FieldAccess> fields) {
        if (fields != null) {
            this.fields = fields;
        } else {
            fields = Collections.EMPTY_MAP;
        }
    }

    @Override
    public void setSearchableCollection(SearchableCollection searchableCollection) {
        this.query = searchableCollection;
    }

    @Override
    public void init() {
    }

    @Override
    public void hashCodeOptimizationOn() {
        this.hashCodeOptimization = true;
    }

    @Override
    public ITEM get(KEY key) {
        return this.query.get(key);
    }

    private ITEM doGet(KEY key) {
        return this.query.get(key);
    }

    @Override
    public KEY getKey(ITEM item) {
        return this.query.getKey(item);
    }

    private ITEM lookupAndExpect(ITEM item) {
        if (!this.lookupAndExcept) {
            return item;
        }
        KEY key = this.getKey(item);
        ITEM oldItem = this.doGet(key);
        if (oldItem == null) {
            throw new IllegalStateException(String.format("An original item was not in the repo %s", item));
        }
        return oldItem;
    }

    private ITEM lookupAndExpectByKey(KEY key) {
        ITEM oldItem = this.doGet(key);
        if (oldItem == null) {
            throw new IllegalStateException(String.format("An original item was not in the repo at this key %s", key));
        }
        return oldItem;
    }

    @Override
    public void clear() {
        this.query.clear();
    }

    @Override
    public boolean delete(ITEM item) {
        return this.query.delete(item);
    }

    @Override
    public List<ITEM> all() {
        return this.query.all();
    }

    @Override
    public int size() {
        return this.query.size();
    }

    @Override
    public Collection<ITEM> toCollection() {
        return this.query;
    }

    public SearchableCollection<KEY, ITEM> query() {
        return this.query;
    }

    @Override
    public Object readNestedValue(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyValue(item, properties);
    }

    @Override
    public int readNestedInt(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyInt(item, properties);
    }

    @Override
    public short readNestedShort(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyShort(item, properties);
    }

    @Override
    public char readNestedChar(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyChar(item, properties);
    }

    @Override
    public byte readNestedByte(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyByte(item, properties);
    }

    @Override
    public double readNestedDouble(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyDouble(item, properties);
    }

    @Override
    public float readNestedFloat(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyFloat(item, properties);
    }

    @Override
    public long readNestedLong(KEY key, String ... properties) {
        ITEM item = this.get(key);
        return BeanUtils.getPropertyLong(item, properties);
    }

    @Override
    public Object readObject(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getObject(item);
    }

    @Override
    public <T> T readValue(KEY key, String property, Class<T> type) {
        ITEM item = this.get(key);
        return (T)this.fields.get(property).getValue(item);
    }

    @Override
    public int readInt(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getInt(item);
    }

    @Override
    public long readLong(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getLong(item);
    }

    @Override
    public char readChar(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getChar(item);
    }

    @Override
    public short readShort(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getShort(item);
    }

    @Override
    public byte readByte(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getByte(item);
    }

    @Override
    public float readFloat(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getFloat(item);
    }

    @Override
    public double readDouble(KEY key, String property) {
        ITEM item = this.get(key);
        return this.fields.get(property).getDouble(item);
    }

    @Override
    public Object getObject(ITEM item, String property) {
        return this.fields.get(property).getObject(item);
    }

    @Override
    public <T> T getValue(ITEM item, String property, Class<T> type) {
        return (T)this.fields.get(property).getValue(item);
    }

    @Override
    public int getInt(ITEM item, String property) {
        return this.fields.get(property).getInt(item);
    }

    @Override
    public long getLong(ITEM item, String property) {
        return this.fields.get(property).getLong(item);
    }

    @Override
    public char getChar(ITEM item, String property) {
        return this.fields.get(property).getChar(item);
    }

    @Override
    public short getShort(ITEM item, String property) {
        return this.fields.get(property).getShort(item);
    }

    @Override
    public byte getByte(ITEM item, String property) {
        return this.fields.get(property).getByte(item);
    }

    @Override
    public float getFloat(ITEM item, String property) {
        return this.fields.get(property).getFloat(item);
    }

    @Override
    public double getDouble(ITEM item, String property) {
        return this.fields.get(property).getDouble(item);
    }

    @Override
    public void setLookupAndExcept(boolean lookupAndExcept) {
        this.lookupAndExcept = lookupAndExcept;
    }
}

