/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json.serializers.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.boon.Boon;
import org.boon.core.TypeType;
import org.boon.json.serializers.CustomObjectSerializer;
import org.boon.json.serializers.JsonSerializerInternal;
import org.boon.primitive.CharBuf;

public class SerializeUtils {
    public static void handleInstance(JsonSerializerInternal jsonSerializer, Object obj, CharBuf builder, Map<Class, CustomObjectSerializer> overrideMap, Set<Class> noHandle, boolean typeInfo, TypeType type) {
        Class<?> cls;
        if (overrideMap != null && (cls = Boon.cls(obj)) != null && !cls.isPrimitive() && !noHandle.contains(cls)) {
            Class<?>[] interfaces;
            CustomObjectSerializer customObjectSerializer = overrideMap.get(cls);
            if (customObjectSerializer != null) {
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            customObjectSerializer = overrideMap.get(cls.getSuperclass());
            if (customObjectSerializer != null) {
                overrideMap.put(cls.getSuperclass(), customObjectSerializer);
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            for (Class<?> interf : interfaces = cls.getInterfaces()) {
                customObjectSerializer = overrideMap.get(interf);
                if (customObjectSerializer == null) continue;
                overrideMap.put(interf, customObjectSerializer);
                customObjectSerializer.serializeObject(jsonSerializer, obj, builder);
                return;
            }
            noHandle.add(cls);
        }
        switch (type) {
            case MAP: {
                jsonSerializer.serializeMap((Map)obj, builder);
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                jsonSerializer.serializeCollection((Collection)obj, builder);
                return;
            }
            case INSTANCE: {
                jsonSerializer.serializeInstance(obj, builder, typeInfo);
                return;
            }
            case INTERFACE: 
            case ABSTRACT: {
                jsonSerializer.serializeSubtypeInstance(obj, builder);
                return;
            }
        }
        jsonSerializer.serializeUnknown(obj, builder);
    }
}

