/*
 * Decompiled with CFR 0.152.
 */
package org.boon.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.boon.Exceptions;
import org.boon.Str;
import org.boon.core.reflection.BeanUtils;
import org.boon.core.reflection.fields.FieldAccess;
import org.boon.primitive.Chr;
import org.boon.sort.SortType;
import org.boon.sort.Sorting;

public final class UniversalComparator
implements Comparator<Object> {
    final String sortBy;
    final Map<String, FieldAccess> fields;
    final SortType sortType;
    final List<Comparator> comparators;
    private final boolean byPath;

    public UniversalComparator(String sortBy, Map<String, FieldAccess> fields, SortType sortType, List<Comparator> comparators) {
        this.sortBy = sortBy;
        this.fields = fields;
        this.sortType = sortType;
        this.comparators = comparators;
        this.byPath = Str.in(Chr.array('.', '[', ']', '/'), sortBy);
    }

    @Override
    public final int compare(Object o1, Object o2) {
        int compare;
        block12: {
            Comparator comparator;
            Object value2;
            Object value1;
            if (this.byPath || o1 instanceof Map) {
                if (this.sortType == SortType.ASCENDING) {
                    value1 = BeanUtils.atIndex(o1, this.sortBy);
                    value2 = BeanUtils.atIndex(o2, this.sortBy);
                } else {
                    value1 = BeanUtils.atIndex(o2, this.sortBy);
                    value2 = BeanUtils.atIndex(o1, this.sortBy);
                }
            } else if (this.sortBy.equals("this") && o1 instanceof Comparable) {
                if (this.sortType == SortType.ASCENDING) {
                    value1 = o1;
                    value2 = o2;
                } else {
                    value1 = o2;
                    value2 = o1;
                }
            } else {
                FieldAccess field = this.fields.get(this.sortBy);
                if (field == null) {
                    Exceptions.die(Str.lines("The fields was null for sortBy " + this.sortBy, String.format("fields = %s", this.fields), String.format("Outer object type = %s", o1.getClass().getName()), String.format("Outer object is %s", o1)));
                }
                if (this.sortType == SortType.ASCENDING) {
                    value1 = field.getValue(o1);
                    value2 = field.getValue(o2);
                } else {
                    value1 = field.getValue(o2);
                    value2 = field.getValue(o1);
                }
            }
            compare = Sorting.compare(value1, value2);
            if (compare != 0) break block12;
            Iterator<Comparator> i$ = this.comparators.iterator();
            while (i$.hasNext() && (compare = (comparator = i$.next()).compare(o1, o2)) == 0) {
            }
        }
        return compare;
    }

    public static Comparator universalComparator(String sortBy, Map<String, FieldAccess> fields, SortType sortType, List<Comparator> comparators) {
        return new UniversalComparator(sortBy, fields, sortType, comparators);
    }
}

