/*
 * Decompiled with CFR 0.152.
 */
package org.boon.template;

import java.util.ArrayList;
import java.util.List;
import org.boon.Boon;
import org.boon.Str;
import org.boon.core.reflection.FastStringUtils;
import org.boon.primitive.CharScanner;
import org.boon.template.TemplateParser;
import org.boon.template.support.Token;
import org.boon.template.support.TokenTypes;

public class BoonModernTemplateParser
implements TemplateParser {
    char[] charArray;
    int index;
    int ch;
    private List<Token> tokenList = new ArrayList<Token>();

    public void TemplateParser() {
    }

    @Override
    public void parse(String string) {
        this.charArray = FastStringUtils.toCharArray(string);
        this.index = 0;
        this.tokenList.clear();
        this.processLoop();
    }

    @Override
    public List<Token> getTokenList() {
        return this.tokenList;
    }

    @Override
    public void displayTokens(String template) {
        for (Token token : this.getTokenList()) {
            Boon.puts("token", token, Str.slc(template, token.start(), token.stop()));
        }
    }

    private void processLoop() {
        do {
            int startIndex = this.index;
            this.index = CharScanner.findChars(TokenTypes.EXPRESSION_START.handleBarStyle(), this.index, this.charArray);
            if (this.index != -1) {
                if (startIndex != this.index) {
                    this.tokenList.add(Token.text(startIndex, this.index));
                }
                this.index += TokenTypes.EXPRESSION_START.handleBarStyle().length;
                if (this.handleCommandOrExpression()) continue;
                break;
            }
            if (startIndex == this.charArray.length) break;
            this.tokenList.add(Token.text(startIndex, this.charArray.length));
            break;
        } while (this.index <= this.charArray.length && this.index != -1);
    }

    private boolean handleCommandOrExpression() {
        if (this.index > this.charArray.length) {
            return false;
        }
        this.ch = this.charArray[this.index];
        if (this.ch == 35) {
            return this.handleCommand();
        }
        if (this.ch == 33) {
            return this.handleComment();
        }
        return this.handleExpression();
    }

    private boolean handleComment() {
        ++this.index;
        int foundIndex = CharScanner.findChars(TokenTypes.EXPRESSION_END.handleBarStyle(), this.index, this.charArray);
        if (foundIndex == -1) {
            return false;
        }
        this.index = foundIndex + TokenTypes.EXPRESSION_END.handleBarStyle().length;
        return true;
    }

    private boolean handleExpression() {
        int startIndex = this.index;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.handleBarStyle(), this.index, this.charArray);
        if (this.index > 0) {
            char c;
            this.tokenList.add(Token.expression(startIndex, this.index));
            this.index += TokenTypes.EXPRESSION_END.handleBarStyle().length;
            if (this.index < this.charArray.length && (c = this.charArray[this.index]) == '}') {
                ++this.index;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleCommand() {
        int startIndex = this.index + 1;
        this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.handleBarStyle(), this.index, this.charArray);
        if (this.index == -1) {
            return false;
        }
        this.tokenList.add(Token.commandStart(startIndex, this.index));
        this.index += TokenTypes.EXPRESSION_END.handleBarStyle().length;
        Token commandBody = Token.commandBody(this.index, -1);
        this.tokenList.add(commandBody);
        while (true) {
            startIndex = this.index;
            this.index = CharScanner.findChars(TokenTypes.EXPRESSION_START.handleBarStyle(), this.index, this.charArray);
            if (this.index == -1) {
                return false;
            }
            if (startIndex != this.index) {
                this.tokenList.add(Token.text(startIndex, this.index));
            }
            this.index += TokenTypes.EXPRESSION_START.handleBarStyle().length;
            if (this.index >= this.charArray.length) {
                return false;
            }
            this.ch = this.charArray[this.index];
            if (this.ch == 35) {
                if (this.handleCommand()) continue;
                return true;
            }
            if (this.ch == 47) {
                commandBody.stop(this.index - 2);
                this.index = CharScanner.findChars(TokenTypes.EXPRESSION_END.handleBarStyle(), this.index, this.charArray);
                if (this.index < 0) {
                    return false;
                }
                this.index += TokenTypes.EXPRESSION_END.handleBarStyle().length;
                return true;
            }
            if (!this.handleExpression()) return true;
        }
    }

    private Token textToken(Token text) {
        if (text != null) {
            text.stop(this.index);
            if (text.start() != text.stop()) {
                this.tokenList.add(text);
            }
            text = null;
        }
        return text;
    }
}

