/*
 * Decompiled with CFR 0.152.
 */
package org.boon.etcd;

import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.boon.Boon;
import org.boon.Exceptions;
import org.boon.IO;
import org.boon.Logger;
import org.boon.Str;
import org.boon.core.Handler;
import org.boon.core.Sys;
import org.boon.etcd.ClientBuilder;
import org.boon.etcd.Error;
import org.boon.etcd.Etcd;
import org.boon.etcd.RedirectResponse;
import org.boon.etcd.Request;
import org.boon.etcd.Response;
import org.boon.etcd.exceptions.ConnectionException;
import org.boon.etcd.exceptions.TimeoutException;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;
import org.boon.primitive.Arry;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;

public class EtcdClient
implements Etcd {
    private final Vertx vertx;
    private final URI[] hosts;
    private HttpClient httpClient;
    private AtomicBoolean closed = new AtomicBoolean();
    private AtomicInteger currentIndex = new AtomicInteger(-1);
    private final SSLContext sslContext;
    private final boolean useSSL;
    private final int poolSize;
    private final int timeOutInMilliseconds;
    private final String sslTrustStorePath;
    private final String sslTrustStorePassword;
    private final String sslKeyStorePath;
    private final String sslKeyStorePassword;
    private final boolean sslAuthRequired;
    private final boolean followLeader;
    private final boolean sslTrustAll;
    private Logger logger = Boon.configurableLogger(EtcdClient.class);
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);
    private ThreadLocal<JsonParserAndMapper> jsonParserAndMapperThreadLocal = new ThreadLocal<JsonParserAndMapper>(){

        @Override
        protected JsonParserAndMapper initialValue() {
            return new JsonParserFactory().create();
        }
    };

    protected EtcdClient(Vertx vertx, ClientBuilder builder) {
        this.vertx = vertx == null ? VertxFactory.newVertx() : vertx;
        this.sslAuthRequired = builder.sslAuthRequired();
        this.sslTrustAll = builder.sslTrustAll();
        this.sslKeyStorePassword = builder.sslKeyStorePassword();
        this.sslTrustStorePassword = builder.sslTrustStorePassword();
        this.sslKeyStorePath = builder.sslKeyStorePath();
        this.sslTrustStorePath = builder.sslTrustStorePath();
        this.timeOutInMilliseconds = builder.timeOutInMilliseconds();
        this.useSSL = builder.useSSL();
        this.poolSize = builder.poolSize();
        this.hosts = (URI[])Arry.array(builder.hosts());
        this.sslContext = builder.sslContext();
        this.followLeader = builder.followLeader();
        this.connect();
    }

    protected EtcdClient(ClientBuilder builder) {
        this(null, builder);
    }

    @Override
    public Response delete(String key) {
        return this.request(Request.request().methodDELETE().key(key));
    }

    @Override
    public void delete(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().methodDELETE().key(key));
    }

    @Override
    public Response deleteDir(String key) {
        return this.request(Request.request().methodDELETE().key(key).dir(true));
    }

    @Override
    public void deleteDir(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().methodDELETE().key(key).dir(true));
    }

    @Override
    public Response deleteDirRecursively(String key) {
        return this.request(Request.request().methodDELETE().key(key).dir(true).recursive(true));
    }

    @Override
    public void deleteDirRecursively(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().methodDELETE().key(key).dir(true).recursive(true));
    }

    @Override
    public Response deleteIfAtIndex(String key, long index) {
        return this.request(Request.request().methodDELETE().key(key).prevIndex(index));
    }

    @Override
    public void deleteIfAtIndex(Handler<Response> responseHandler, String key, long index) {
        this.request(responseHandler, Request.request().methodDELETE().key(key).prevIndex(index));
    }

    @Override
    public Response deleteIfValue(String key, String prevValue) {
        return this.request(Request.request().methodDELETE().key(key).prevValue(prevValue));
    }

    @Override
    public void deleteIfValue(Handler<Response> responseHandler, String key, String prevValue) {
        this.request(responseHandler, Request.request().methodDELETE().key(key).prevValue(prevValue));
    }

    @Override
    public void request(Handler<Response> responseHandler, Request request) {
        URI host = this.hosts[this.currentIndex.get()];
        request.host(host.getHost()).port(host.getPort());
        this.sendHttpRequest(request, responseHandler);
    }

    @Override
    public Response request(Request request) {
        final ArrayBlockingQueue<Response> responseBlockingQueue = new ArrayBlockingQueue<Response>(1);
        this.request(new Handler<Response>(){

            public void handle(Response event) {
                responseBlockingQueue.offer(event);
            }
        }, request);
        return this.getResponse(request.key(), responseBlockingQueue);
    }

    public Response requestForever(Request request) {
        final ArrayBlockingQueue<Response> responseBlockingQueue = new ArrayBlockingQueue<Response>(1);
        this.request(new Handler<Response>(){

            public void handle(Response event) {
                responseBlockingQueue.offer(event);
            }
        }, request);
        return this.getResponseWaitForever(request.key(), responseBlockingQueue);
    }

    @Override
    public void createDir(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().methodPUT().key(key).dir(true));
    }

    @Override
    public Response createDir(String key) {
        return this.request(Request.request().methodPUT().key(key).dir(true));
    }

    @Override
    public Response createTempDir(String key, long ttl) {
        return this.request(Request.request().methodPUT().key(key).ttl(ttl).dir(true));
    }

    @Override
    public void createTempDir(Handler<Response> responseHandler, String key, long ttl) {
        this.request(responseHandler, Request.request().methodPUT().key(key).ttl(ttl).dir(true));
    }

    @Override
    public Response updateDirTTL(String key, long ttl) {
        return this.request(Request.request().methodPUT().key(key).ttl(ttl).dir(true).prevExist(true));
    }

    @Override
    public void updateDirTTL(Handler<Response> responseHandler, String name, long ttl) {
        this.request(responseHandler, Request.request().methodPUT().key(name).ttl(ttl).dir(true).prevExist(true));
    }

    @Override
    public Response list(String key) {
        return this.get(key);
    }

    @Override
    public void list(Handler<Response> responseHandler, String key) {
        this.get(responseHandler, key);
    }

    @Override
    public Response listRecursive(String key) {
        return this.request(Request.request().key(key).recursive(true));
    }

    @Override
    public void listRecursive(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().key(key).recursive(true));
    }

    @Override
    public Response listSorted(String key) {
        return this.request(Request.request().key(key).recursive(true).sorted(true));
    }

    @Override
    public void listSorted(Handler<Response> responseHandler, String key) {
        this.request(responseHandler, Request.request().key(key).recursive(true).sorted(true));
    }

    private void sendHttpRequest(final Request request, final Handler<Response> responseHandler) {
        final HttpClientRequest httpClientRequest = this.httpClient.request(request.getMethod(), request.uri(), this.handleResponse(request, responseHandler));
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!request.getMethod().equals("GET")) {
                    httpClientRequest.putHeader("Content-Type", "application/x-www-form-urlencoded").end(request.paramBody());
                } else {
                    httpClientRequest.end();
                }
            }
        };
        if (this.closed.get()) {
            this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    EtcdClient.this.connect();
                    int retry = 0;
                    while (EtcdClient.this.closed.get()) {
                        Sys.sleep((long)1000L);
                        if (!EtcdClient.this.closed.get() || ++retry > 10) break;
                        if (retry % 3 != 0) continue;
                        EtcdClient.this.connect();
                    }
                    if (!EtcdClient.this.closed.get()) {
                        runnable.run();
                    } else {
                        responseHandler.handle((Object)new Response("TIMEOUT", -1, new Error(-1, "Timeout", "Timeout", -1L)));
                    }
                }
            }, 10L, TimeUnit.MILLISECONDS);
        } else {
            runnable.run();
        }
    }

    @Override
    public Response addToDir(String dirName, String key, String value) {
        return this.request(Request.request().methodPOST().key(Str.add((String[])new String[]{dirName, "/", key})).value(value));
    }

    @Override
    public void addToDir(Handler<Response> responseHandler, String dirName, String key, String value) {
        this.request(responseHandler, Request.request().methodPOST().key(Str.add((String[])new String[]{dirName, "/", key})).value(value));
    }

    @Override
    public Response set(String key, String value) {
        return this.request(Request.request().methodPUT().key(Str.add((String[])new String[]{key})).value(value));
    }

    @Override
    public void set(Handler<Response> responseHandler, String key, String value) {
        this.request(responseHandler, Request.request().methodPUT().key(Str.add((String[])new String[]{key})).value(value));
    }

    @Override
    public Response setConfigFile(String key, String fileName) {
        if (!IO.exists((String)fileName)) {
            Exceptions.die((Object[])new Object[]{"setConfigFile", "file name does not exist", fileName});
        }
        return this.set(key, IO.read((String)fileName));
    }

    @Override
    public void setConfigFile(Handler<Response> responseHandler, String key, String fileName) {
        if (!IO.exists((String)fileName)) {
            Exceptions.die((Object[])new Object[]{"setConfigFile", "file name does not exist", fileName});
        }
        this.set(responseHandler, key, IO.read((String)fileName));
    }

    @Override
    public Response setIfExists(String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevExist(true);
        return this.request(request);
    }

    @Override
    public void setIfExists(Handler<Response> responseHandler, String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevExist(true);
        this.request(responseHandler, request);
    }

    @Override
    public Response setIfNotExists(String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevExist(false);
        return this.request(request);
    }

    @Override
    public void setIfNotExists(Handler<Response> responseHandler, String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevExist(false);
        this.request(responseHandler, request);
    }

    @Override
    public Response compareAndSwapByValue(String key, String prevValue, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevValue(prevValue);
        return this.request(request);
    }

    @Override
    public void compareAndSwapByValue(Handler<Response> responseHandler, String key, String prevValue, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevValue(prevValue);
        this.request(responseHandler, request);
    }

    @Override
    public Response compareAndSwapByModifiedIndex(String key, long prevIndex, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevIndex(prevIndex);
        return this.request(request);
    }

    @Override
    public void compareAndSwapByModifiedIndex(Handler<Response> responseHandler, String key, long prevIndex, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).prevIndex(prevIndex);
        this.request(responseHandler, request);
    }

    @Override
    public Response setTemp(String key, String value, int ttl) {
        Request request = Request.request().methodPUT().key(key).value(value).ttl(ttl);
        return this.request(request);
    }

    @Override
    public void setTemp(Handler<Response> responseHandler, String key, String value, int ttl) {
        Request request = Request.request().methodPUT().key(key).value(value).ttl(ttl);
        this.request(responseHandler, request);
    }

    @Override
    public Response removeTTL(String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).emptyTTL().prevExist(true);
        return this.request(request);
    }

    @Override
    public void removeTTL(Handler<Response> responseHandler, String key, String value) {
        Request request = Request.request().methodPUT().key(key).value(value).emptyTTL().prevExist(true);
        this.request(responseHandler, request);
    }

    @Override
    public Response get(String key) {
        Request request = Request.request().key(key);
        return this.request(request);
    }

    @Override
    public void get(Handler<Response> responseHandler, String key) {
        Request request = Request.request().key(key);
        this.request(responseHandler, request);
    }

    @Override
    public Response getConsistent(String key) {
        Request request = Request.request().key(key).consistent(true);
        return this.request(request);
    }

    @Override
    public void getConsistent(Handler<Response> responseHandler, String key) {
        Request request = Request.request().key(key).consistent(true);
        this.request(responseHandler, request);
    }

    @Override
    public Response wait(String key) {
        Request request = Request.request().key(key).wait(true);
        return this.requestForever(request);
    }

    @Override
    public void wait(Handler<Response> responseHandler, String key) {
        Request request = Request.request().key(key).wait(true);
        this.request(responseHandler, request);
    }

    @Override
    public Response wait(String key, long index) {
        Request request = Request.request().key(key).wait(true).waitIndex(index);
        return this.requestForever(request);
    }

    @Override
    public void wait(Handler<Response> responseHandler, String key, long index) {
        Request request = Request.request().key(key).wait(true).waitIndex(index);
        this.request(responseHandler, request);
    }

    @Override
    public Response waitRecursive(String key) {
        Request request = Request.request().key(key).wait(true).recursive(true);
        return this.requestForever(request);
    }

    @Override
    public void waitRecursive(Handler<Response> responseHandler, String key) {
        Request request = Request.request().key(key).wait(true).recursive(true);
        this.request(responseHandler, request);
    }

    @Override
    public Response waitRecursive(String key, long index) {
        Request request = Request.request().key(key).wait(true).recursive(true).waitIndex(index);
        return this.requestForever(request);
    }

    @Override
    public void waitRecursive(Handler<Response> responseHandler, String key, long index) {
        Request request = Request.request().key(key).wait(true).recursive(true).waitIndex(index);
        this.request(responseHandler, request);
    }

    private Response getResponse(String key, BlockingQueue<Response> responseBlockingQueue) {
        try {
            Response response = responseBlockingQueue.poll(this.timeOutInMilliseconds, TimeUnit.MILLISECONDS);
            if (response == null) {
                if (this.closed.get()) {
                    throw new ConnectionException(Str.add((String)"Connection exception for key ", (String)key));
                }
                throw new TimeoutException(Str.add((String)"Response timeout for get request key=", (String)key));
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    private Response getResponseWaitForever(String key, BlockingQueue<Response> responseBlockingQueue) {
        try {
            Response response = responseBlockingQueue.take();
            if (response == null) {
                Exceptions.die((Object[])new Object[]{"Response timeout for get request key=", key});
            }
            return response;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
    }

    private Response createResponseFromException(Request request, Throwable throwable) {
        this.logger.error(throwable, new Object[]{"Unable to connect to ", request.toString(), request.key()});
        if (throwable instanceof ConnectException) {
            this.closed.set(true);
            Error error = new Error(-1, throwable.getClass().getName(), Str.add((String)"Unable to connect", (String)request.toString()), 0L);
            return new Response(request.toString(), -1, error);
        }
        Error error = new Error(-1, throwable.getClass().getName(), Str.add((String[])new String[]{throwable.getMessage(), " Unable to connect to ", request.toString(), " key ", request.key()}), 0L);
        return new Response(request.toString(), -1, error);
    }

    private org.vertx.java.core.Handler<HttpClientResponse> handleResponse(final Request request, final Handler<Response> handler) {
        return new org.vertx.java.core.Handler<HttpClientResponse>(){

            public void handle(final HttpClientResponse httpClientResponse) {
                final Buffer buffer = new Buffer(1000);
                ((HttpClientResponse)((HttpClientResponse)httpClientResponse.dataHandler((org.vertx.java.core.Handler)new org.vertx.java.core.Handler<Buffer>(){

                    public void handle(Buffer partialBuf) {
                        buffer.appendBuffer(partialBuf);
                    }
                })).endHandler((org.vertx.java.core.Handler)new org.vertx.java.core.Handler<Void>(){

                    public void handle(Void aVoid) {
                        String json = buffer.toString();
                        Response response = EtcdClient.this.parseResponse(json, request, (Handler<Response>)handler, httpClientResponse);
                        if (!EtcdClient.this.followLeader || !(response instanceof RedirectResponse)) {
                            handler.handle((Object)response);
                        }
                    }
                })).exceptionHandler((org.vertx.java.core.Handler)new org.vertx.java.core.Handler<Throwable>(){

                    public void handle(Throwable event) {
                        EtcdClient.this.logger.debug(event, new Object[]{Str.add((String)"Unable to connect to ", (String)request.toString())});
                        Response response = EtcdClient.this.createResponseFromException(request, event);
                        handler.handle((Object)response);
                    }
                });
            }
        };
    }

    private Response parseResponse(String json, Request request, Handler<Response> handler, HttpClientResponse httpClientResponse) {
        try {
            switch (httpClientResponse.statusCode()) {
                case 307: {
                    RedirectResponse response = new RedirectResponse(httpClientResponse.headers().get("Location"));
                    if (this.followLeader) {
                        Etcd client = ClientBuilder.builder().hosts(response.location()).createClient();
                        client.request(handler, request);
                    }
                    return response;
                }
                case 200: {
                    Response response = (Response)this.jsonParserAndMapperThreadLocal.get().parse(Response.class, json);
                    response.setHttpStatusCode(httpClientResponse.statusCode());
                    return response;
                }
                case 201: {
                    Response response = (Response)this.jsonParserAndMapperThreadLocal.get().parse(Response.class, json);
                    response.setHttpStatusCode(httpClientResponse.statusCode());
                    response.setCreated();
                    return response;
                }
                case 404: {
                    Error notFound = (Error)this.jsonParserAndMapperThreadLocal.get().parse(Error.class, json);
                    Response response = new Response(request.toString(), httpClientResponse.statusCode(), notFound);
                    return response;
                }
            }
            if (!Boon.isEmpty((Object)json) && (json.contains("cause") || json.contains("errorCode"))) {
                Error error = (Error)this.jsonParserAndMapperThreadLocal.get().parse(Error.class, json);
                Response response = new Response(request.toString(), httpClientResponse.statusCode(), error);
                return response;
            }
            if (!Boon.isEmpty((Object)json)) {
                Response response = (Response)this.jsonParserAndMapperThreadLocal.get().parse(Response.class, json);
                response.setHttpStatusCode(httpClientResponse.statusCode());
                return response;
            }
            Exceptions.die((Object[])new Object[]{httpClientResponse.statusCode(), httpClientResponse.headers().entries()});
            return null;
        }
        catch (Exception ex) {
            if (!Str.isEmpty((String)json)) {
                return this.createResponseFromException(request, ex);
            }
            return this.createResponseFromException(request, ex);
        }
    }

    private void connect() {
        int index;
        int oldIndex = index = this.currentIndex.get();
        index = index + 1 == this.hosts.length ? 0 : ++index;
        if (this.currentIndex.compareAndSet(oldIndex, index)) {
            final URI uri = this.hosts[index];
            this.logger.info(new Object[]{"Connecting to ", uri});
            this.httpClient = this.vertx.createHttpClient().setHost(uri.getHost()).setPort(uri.getPort()).setConnectTimeout(this.timeOutInMilliseconds).setMaxPoolSize(this.poolSize);
            this.httpClient.exceptionHandler((org.vertx.java.core.Handler)new org.vertx.java.core.Handler<Throwable>(){

                public void handle(Throwable throwable) {
                    if (throwable instanceof ConnectException) {
                        EtcdClient.this.closed.set(true);
                    } else {
                        EtcdClient.this.logger.error(throwable, new Object[]{"Unable to connect to ", uri});
                    }
                }
            });
            this.configureSSL(this.httpClient);
            this.closed.set(false);
        }
    }

    private void configureSSL(HttpClient httpClient) {
        if (!this.useSSL) {
            return;
        }
        if (this.sslAuthRequired) {
            httpClient.setKeyStorePassword(this.sslKeyStorePassword);
            httpClient.setKeyStorePath(this.sslKeyStorePath);
        }
        if (!Str.isEmpty((String)this.sslTrustStorePath)) {
            httpClient.setTrustStorePassword(this.sslTrustStorePassword);
            httpClient.setTrustStorePassword(this.sslTrustStorePath);
        }
        if (this.sslTrustAll) {
            httpClient.setTrustAll(true);
        }
        if (this.sslContext == null) {
            httpClient.setSSLContext(this.sslContext);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

