/*
 * Decompiled with CFR 0.152.
 */
package org.boon.etcd;

import org.boon.Boon;
import org.boon.etcd.Error;
import org.boon.etcd.Node;

public class Response {
    private final String action;
    private final Node node;
    private final Error error;
    private int responseCode;
    private boolean created;

    public Response(String action, int responseCode, Node node) {
        this.action = action;
        this.node = node;
        this.error = null;
        this.responseCode = responseCode;
    }

    public Response(String action, int responseCode, Error error) {
        this.action = action;
        this.node = null;
        this.error = error;
        this.responseCode = responseCode;
    }

    public boolean wasError() {
        return this.error != null;
    }

    public boolean successful() {
        return !this.wasError();
    }

    public String action() {
        return this.action;
    }

    public Node node() {
        return this.node;
    }

    public int responseCode() {
        return this.responseCode;
    }

    public String toString() {
        return Boon.toPrettyJson((Object)this);
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.responseCode = httpStatusCode;
    }

    public void setCreated() {
        this.created = true;
    }
}

