/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.sse.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.featurehub.sse.model.FeatureState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureEnvironmentCollection {
    @JsonProperty(value="id")
    @NotNull
    private UUID id;
    @JsonProperty(value="features")
    @Nullable
    private List<FeatureState> features = new ArrayList<FeatureState>();

    public FeatureEnvironmentCollection id(@NotNull UUID id) {
        this.id = id;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(@NotNull UUID id) {
        this.id = id;
    }

    public FeatureEnvironmentCollection features(@Nullable List<FeatureState> features) {
        this.features = features;
        return this;
    }

    public FeatureEnvironmentCollection addFeaturesItem(FeatureState featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<FeatureState>();
        }
        this.features.add(featuresItem);
        return this;
    }

    public List<FeatureState> getFeatures() {
        return this.features;
    }

    public void setFeatures(@Nullable List<FeatureState> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureEnvironmentCollection featureEnvironmentCollection = (FeatureEnvironmentCollection)o;
        return Objects.equals(this.id, featureEnvironmentCollection.id) && Objects.equals(this.features, featureEnvironmentCollection.features);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.features);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureEnvironmentCollection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public FeatureEnvironmentCollection copy() {
        FeatureEnvironmentCollection copy = new FeatureEnvironmentCollection();
        copy.setId(this.getId());
        copy.setFeatures((List<FeatureState>)(this.getFeatures() == null ? null : new ArrayList<FeatureState>(this.getFeatures())));
        return copy;
    }
}

