/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.sse.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.featurehub.sse.model.FeatureRolloutStrategy;
import io.featurehub.sse.model.FeatureValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureState {
    @JsonProperty(value="id")
    @NotNull
    private UUID id;
    @JsonProperty(value="key")
    @NotNull
    private String key;
    @JsonProperty(value="l")
    @Nullable
    private Boolean l;
    @JsonProperty(value="version")
    @Nullable
    private Long version;
    @JsonProperty(value="type")
    @Nullable
    private FeatureValueType type;
    @JsonProperty(value="value")
    @Nullable
    private Object value = null;
    @JsonProperty(value="environmentId")
    @Nullable
    private UUID environmentId;
    @JsonProperty(value="strategies")
    @Nullable
    private List<FeatureRolloutStrategy> strategies = new ArrayList<FeatureRolloutStrategy>();

    public FeatureState id(@NotNull UUID id) {
        this.id = id;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(@NotNull UUID id) {
        this.id = id;
    }

    public FeatureState key(@NotNull String key) {
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(@NotNull String key) {
        this.key = key;
    }

    public FeatureState l(@Nullable Boolean l) {
        this.l = l;
        return this;
    }

    public Boolean getL() {
        return this.l;
    }

    public void setL(@Nullable Boolean l) {
        this.l = l;
    }

    public FeatureState version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public FeatureState type(@Nullable FeatureValueType type) {
        this.type = type;
        return this;
    }

    public FeatureValueType getType() {
        return this.type;
    }

    public void setType(@Nullable FeatureValueType type) {
        this.type = type;
    }

    public FeatureState value(@Nullable Object value) {
        this.value = value;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    public FeatureState environmentId(@Nullable UUID environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public UUID getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(@Nullable UUID environmentId) {
        this.environmentId = environmentId;
    }

    public FeatureState strategies(@Nullable List<FeatureRolloutStrategy> strategies) {
        this.strategies = strategies;
        return this;
    }

    public FeatureState addStrategiesItem(FeatureRolloutStrategy strategiesItem) {
        if (this.strategies == null) {
            this.strategies = new ArrayList<FeatureRolloutStrategy>();
        }
        this.strategies.add(strategiesItem);
        return this;
    }

    public List<FeatureRolloutStrategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(@Nullable List<FeatureRolloutStrategy> strategies) {
        this.strategies = strategies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureState featureState = (FeatureState)o;
        return Objects.equals(this.id, featureState.id) && Objects.equals(this.key, featureState.key) && Objects.equals(this.l, featureState.l) && Objects.equals(this.version, featureState.version) && Objects.equals((Object)this.type, (Object)featureState.type) && Objects.equals(this.value, featureState.value) && Objects.equals(this.environmentId, featureState.environmentId) && Objects.equals(this.strategies, featureState.strategies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.l, this.version, this.type, this.value, this.environmentId, this.strategies});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureState {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    l: ").append(this.toIndentedString(this.l)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    strategies: ").append(this.toIndentedString(this.strategies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public FeatureState copy() {
        FeatureState copy = new FeatureState();
        copy.setId(this.getId());
        copy.setKey(this.getKey());
        copy.setL(this.getL());
        copy.setVersion(this.getVersion());
        copy.setType(this.getType());
        copy.setValue(this.getValue());
        copy.setEnvironmentId(this.getEnvironmentId());
        copy.setStrategies((List<FeatureRolloutStrategy>)(this.getStrategies() == null ? null : new ArrayList<FeatureRolloutStrategy>(this.getStrategies())));
        return copy;
    }
}

