/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.sse.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum FeatureValueType {
    BOOLEAN("BOOLEAN"),
    STRING("STRING"),
    NUMBER("NUMBER"),
    JSON("JSON");

    private String value;
    private static Map<String, FeatureValueType> fromValues;

    private FeatureValueType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public FeatureValueType copy() {
        return this;
    }

    @JsonCreator
    public static FeatureValueType fromValue(String text) {
        return fromValues.get(text);
    }

    static {
        fromValues = new HashMap<String, FeatureValueType>();
        fromValues.put("BOOLEAN", BOOLEAN);
        fromValues.put("BOOLEAN", BOOLEAN);
        fromValues.put("STRING", STRING);
        fromValues.put("STRING", STRING);
        fromValues.put("NUMBER", NUMBER);
        fromValues.put("NUMBER", NUMBER);
        fromValues.put("JSON", JSON);
        fromValues.put("JSON", JSON);
    }
}

