/*
 * FeatureServiceApi
 * This describes the API clients use for accessing features
 *
 * OpenAPI spec version: 1.1.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.featurehub.sse.model;

import java.util.Objects;
import java.util.Arrays;
import io.featurehub.sse.model.FeatureRolloutStrategy;
import io.featurehub.sse.model.FeatureValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.*;
/**
 * FeatureState
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@jakarta.annotation.Generated(value = "cd.connect.openapi.Jersey3ApiGenerator", date = "2022-11-02T19:35:08.639013+13:00[Pacific/Auckland]")


public class FeatureState {
  @JsonProperty("id")
    @org.jetbrains.annotations.NotNull
  private UUID id;

  @JsonProperty("key")
    @org.jetbrains.annotations.NotNull
  private String key;

  @JsonProperty("l")
    @org.jetbrains.annotations.Nullable
  private Boolean l;

  @JsonProperty("version")
    @org.jetbrains.annotations.Nullable
  private Long version;

  @JsonProperty("type")
    @org.jetbrains.annotations.Nullable
  private FeatureValueType type;

  @JsonProperty("value")
    @org.jetbrains.annotations.Nullable
  private Object value;

  @JsonProperty("environmentId")
    @org.jetbrains.annotations.Nullable
  private UUID environmentId;

  @JsonProperty("strategies")
    @org.jetbrains.annotations.Nullable
  private List<FeatureRolloutStrategy> strategies = new ArrayList<>();

  public FeatureState id(@org.jetbrains.annotations.NotNull UUID id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/

  public UUID getId() {
    return id;
  }

  public void setId(@org.jetbrains.annotations.NotNull UUID id) {
    this.id = id;
  }

  public FeatureState key(@org.jetbrains.annotations.NotNull String key) {
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/

  public String getKey() {
    return key;
  }

  public void setKey(@org.jetbrains.annotations.NotNull String key) {
    this.key = key;
  }

  public FeatureState l(@org.jetbrains.annotations.Nullable Boolean l) {
    this.l = l;
    return this;
  }

   /**
   * Is this feature locked. Usually this doesn&#39;t matter because the value is the value, but for FeatureInterceptors it can matter.
   * @return l
  **/

  public Boolean getL() {
    return l;
  }

  public void setL(@org.jetbrains.annotations.Nullable Boolean l) {
    this.l = l;
  }

  public FeatureState version(@org.jetbrains.annotations.Nullable Long version) {
    this.version = version;
    return this;
  }

   /**
   * The version of the feature, this allows features to change values and it means we don&#39;t trigger events
   * @return version
  **/

  public Long getVersion() {
    return version;
  }

  public void setVersion(@org.jetbrains.annotations.Nullable Long version) {
    this.version = version;
  }

  public FeatureState type(@org.jetbrains.annotations.Nullable FeatureValueType type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/

  public FeatureValueType getType() {
    return type;
  }

  public void setType(@org.jetbrains.annotations.Nullable FeatureValueType type) {
    this.type = type;
  }

  public FeatureState value(@org.jetbrains.annotations.Nullable Object value) {
    this.value = value;
    return this;
  }

   /**
   * the current value
   * @return value
  **/

  public Object getValue() {
    return value;
  }

  public void setValue(@org.jetbrains.annotations.Nullable Object value) {
    this.value = value;
  }

  public FeatureState environmentId(@org.jetbrains.annotations.Nullable UUID environmentId) {
    this.environmentId = environmentId;
    return this;
  }

   /**
   * This field is filled in from the client side in the GET api as the GET api is able to request multiple environments. It is never passed from the server, as an array of feature states is wrapped in an environment.
   * @return environmentId
  **/

  public UUID getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(@org.jetbrains.annotations.Nullable UUID environmentId) {
    this.environmentId = environmentId;
  }

  public FeatureState strategies(@org.jetbrains.annotations.Nullable List<FeatureRolloutStrategy> strategies) {
    this.strategies = strategies;
    return this;
  }

  public FeatureState addStrategiesItem(FeatureRolloutStrategy strategiesItem) {
    if (this.strategies == null) {
      this.strategies = new ArrayList<>();
    }
    this.strategies.add(strategiesItem);
    return this;
  }

   /**
   * Get strategies
   * @return strategies
  **/

  public List<FeatureRolloutStrategy> getStrategies() {
    return strategies;
  }

  public void setStrategies(@org.jetbrains.annotations.Nullable List<FeatureRolloutStrategy> strategies) {
    this.strategies = strategies;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FeatureState featureState = (FeatureState) o;
    return Objects.equals(this.id, featureState.id) &&
        Objects.equals(this.key, featureState.key) &&
        Objects.equals(this.l, featureState.l) &&
        Objects.equals(this.version, featureState.version) &&
        Objects.equals(this.type, featureState.type) &&
        Objects.equals(this.value, featureState.value) &&
        Objects.equals(this.environmentId, featureState.environmentId) &&
        Objects.equals(this.strategies, featureState.strategies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, l, version, type, value, environmentId, strategies);
  }



  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FeatureState {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    l: ").append(toIndentedString(l)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    environmentId: ").append(toIndentedString(environmentId)).append("\n");
    sb.append("    strategies: ").append(toIndentedString(strategies)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public FeatureState copy() {
    FeatureState copy = new FeatureState();

    copy.setId(this.getId());
    copy.setKey(this.getKey());
    copy.setL(this.getL());
    copy.setVersion(this.getVersion());
    copy.setType(this.getType());
    copy.setValue(this.getValue());
    copy.setEnvironmentId(this.getEnvironmentId());
    copy.setStrategies(this.getStrategies() == null ? null : new java.util.ArrayList<>(this.getStrategies()));

    return copy;
  }
}

