/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.server.jersey;

import io.featurehub.client.FeatureRepository;
import io.featurehub.server.jersey.FeatureFlagEnabled;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class FeatureRequiredApplicationEventListener
implements ApplicationEventListener {
    private final FeatureRepository featureRepository;
    static Map<Method, FeatureInfo> featureInfo = new ConcurrentHashMap<Method, FeatureInfo>();

    @Inject
    public FeatureRequiredApplicationEventListener(FeatureRepository featureRepository) {
        this.featureRepository = featureRepository;
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return new FeatureRequiredEvent(this.featureRepository);
    }

    static class FeatureRequiredEvent
    implements RequestEventListener {
        private final FeatureRepository featureRepository;
        private static final FeatureInfo NO_FEATURES_REQUIRED = new FeatureInfo(new String[0]);

        FeatureRequiredEvent(FeatureRepository featureRepository) {
            this.featureRepository = featureRepository;
        }

        public void onEvent(RequestEvent event) {
            if (event.getType() == RequestEvent.Type.REQUEST_MATCHED) {
                this.featureCheck(event);
            }
        }

        private void featureCheck(RequestEvent event) {
            FeatureInfo fi = featureInfo.computeIfAbsent(this.getMethod(event), this::extractFeatureInfo);
            if (fi.features.length > 0) {
                for (String feature : fi.features) {
                    if (!Boolean.FALSE.equals(this.featureRepository.getFeatureState(feature).getBoolean())) continue;
                    event.getContainerRequest().abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                    return;
                }
            }
        }

        private FeatureInfo extractFeatureInfo(Method m) {
            FeatureFlagEnabled fr = m.getDeclaredAnnotation(FeatureFlagEnabled.class);
            if (fr == null && (fr = m.getDeclaringClass().getAnnotation(FeatureFlagEnabled.class)) == null) {
                Class<?> anInterface;
                Class<?>[] classArray = m.getDeclaringClass().getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (fr = (anInterface = classArray[i]).getAnnotation(FeatureFlagEnabled.class)) == null; ++i) {
                }
            }
            if (fr != null) {
                return new FeatureInfo(fr.features());
            }
            return NO_FEATURES_REQUIRED;
        }

        Method getMethod(RequestEvent event) {
            return event.getUriInfo().getMatchedResourceMethod().getInvocable().getHandlingMethod();
        }
    }

    static class FeatureInfo {
        public final String[] features;

        FeatureInfo(String[] features) {
            this.features = features;
        }
    }
}

