package io.featurehub.sse.api;

import cd.connect.openapi.support.ApiClient;
import cd.connect.openapi.support.ApiResponse;
import cd.connect.openapi.support.Pair;
import javax.ws.rs.BadRequestException;

import javax.ws.rs.core.GenericType;
import java.io.InputStream;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;

import io.featurehub.sse.model.Environment;
import io.featurehub.sse.model.FeatureStateUpdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.Valid;
import javax.validation.constraints.*;

@javax.annotation.Generated(value = "cd.connect.openapi.Jersey2V3ApiGenerator", date = "2021-09-27T19:01:03.649425+13:00[Pacific/Auckland]")


@Path("/features")
public interface FeatureService {


      public static String DEFAULT_SERVICE_URL = "/";

  /**
   * 
   * Requests all features for this sdkurl and disconnects
   * @param sdkUrl A list of API keys to retrieve information about (required)
   * @return List&lt;Environment&gt;
   */
  @GET
    @Path("/")
    @Produces({ "application/json" })
  public List<Environment> getFeatureStates( @NotNull  @QueryParam("sdkUrl") List<String> sdkUrl);
  /**
   * 
   * Updates the feature state if allowed.
   * @param sdkUrl The API Key for the environment and service account (required)
   * @param featureKey The key you wish to update/action (required)
   * @param featureStateUpdate  (required)
   * @return Object
   */
  @PUT
    @Path("/{sdkUrl}/{featureKey}")
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
  public Object setFeatureState( @PathParam("sdkUrl") String sdkUrl,  @PathParam("featureKey") String featureKey,  @NotNull  @Valid FeatureStateUpdate featureStateUpdate);
}
