/*
 * FeatureServiceApi
 * This describes the API clients use for accessing features
 *
 * OpenAPI spec version: 1.1.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.featurehub.sse.model;

import java.util.Objects;
import java.util.Arrays;
import io.featurehub.sse.model.BaseRolloutStrategyAttribute;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.*;
import javax.validation.constraints.*;
import javax.validation.Valid;
/**
 * if the feature in an environment is different from its default, this will be the reason for it. a rollout strategy is defined at the Application level and then applied to a specific feature value. When they are copied to the cache layer they are cloned and the feature value for that strategy is inserted into the clone and those are published.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@javax.annotation.Generated(value = "cd.connect.openapi.Jersey3ApiGenerator", date = "2022-11-02T21:46:30.016376+13:00[Pacific/Auckland]")


public class BaseRolloutStrategy {
  @JsonProperty("id")
  @org.jetbrains.annotations.Nullable
  private String id;

  @JsonProperty("percentage")
  @org.jetbrains.annotations.Nullable
  private Integer percentage;

  @JsonProperty("percentageAttributes")
  @org.jetbrains.annotations.Nullable
  private List<String> percentageAttributes = new ArrayList<>();

  @JsonProperty("value")
  @org.jetbrains.annotations.Nullable
  private Object value = null;

  @JsonProperty("attributes")
  @org.jetbrains.annotations.Nullable
  private List<BaseRolloutStrategyAttribute> attributes = new ArrayList<>();

  public BaseRolloutStrategy id(@org.jetbrains.annotations.Nullable String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
@org.jetbrains.annotations.Nullable

  public String getId() {
    return id;
  }

  public void setId(@org.jetbrains.annotations.Nullable String id) {
    this.id = id;
  }

  public BaseRolloutStrategy percentage(@org.jetbrains.annotations.Nullable Integer percentage) {
    this.percentage = percentage;
    return this;
  }

   /**
   * value between 0 and 1000000 - for four decimal places
   * @return percentage
  **/
@org.jetbrains.annotations.Nullable

  public Integer getPercentage() {
    return percentage;
  }

  public void setPercentage(@org.jetbrains.annotations.Nullable Integer percentage) {
    this.percentage = percentage;
  }

  public BaseRolloutStrategy percentageAttributes(@org.jetbrains.annotations.Nullable List<String> percentageAttributes) {
    this.percentageAttributes = percentageAttributes;
    return this;
  }

  public BaseRolloutStrategy addPercentageAttributesItem(String percentageAttributesItem) {
    if (this.percentageAttributes == null) {
      this.percentageAttributes = new ArrayList<>();
    }
    this.percentageAttributes.add(percentageAttributesItem);
    return this;
  }

   /**
   * if you don&#39;t wish to apply percentage based on user id, you can use one or more attributes defined here
   * @return percentageAttributes
  **/
@org.jetbrains.annotations.Nullable

  public List<String> getPercentageAttributes() {
    return percentageAttributes;
  }

  public void setPercentageAttributes(@org.jetbrains.annotations.Nullable List<String> percentageAttributes) {
    this.percentageAttributes = percentageAttributes;
  }

  public BaseRolloutStrategy value(@org.jetbrains.annotations.Nullable Object value) {
    this.value = value;
    return this;
  }

   /**
   * when we attach the RolloutStrategy for Dacha or SSE this lets us push the value out. Only visible in SDK and SSE Edge.
   * @return value
  **/
@org.jetbrains.annotations.Nullable

  public Object getValue() {
    return value;
  }

  public void setValue(@org.jetbrains.annotations.Nullable Object value) {
    this.value = value;
  }

  public BaseRolloutStrategy attributes(@org.jetbrains.annotations.Nullable List<BaseRolloutStrategyAttribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public BaseRolloutStrategy addAttributesItem(BaseRolloutStrategyAttribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
@org.jetbrains.annotations.Nullable @Valid 

  public List<BaseRolloutStrategyAttribute> getAttributes() {
    return attributes;
  }

  public void setAttributes(@org.jetbrains.annotations.Nullable List<BaseRolloutStrategyAttribute> attributes) {
    this.attributes = attributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseRolloutStrategy baseRolloutStrategy = (BaseRolloutStrategy) o;
    return Objects.equals(this.id, baseRolloutStrategy.id) &&
        Objects.equals(this.percentage, baseRolloutStrategy.percentage) &&
        Objects.equals(this.percentageAttributes, baseRolloutStrategy.percentageAttributes) &&
        Objects.equals(this.value, baseRolloutStrategy.value) &&
        Objects.equals(this.attributes, baseRolloutStrategy.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, percentage, percentageAttributes, value, attributes);
  }



  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseRolloutStrategy {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    percentage: ").append(toIndentedString(percentage)).append("\n");
    sb.append("    percentageAttributes: ").append(toIndentedString(percentageAttributes)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public BaseRolloutStrategy copy() {
    BaseRolloutStrategy copy = new BaseRolloutStrategy();

    copy.setId(this.getId());
    copy.setPercentage(this.getPercentage());
    copy.setPercentageAttributes(this.getPercentageAttributes() == null ? null : new java.util.ArrayList<>(this.getPercentageAttributes()));
    copy.setValue(this.getValue());
    copy.setAttributes(this.getAttributes() == null ? null : new java.util.ArrayList<>(this.getAttributes()));

    return copy;
  }
}

