package io.featurehub.sse.api;

import cd.connect.openapi.support.ApiClient;
import cd.connect.openapi.support.ApiResponse;
import cd.connect.openapi.support.Pair;

import java.io.InputStream;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.Valid;
import javax.validation.constraints.*;

import io.featurehub.sse.model.FeatureEnvironmentCollection;
import io.featurehub.sse.model.FeatureStateUpdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "cd.connect.openapi.Jersey3ApiGenerator", date = "2023-03-17T07:34:35.711974+13:00[Pacific/Auckland]")




@Path("/features")
public interface FeatureService {

  /**
   * 
   * Requests all features for this sdkurl and disconnects
   * @param apiKey A list of API keys to retrieve information about (required)
   * @param contextSha A SHA of the context in string form designed to break any cache if the client changes context. It is not used by the server in any way. (optional)
   
	   * @return List&lt;FeatureEnvironmentCollection&gt;
   
   */
  @GET
    @Path("/")
    @Produces({ "application/json" })
  public List<FeatureEnvironmentCollection> getFeatureStates( @org.jetbrains.annotations.NotNull @javax.validation.constraints.NotNull
 @QueryParam("apiKey") List<String> apiKey
, @org.jetbrains.annotations.Nullable
 @QueryParam("contextSha") String contextSha
);
  /**
   * 
   * Updates the feature state if allowed.
   * @param sdkUrl The API Key for the environment and service account (required)
   * @param featureKey The key you wish to update/action (required)
   * @param featureStateUpdate  (required)
   
   */
  @PUT
    @Path("/{sdkUrl}/{featureKey}")
    @Consumes({ "application/json" })
  public void setFeatureState( @PathParam("sdkUrl") @org.jetbrains.annotations.NotNull String sdkUrl
,  @PathParam("featureKey") @org.jetbrains.annotations.NotNull String featureKey
, 
@org.jetbrains.annotations.NotNull  @javax.validation.constraints.NotNull  @Valid 
FeatureStateUpdate featureStateUpdate);
}
