/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.client.jersey;

import io.featurehub.client.EdgeService;
import io.featurehub.client.FeatureHubConfig;
import io.featurehub.client.FeatureStore;
import io.featurehub.client.Readyness;
import io.featurehub.client.edge.EdgeConnectionState;
import io.featurehub.client.edge.EdgeReconnector;
import io.featurehub.client.edge.EdgeRetryService;
import io.featurehub.client.utils.SdkVersion;
import io.featurehub.sse.model.SSEResultState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseySSEClient
implements EdgeService,
EdgeReconnector {
    private static final Logger log = LoggerFactory.getLogger(JerseySSEClient.class);
    private final FeatureStore repository;
    private final FeatureHubConfig config;
    private String xFeaturehubHeader;
    private final EdgeRetryService retryer;
    private EventInput eventSource;
    private final WebTarget target;
    private final List<CompletableFuture<Readyness>> waitingClients = new ArrayList<CompletableFuture<Readyness>>();

    public JerseySSEClient(FeatureStore repository, FeatureHubConfig config, EdgeRetryService retryer) {
        this.repository = repository;
        this.config = config;
        this.retryer = retryer;
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(SseFeature.class)).build();
        client.property("jersey.config.client.connectTimeout", (Object)retryer.getServerConnectTimeoutMs());
        client.property("jersey.config.client.readTimeout", (Object)retryer.getServerConnectTimeoutMs());
        this.target = this.makeEventSourceTarget(client, config.getRealtimeUrl());
    }

    protected WebTarget makeEventSourceTarget(Client client, String sdkUrl) {
        return client.target(sdkUrl);
    }

    @NotNull
    public Future<Readyness> contextChange(@Nullable String newHeader, @Nullable String contextSha) {
        CompletableFuture<Readyness> change = new CompletableFuture<Readyness>();
        if (this.config.isServerEvaluation() && (newHeader != null && !newHeader.equals(this.xFeaturehubHeader) || this.xFeaturehubHeader != null && !this.xFeaturehubHeader.equals(newHeader))) {
            log.warn("[featurehub-sdk] please only use server evaluated keys with SSE with one repository per SSE client.");
            this.xFeaturehubHeader = newHeader;
            this.close();
        }
        if (this.eventSource == null) {
            this.waitingClients.add(change);
            this.poll();
        } else {
            change.complete(this.repository.getReadyness());
        }
        return change;
    }

    public boolean isClientEvaluation() {
        return !this.config.isServerEvaluation();
    }

    public void close() {
        if (this.eventSource != null) {
            if (!this.eventSource.isClosed()) {
                this.eventSource.close();
            }
            this.eventSource = null;
        }
    }

    @NotNull
    public FeatureHubConfig getConfig() {
        return this.config;
    }

    public boolean isRequiresReplacementOnHeaderChange() {
        return true;
    }

    protected EventInput makeEventSource() {
        Invocation.Builder request = this.target.request();
        if (this.xFeaturehubHeader != null) {
            request = request.header("x-featurehub", (Object)this.xFeaturehubHeader);
        }
        request = request.header("X-SDK", (Object)SdkVersion.sdkVersionHeader((String)"Java-Jersey2"));
        log.trace("[featurehub-sdk] connecting to {}", (Object)this.config.getRealtimeUrl());
        return (EventInput)request.get(EventInput.class);
    }

    private void initEventSource() {
        try {
            this.eventSource = this.makeEventSource();
        }
        catch (Exception e) {
            this.onMakeEventSourceException(e);
            return;
        }
        log.trace("[featurehub-sdk] connected to {}", (Object)this.config.getRealtimeUrl());
        boolean connectionSaidBye = false;
        boolean interrupted = false;
        while (!this.eventSource.isClosed() && !interrupted) {
            String data;
            InboundEvent event;
            try {
                event = (InboundEvent)this.eventSource.read();
                if (event == null) {
                    interrupted = true;
                    continue;
                }
                data = event.readData();
            }
            catch (Exception e) {
                log.error("failed read", (Throwable)e);
                interrupted = true;
                continue;
            }
            try {
                SSEResultState state = this.retryer.fromValue(event.getName());
                if (state == null) continue;
                log.trace("[featurehub-sdk] decode packet {}:{}", (Object)event.getName(), (Object)data);
                if (state == SSEResultState.CONFIG) {
                    this.retryer.edgeConfigInfo(data);
                } else {
                    this.repository.notify(state, data);
                }
                if (state == SSEResultState.FEATURES) {
                    this.retryer.edgeResult(EdgeConnectionState.SUCCESS, (EdgeReconnector)this);
                }
                if (state == SSEResultState.BYE) {
                    connectionSaidBye = true;
                }
                if (state == SSEResultState.FAILURE) {
                    this.retryer.edgeResult(EdgeConnectionState.API_KEY_NOT_FOUND, (EdgeReconnector)this);
                }
                if (this.waitingClients.isEmpty() || state == SSEResultState.ACK || state == SSEResultState.CONFIG) continue;
                this.waitingClients.forEach(wc -> wc.complete(this.repository.getReadyness()));
            }
            catch (Exception e) {
                log.error("[featurehub-sdk] failed to decode packet {}:{}", new Object[]{event.getName(), data, e});
            }
        }
        if (this.eventSource.isClosed() || interrupted) {
            this.close();
            log.trace("[featurehub-sdk] closed");
            if (this.repository.getReadyness() == Readyness.NotReady) {
                this.repository.notify(SSEResultState.FAILURE, null);
            }
            this.retryer.edgeResult(connectionSaidBye ? EdgeConnectionState.SERVER_SAID_BYE : EdgeConnectionState.SERVER_WAS_DISCONNECTED, (EdgeReconnector)this);
        }
    }

    private void onMakeEventSourceException(Exception e) {
        log.info("[featurehub-sdk] failed to connect to {}", (Object)this.config.getRealtimeUrl());
        if (e instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)e;
            Response response = wae.getResponse();
            if (response != null && response.getStatusInfo().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                this.retryer.edgeResult(EdgeConnectionState.API_KEY_NOT_FOUND, (EdgeReconnector)this);
            } else {
                this.retryer.edgeResult(EdgeConnectionState.SERVER_CONNECT_TIMEOUT, (EdgeReconnector)this);
            }
        } else {
            this.retryer.edgeResult(EdgeConnectionState.SERVER_CONNECT_TIMEOUT, (EdgeReconnector)this);
        }
    }

    public void poll() {
        if (this.eventSource == null) {
            this.retryer.getExecutorService().submit(this::initEventSource);
        }
    }

    public void reconnect() {
        this.poll();
    }
}

