/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.sse.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SSEResultState {
    ACK("ack"),
    BYE("bye"),
    FAILURE("failure"),
    FEATURES("features"),
    FEATURE("feature"),
    DELETE_FEATURE("delete_feature"),
    CONFIG("config"),
    ERROR("error");

    private String value;
    private static Map<String, SSEResultState> fromValues;

    private SSEResultState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public SSEResultState copy() {
        return this;
    }

    @JsonCreator
    public static SSEResultState fromValue(String text) {
        SSEResultState val = fromValues.get(text);
        if (val != null) {
            return val;
        }
        throw new IllegalArgumentException("Unexpected value '" + text + "'");
    }

    static {
        fromValues = new HashMap<String, SSEResultState>();
        fromValues.put("ack", ACK);
        fromValues.put("ACK", ACK);
        fromValues.put("bye", BYE);
        fromValues.put("BYE", BYE);
        fromValues.put("failure", FAILURE);
        fromValues.put("FAILURE", FAILURE);
        fromValues.put("features", FEATURES);
        fromValues.put("FEATURES", FEATURES);
        fromValues.put("feature", FEATURE);
        fromValues.put("FEATURE", FEATURE);
        fromValues.put("delete_feature", DELETE_FEATURE);
        fromValues.put("DELETE_FEATURE", DELETE_FEATURE);
        fromValues.put("config", CONFIG);
        fromValues.put("CONFIG", CONFIG);
        fromValues.put("error", ERROR);
        fromValues.put("ERROR", ERROR);
    }
}

