/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.client.jersey;

import cd.connect.openapi.support.ApiClient;
import io.featurehub.client.EdgeService;
import io.featurehub.client.Feature;
import io.featurehub.client.FeatureHubConfig;
import io.featurehub.client.FeatureStore;
import io.featurehub.client.Readyness;
import io.featurehub.client.jersey.FeatureServiceImpl;
import io.featurehub.client.utils.SdkVersion;
import io.featurehub.sse.api.FeatureService;
import io.featurehub.sse.model.FeatureStateUpdate;
import io.featurehub.sse.model.SSEResultState;
import jakarta.inject.Singleton;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Deprecated
public class JerseyClient
implements EdgeService {
    private static final Logger log = LoggerFactory.getLogger(JerseyClient.class);
    private final WebTarget target;
    private boolean initialized;
    private final Executor executor;
    private final FeatureStore repository;
    private final FeatureService featuresService;
    private boolean shutdown = false;
    private boolean shutdownOnServerFailure = true;
    private boolean shutdownOnEdgeFailureConnection = false;
    private EventInput eventInput;
    private String xFeaturehubHeader;
    protected final FeatureHubConfig fhConfig;
    private List<CompletableFuture<Readyness>> waitingClients = new ArrayList<CompletableFuture<Readyness>>();
    private boolean neverConnect = false;
    private CurrentRequest request;

    public JerseyClient(FeatureHubConfig config, FeatureStore repository) {
        this(config, !config.isServerEvaluation(), repository, null);
    }

    public JerseyClient(FeatureHubConfig config, boolean initializeOnConstruction, FeatureStore repository, ApiClient apiClient) {
        this.repository = repository;
        this.fhConfig = config;
        log.trace("new jersey client created");
        repository.setServerEvaluation(config.isServerEvaluation());
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).register(SseFeature.class)).build();
        this.target = this.makeEventSourceTarget(client, config.getRealtimeUrl());
        this.executor = this.makeExecutor();
        if (apiClient == null) {
            apiClient = new ApiClient(client, config.baseUrl());
        }
        this.featuresService = this.makeFeatureServiceClient(apiClient);
        if (initializeOnConstruction) {
            this.init();
        }
    }

    protected ExecutorService makeExecutor() {
        return Executors.newFixedThreadPool(4);
    }

    protected WebTarget makeEventSourceTarget(Client client, String sdkUrl) {
        return client.target(sdkUrl);
    }

    protected FeatureService makeFeatureServiceClient(ApiClient apiClient) {
        return new FeatureServiceImpl(apiClient);
    }

    public void setFeatureState(String key, FeatureStateUpdate update) {
        this.featuresService.setFeatureState(this.fhConfig.apiKey(), key, update);
    }

    public void setFeatureState(Feature feature, FeatureStateUpdate update) {
        this.setFeatureState(feature.name(), update);
    }

    private void avoidServerDdos() {
        if (this.request != null) {
            this.request.active = false;
            this.request = null;
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.shutdown) {
            this.executor.execute(this::restartRequest);
        }
    }

    protected SSEResultState fromValue(String name) {
        try {
            return SSEResultState.fromValue((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void restartRequest() {
        log.trace("starting new request");
        if (this.request != null) {
            this.request.active = false;
        }
        this.initialized = false;
        this.request = new CurrentRequest();
        this.request.listenUntilDead();
    }

    void init() {
        if (!this.initialized) {
            this.executor.execute(this::restartRequest);
        }
    }

    public void shutdown() {
        log.trace("starting shutdown of jersey edge client");
        this.shutdown = true;
        if (this.request != null) {
            this.request.active = false;
        }
        if (this.eventInput != null) {
            this.eventInput.close();
        }
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdownNow();
        }
        log.trace("exiting shutdown of jersey edge client");
    }

    public boolean isShutdownOnServerFailure() {
        return this.shutdownOnServerFailure;
    }

    public void setShutdownOnServerFailure(boolean shutdownOnServerFailure) {
        this.shutdownOnServerFailure = shutdownOnServerFailure;
    }

    public boolean isShutdownOnEdgeFailureConnection() {
        return this.shutdownOnEdgeFailureConnection;
    }

    public void setShutdownOnEdgeFailureConnection(boolean shutdownOnEdgeFailureConnection) {
        this.shutdownOnEdgeFailureConnection = shutdownOnEdgeFailureConnection;
    }

    public String getFeaturehubContextHeader() {
        return this.xFeaturehubHeader;
    }

    @NotNull
    public Future<Readyness> contextChange(String newHeader, String contextSha) {
        CompletableFuture<Readyness> change = new CompletableFuture<Readyness>();
        if (this.fhConfig.isServerEvaluation() && (newHeader != null && !newHeader.equals(this.xFeaturehubHeader) || !this.initialized)) {
            this.xFeaturehubHeader = newHeader;
            this.waitingClients.add(change);
            this.executor.execute(this::restartRequest);
        } else {
            change.complete(this.repository.getReadyness());
        }
        return change;
    }

    private void completeReadyness() {
        List<CompletableFuture<Readyness>> current = this.waitingClients;
        this.waitingClients = new ArrayList<CompletableFuture<Readyness>>();
        current.forEach(c -> {
            try {
                c.complete(this.repository.getReadyness());
            }
            catch (Exception e) {
                log.error("Unable to complete future", (Throwable)e);
            }
        });
    }

    public boolean isClientEvaluation() {
        return !this.fhConfig.isServerEvaluation();
    }

    public void close() {
        this.shutdown();
    }

    @NotNull
    public FeatureHubConfig getConfig() {
        return this.fhConfig;
    }

    public boolean isRequiresReplacementOnHeaderChange() {
        return true;
    }

    public void poll() {
    }

    class CurrentRequest {
        public boolean active = true;

        CurrentRequest() {
        }

        public void listenUntilDead() {
            long start;
            block17: {
                if (JerseyClient.this.neverConnect) {
                    return;
                }
                start = System.currentTimeMillis();
                try {
                    Invocation.Builder request = JerseyClient.this.target.request();
                    if (JerseyClient.this.xFeaturehubHeader != null) {
                        request = request.header("x-featurehub", (Object)JerseyClient.this.xFeaturehubHeader);
                    }
                    request = request.header("X-SDK", (Object)SdkVersion.sdkVersionHeader((String)"Java-Jersey2"));
                    JerseyClient.this.eventInput = (EventInput)request.get(EventInput.class);
                    while (!JerseyClient.this.eventInput.isClosed()) {
                        InboundEvent inboundEvent = (InboundEvent)JerseyClient.this.eventInput.read();
                        JerseyClient.this.initialized = true;
                        if (!this.active) {
                            return;
                        }
                        if (!JerseyClient.this.shutdown && inboundEvent != null) {
                            log.trace("notifying of {}", (Object)inboundEvent.getName());
                            try {
                                SSEResultState state = JerseyClient.this.fromValue(inboundEvent.getName());
                                if (state != null && state != SSEResultState.CONFIG) {
                                    JerseyClient.this.repository.notify(state, inboundEvent.readData());
                                } else if (state == SSEResultState.CONFIG) {
                                    // empty if block
                                }
                                if (state == SSEResultState.FAILURE || state == SSEResultState.FEATURES) {
                                    JerseyClient.this.completeReadyness();
                                }
                                if (state != SSEResultState.FAILURE || !JerseyClient.this.shutdownOnServerFailure) continue;
                                log.warn("Failed to connect to FeatureHub Edge on {}, shutting down.", (Object)JerseyClient.this.fhConfig.getRealtimeUrl());
                                JerseyClient.this.shutdown();
                            }
                            catch (Exception e) {
                                log.warn("Failed to parse SSE state {}", (Object)inboundEvent.getName(), (Object)e);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    if (!JerseyClient.this.shutdownOnEdgeFailureConnection) break block17;
                    log.warn("Edge connection failed, shutting down");
                    JerseyClient.this.repository.notify(SSEResultState.FAILURE, null);
                    JerseyClient.this.shutdown();
                }
            }
            JerseyClient.this.eventInput = null;
            JerseyClient.this.initialized = false;
            if (!JerseyClient.this.shutdown) {
                log.trace("connection closed, reconnecting");
                if (System.currentTimeMillis() - start < 2000L) {
                    JerseyClient.this.executor.execute(() -> JerseyClient.this.avoidServerDdos());
                } else {
                    JerseyClient.this.executor.execute(this::listenUntilDead);
                }
            } else {
                JerseyClient.this.completeReadyness();
                log.trace("featurehub client shut down");
            }
        }
    }
}

