/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.strategies.matchers;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class CIDRMatch {
    public static InetAddress suppliedAddress(String address) throws UnknownHostException {
        return InetAddress.getByName(address);
    }

    public static boolean cidrMatch(String ipAddress, InetAddress remoteAddress) {
        int nMaskBits;
        if (ipAddress.indexOf(47) > 0) {
            String[] addressAndMask = ipAddress.split("/");
            ipAddress = addressAndMask[0];
            nMaskBits = Integer.parseInt(addressAndMask[1]);
        } else {
            nMaskBits = -1;
        }
        try {
            InetAddress requiredAddress = InetAddress.getByName(ipAddress);
            if (requiredAddress.getAddress().length * 8 >= nMaskBits) {
                if (!requiredAddress.getClass().equals(remoteAddress.getClass())) {
                    return false;
                }
                if (nMaskBits < 0) {
                    return remoteAddress.equals(requiredAddress);
                }
                byte[] remAddr = remoteAddress.getAddress();
                byte[] reqAddr = requiredAddress.getAddress();
                int nMaskFullBytes = nMaskBits / 8;
                byte finalByte = (byte)(65280 >> (nMaskBits & 7));
                for (int i = 0; i < nMaskFullBytes; ++i) {
                    if (remAddr[i] == reqAddr[i]) continue;
                    return false;
                }
                if (finalByte != 0) {
                    return (remAddr[nMaskFullBytes] & finalByte) == (reqAddr[nMaskFullBytes] & finalByte);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

