/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.strategies.matchers;

import io.featurehub.sse.model.RolloutStrategyAttribute;
import io.featurehub.strategies.matchers.StrategyMatcher;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;

public class DateArrayMatcher
implements StrategyMatcher {
    private LocalDate supplied;

    @Override
    public boolean match(String suppliedValue, RolloutStrategyAttribute attr) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
            Supplier<LocalDate> suppliedDate = () -> {
                if (this.supplied == null) {
                    this.supplied = LocalDate.from(formatter.parse(suppliedValue));
                }
                return this.supplied;
            };
            switch (attr.getConditional()) {
                case EQUALS: 
                case INCLUDES: {
                    return attr.getValues().stream().anyMatch(v -> ((LocalDate)suppliedDate.get()).equals(LocalDate.from(formatter.parse(v.toString()))));
                }
                case ENDS_WITH: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.endsWith(v.toString()));
                }
                case STARTS_WITH: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.startsWith(v.toString()));
                }
                case GREATER: {
                    return attr.getValues().stream().anyMatch(v -> ((LocalDate)suppliedDate.get()).compareTo(LocalDate.from(formatter.parse(v.toString()))) > 0);
                }
                case GREATER_EQUALS: {
                    return attr.getValues().stream().anyMatch(v -> ((LocalDate)suppliedDate.get()).compareTo(LocalDate.from(formatter.parse(v.toString()))) >= 0);
                }
                case LESS: {
                    return attr.getValues().stream().anyMatch(v -> ((LocalDate)suppliedDate.get()).compareTo(LocalDate.from(formatter.parse(v.toString()))) < 0);
                }
                case LESS_EQUALS: {
                    return attr.getValues().stream().anyMatch(v -> ((LocalDate)suppliedDate.get()).compareTo(LocalDate.from(formatter.parse(v.toString()))) <= 0);
                }
                case NOT_EQUALS: 
                case EXCLUDES: {
                    return attr.getValues().stream().noneMatch(v -> ((LocalDate)suppliedDate.get()).equals(LocalDate.from(formatter.parse(v.toString()))));
                }
                case REGEX: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.matches(v.toString()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

