/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.strategies.matchers;

import io.featurehub.sse.model.RolloutStrategyAttribute;
import io.featurehub.strategies.matchers.StrategyMatcher;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;

public class DateTimeArrayMatcher
implements StrategyMatcher {
    private OffsetDateTime supplied = null;

    @Override
    public boolean match(String suppliedValue, RolloutStrategyAttribute attr) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        try {
            Supplier<OffsetDateTime> suppliedDate = () -> {
                if (this.supplied == null) {
                    this.supplied = OffsetDateTime.from(formatter.parse(suppliedValue));
                }
                return this.supplied;
            };
            switch (attr.getConditional()) {
                case EQUALS: 
                case INCLUDES: {
                    return attr.getValues().stream().anyMatch(v -> ((OffsetDateTime)suppliedDate.get()).equals(OffsetDateTime.from(formatter.parse(v.toString()))));
                }
                case ENDS_WITH: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.endsWith(v.toString()));
                }
                case STARTS_WITH: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.startsWith(v.toString()));
                }
                case GREATER: {
                    return attr.getValues().stream().anyMatch(v -> ((OffsetDateTime)suppliedDate.get()).compareTo(OffsetDateTime.from(formatter.parse(v.toString()))) > 0);
                }
                case GREATER_EQUALS: {
                    return attr.getValues().stream().anyMatch(v -> ((OffsetDateTime)suppliedDate.get()).compareTo(OffsetDateTime.from(formatter.parse(v.toString()))) >= 0);
                }
                case LESS: {
                    return attr.getValues().stream().anyMatch(v -> ((OffsetDateTime)suppliedDate.get()).compareTo(OffsetDateTime.from(formatter.parse(v.toString()))) < 0);
                }
                case LESS_EQUALS: {
                    return attr.getValues().stream().anyMatch(v -> ((OffsetDateTime)suppliedDate.get()).compareTo(OffsetDateTime.from(formatter.parse(v.toString()))) <= 0);
                }
                case NOT_EQUALS: 
                case EXCLUDES: {
                    return attr.getValues().stream().noneMatch(v -> ((OffsetDateTime)suppliedDate.get()).equals(OffsetDateTime.from(formatter.parse(v.toString()))));
                }
                case REGEX: {
                    return attr.getValues().stream().anyMatch(v -> suppliedValue.matches(v.toString()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

