/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.strategies.matchers;

import io.featurehub.sse.model.RolloutStrategyAttribute;
import io.featurehub.strategies.matchers.BooleanArrayMatcher;
import io.featurehub.strategies.matchers.DateArrayMatcher;
import io.featurehub.strategies.matchers.DateTimeArrayMatcher;
import io.featurehub.strategies.matchers.IpAddressArrayMatcher;
import io.featurehub.strategies.matchers.MatcherRepository;
import io.featurehub.strategies.matchers.NumberArrayMatcher;
import io.featurehub.strategies.matchers.SemanticVersionArrayMatcher;
import io.featurehub.strategies.matchers.StrategyMatcher;
import io.featurehub.strategies.matchers.StringArrayMatcher;

public class MatcherRegistry
implements MatcherRepository {
    @Override
    public StrategyMatcher findMatcher(RolloutStrategyAttribute attr) {
        switch (attr.getType()) {
            case STRING: {
                return new StringArrayMatcher();
            }
            case SEMANTIC_VERSION: {
                return new SemanticVersionArrayMatcher();
            }
            case NUMBER: {
                return new NumberArrayMatcher();
            }
            case DATE: {
                return new DateArrayMatcher();
            }
            case DATETIME: {
                return new DateTimeArrayMatcher();
            }
            case BOOLEAN: {
                return new BooleanArrayMatcher();
            }
            case IP_ADDRESS: {
                return new IpAddressArrayMatcher();
            }
        }
        return new FallthroughMatcher();
    }

    static class FallthroughMatcher
    implements StrategyMatcher {
        FallthroughMatcher() {
        }

        @Override
        public boolean match(String suppliedValue, RolloutStrategyAttribute attr) {
            return false;
        }
    }
}

