/*
 * Decompiled with CFR 0.152.
 */
package io.featurehub.strategies.percentage;

import io.featurehub.strategies.percentage.Murmur3_32HashFunction;
import io.featurehub.strategies.percentage.PercentageCalculator;
import java.nio.charset.StandardCharsets;

public class PercentageMumurCalculator
implements PercentageCalculator {
    private final Murmur3_32HashFunction hashFunction;
    public static final int MAX_PERCENTAGE = 1000000;

    public PercentageMumurCalculator(int seed) {
        this.hashFunction = new Murmur3_32HashFunction(seed);
    }

    public PercentageMumurCalculator() {
        this.hashFunction = new Murmur3_32HashFunction(Murmur3_32HashFunction.GOOD_FAST_HASH_SEED);
    }

    @Override
    public int determineClientPercentage(String userKey, String id) {
        int hashCode = this.hashFunction.hashString(userKey + id, StandardCharsets.UTF_8);
        double ratio = (double)((long)hashCode & 0xFFFFFFFFL) / Math.pow(2.0, 32.0);
        return (int)Math.floor(1000000.0 * ratio);
    }
}

