/*
 * Decompiled with CFR 0.152.
 */
package io.federecio.dropwizard.swagger;

import io.dropwizard.Configuration;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.server.SimpleServerFactory;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;

public class ConfigurationHelper {
    private final Configuration configuration;
    private final SwaggerBundleConfiguration swaggerBundleConfiguration;

    public ConfigurationHelper(Configuration configuration, SwaggerBundleConfiguration swaggerBundleConfiguration) {
        this.configuration = configuration;
        this.swaggerBundleConfiguration = swaggerBundleConfiguration;
    }

    public String getJerseyRootPath() {
        if (this.swaggerBundleConfiguration.getUriPrefix() != null) {
            return this.swaggerBundleConfiguration.getUriPrefix();
        }
        ServerFactory serverFactory = this.configuration.getServerFactory();
        String rootPath = serverFactory instanceof SimpleServerFactory ? ((SimpleServerFactory)serverFactory).getJerseyRootPath() : ((DefaultServerFactory)serverFactory).getJerseyRootPath();
        return this.stripUrlSlashes(rootPath);
    }

    public String getUrlPattern() {
        if (this.swaggerBundleConfiguration.getUriPrefix() != null) {
            return this.swaggerBundleConfiguration.getUriPrefix();
        }
        String applicationContextPath = this.getApplicationContextPath();
        String rootPath = this.getJerseyRootPath();
        String urlPattern = rootPath.equals("/") && applicationContextPath.equals("/") ? "/" : (rootPath.equals("/") && !applicationContextPath.equals("/") ? applicationContextPath : (!rootPath.equals("/") && applicationContextPath.equals("/") ? rootPath : applicationContextPath + rootPath));
        return urlPattern;
    }

    public String getSwaggerUriPath() {
        String jerseyRootPath = this.getJerseyRootPath();
        String uriPathPrefix = jerseyRootPath.equals("/") ? "" : jerseyRootPath;
        return uriPathPrefix + "/swagger-static";
    }

    private String getApplicationContextPath() {
        ServerFactory serverFactory = this.configuration.getServerFactory();
        String applicationContextPath = serverFactory instanceof SimpleServerFactory ? ((SimpleServerFactory)serverFactory).getApplicationContextPath() : ((DefaultServerFactory)serverFactory).getApplicationContextPath();
        return this.stripUrlSlashes(applicationContextPath);
    }

    private String stripUrlSlashes(String urlToStrip) {
        if (urlToStrip.endsWith("/*")) {
            urlToStrip = urlToStrip.substring(0, urlToStrip.length() - 1);
        }
        if (urlToStrip.length() > 1 && urlToStrip.endsWith("/")) {
            urlToStrip = urlToStrip.substring(0, urlToStrip.length() - 1);
        }
        return urlToStrip;
    }
}

