/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock;

import akka.util.ByteString;
import akka.util.ByteString$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.Header;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u0013\tY1\t[;oW\n+hMZ3s\u0015\t\u0019A!\u0001\u0004tg5|7m\u001b\u0006\u0003\u000b\u0019\tqAZ5oI&4\u0017PC\u0001\b\u0003\tIwn\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tAb]2bY\u0006dwnZ4j]\u001eT!!\u0006\f\u0002\u0011QL\b/Z:bM\u0016T\u0011aF\u0001\u0004G>l\u0017BA\r\u0013\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\tQ\u0016D8\t[1sgV\t!\u0005E\u0002$Q)j\u0011\u0001\n\u0006\u0003K\u0019\n\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001db\u0011AC2pY2,7\r^5p]&\u0011\u0011\u0006\n\u0002\u0004'\u0016$\bCA\u0006,\u0013\taCB\u0001\u0003CsR,\u0007B\u0002\u0018\u0001A\u0003%!%A\u0005iKb\u001c\u0005.\u0019:tA!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0014\u0001B:ju\u0016,\u0012A\r\t\u0003\u0017MJ!\u0001\u000e\u0007\u0003\u0007%sG\u000fC\u00047\u0001\u0001\u0007I\u0011A\u001c\u0002\u0011ML'0Z0%KF$\"\u0001O\u001e\u0011\u0005-I\u0014B\u0001\u001e\r\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001e\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u00033\u0003\u0015\u0019\u0018N_3!\u0011\u001d\u0001\u0005\u00011A\u0005\u0002\u0005\u000baAY;gM\u0016\u0014X#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005C.\\\u0017-\u0003\u0002J\t\nQ!)\u001f;f'R\u0014\u0018N\\4\t\u000f-\u0003\u0001\u0019!C\u0001\u0019\u0006Q!-\u001e4gKJ|F%Z9\u0015\u0005aj\u0005b\u0002\u001fK\u0003\u0003\u0005\rA\u0011\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002\"\u0002\u000f\t,hMZ3sA!)\u0011\u000b\u0001C\u0001%\u0006A\u0011\r\u001a3DQVt7\u000e\u0006\u00029'\")A\u000b\u0015a\u0001\u0005\u0006!A-\u0019;b\u0011\u00151\u0006\u0001\"\u0001X\u0003)\u0011X-\u00193IK\u0006$WM]\u000b\u00021B\u00191\"W.\n\u0005ic!AB(qi&|g\u000e\u0005\u0002\u001f9&\u0011QL\u0001\u0002\u0007\u0011\u0016\fG-\u001a:\t\u000b}\u0003A\u0011\u00011\u0002\u0013A,H\u000e\\\"ik:\\GCA1c!\rY\u0011L\u0011\u0005\u0006Gz\u0003\raW\u0001\u0007Q\u0016\fG-\u001a:")
public class ChunkBuffer
implements LazyLogging {
    private final Set<Object> hexChars;
    private int size;
    private ByteString buffer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ChunkBuffer chunkBuffer = this;
        synchronized (chunkBuffer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Set<Object> hexChars() {
        return this.hexChars;
    }

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public ByteString buffer() {
        return this.buffer;
    }

    public void buffer_$eq(ByteString x$1) {
        this.buffer = x$1;
    }

    public void addChunk(ByteString data) {
        this.buffer_$eq(this.buffer().$plus$plus(data));
    }

    public Option<Header> readHeader() {
        None$ none$;
        ByteString headerBuffer = this.buffer().take(90);
        String bufferString = headerBuffer.utf8String();
        ByteString size = headerBuffer.takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChunkBuffer $outer;

            public final boolean apply(byte elem) {
                return this.$outer.hexChars().contains((Object)BoxesRunTime.boxToByte((byte)elem));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ByteString sig = headerBuffer.drop(size.length()).take(83);
        if (size.length() <= 8 && sig.length() == 83 && sig.startsWith((GenSeq)Predef$.MODULE$.wrapString(";chunk-signature=")) && sig.endsWith((GenSeq)Predef$.MODULE$.wrapString("\r\n"))) {
            BoxedUnit boxedUnit;
            Header header = new Header(Integer.parseInt(size.utf8String(), 16), size.length() + 83, sig.drop(17).dropRight(2).utf8String());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read header: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{header})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)header);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("cannot read header");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<ByteString> pullChunk(Header header) {
        None$ none$;
        if (this.buffer().length() >= header.headerSize() + header.chunkSize() + 2) {
            BoxedUnit boxedUnit;
            this.buffer_$eq(this.buffer().drop(header.headerSize()));
            ByteString chunk = this.buffer().take(header.chunkSize());
            this.buffer_$eq(this.buffer().drop(header.chunkSize() + 2));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pulled chunk, size=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header.chunkSize())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)chunk);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not enough data to pull chunk: chunkSize = ", ", bufferSize = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)header.chunkSize()), BoxesRunTime.boxToInteger((int)this.buffer().length())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public ChunkBuffer() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.hexChars = Predef$.MODULE$.byteArrayOps("0123456789abcdef".getBytes()).toSet();
        this.size = -1;
        this.buffer = ByteString$.MODULE$.apply("");
    }
}

