/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime;
import akka.http.scaladsl.model.DateTime$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.InMemoryProvider$BucketContents$;
import io.findify.s3mock.provider.InMemoryProvider$KeyContents$;
import io.findify.s3mock.provider.InMemoryProvider$MultipartChunk$;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.Provider$class;
import io.findify.s3mock.provider.metadata.InMemoryMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.TreeSet;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r]g\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00138NK6|'/\u001f)s_ZLG-\u001a:\u000b\u0005\r!\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u00151\u0011AB:4[>\u001c7N\u0003\u0002\b\u0011\u00059a-\u001b8eS\u001aL(\"A\u0005\u0002\u0005%|7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0001\u0002\u0015:pm&$WM\u001d\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005\u0019\u0003CA\n\u0001\u0011\u001d)\u0003A1A\u0005\n\u0019\nq!\u001c3Ti>\u0014X-F\u0001(!\tA3&D\u0001*\u0015\tQ#!\u0001\u0005nKR\fG-\u0019;b\u0013\ta\u0013FA\u000bJ]6+Wn\u001c:z\u001b\u0016$\u0018\rZ1uCN#xN]3\t\r9\u0002\u0001\u0015!\u0003(\u0003!iGm\u0015;pe\u0016\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%I!M\u0001\u0010EV\u001c7.\u001a;ECR\f7\u000b^8sKV\t!\u0007\u0005\u00034qi\nU\"\u0001\u001b\u000b\u0005U2\u0014AC2p]\u000e,(O]3oi*\u0011qGD\u0001\u000bG>dG.Z2uS>t\u0017BA\u001d5\u0005\u001d!&/[3NCB\u0004\"a\u000f \u000f\u00055a\u0014BA\u001f\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ur\u0001C\u0001\"D\u001b\u0005\u0001a\u0001\u0002#\u0001\t\u0016\u0013aBQ;dW\u0016$8i\u001c8uK:$8o\u0005\u0003D\u0019\u0019K\u0005CA\u0007H\u0013\tAeBA\u0004Qe>$Wo\u0019;\u0011\u00055Q\u0015BA&\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!i5I!f\u0001\n\u0003q\u0015\u0001D2sK\u0006$\u0018n\u001c8US6,W#A(\u0011\u0005AKV\"A)\u000b\u0005I\u001b\u0016!B7pI\u0016d'B\u0001+V\u0003!\u00198-\u00197bINd'B\u0001,X\u0003\u0011AG\u000f\u001e9\u000b\u0003a\u000bA!Y6lC&\u0011!,\u0015\u0002\t\t\u0006$X\rV5nK\"AAl\u0011B\tB\u0003%q*A\u0007de\u0016\fG/[8o)&lW\r\t\u0005\t=\u000e\u0013)\u001a!C\u0001?\u0006a1.Z=t\u0013:\u0014UoY6fiV\t\u0001\r\u0005\u0003bIj2W\"\u00012\u000b\u0005\r4\u0014aB7vi\u0006\u0014G.Z\u0005\u0003K\n\u00141!T1q!\t\u0011uM\u0002\u0003i\u0001\u0011K'aC&fs\u000e{g\u000e^3oiN\u001cBa\u001a\u0007G\u0013\"A1n\u001aBK\u0002\u0013\u0005a*\u0001\u000bmCN$Xj\u001c3jM&\u001c\u0017\r^5p]RKW.\u001a\u0005\t[\u001e\u0014\t\u0012)A\u0005\u001f\u0006)B.Y:u\u001b>$\u0017NZ5dCRLwN\u001c+j[\u0016\u0004\u0003\u0002C8h\u0005+\u0007I\u0011\u00019\u0002\t\u0011\fG/Y\u000b\u0002cB\u0019QB\u001d;\n\u0005Mt!!B!se\u0006L\bCA\u0007v\u0013\t1hB\u0001\u0003CsR,\u0007\u0002\u0003=h\u0005#\u0005\u000b\u0011B9\u0002\u000b\u0011\fG/\u0019\u0011\t\u000b\u0005:G\u0011\u0001>\u0015\u0007\u0019\\H\u0010C\u0003ls\u0002\u0007q\nC\u0003ps\u0002\u0007\u0011\u000fC\u0004\u007fO\u0006\u0005I\u0011A@\u0002\t\r|\u0007/\u001f\u000b\u0006M\u0006\u0005\u00111\u0001\u0005\bWv\u0004\n\u00111\u0001P\u0011\u001dyW\u0010%AA\u0002ED\u0011\"a\u0002h#\u0003%\t!!\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u0004\u001f\u000651FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ea\"\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005r-%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KQ3!]A\u0007\u0011%\tIcZA\u0001\n\u0003\nY#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003mC:<'BAA\u001c\u0003\u0011Q\u0017M^1\n\u0007}\n\t\u0004C\u0005\u0002>\u001d\f\t\u0011\"\u0001\u0002@\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\t\t\u0004\u001b\u0005\r\u0013bAA#\u001d\t\u0019\u0011J\u001c;\t\u0013\u0005%s-!A\u0005\u0002\u0005-\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002\u000e\u0003\u001fJ1!!\u0015\u000f\u0005\r\te.\u001f\u0005\u000b\u0003+\n9%!AA\u0002\u0005\u0005\u0013a\u0001=%c!I\u0011\u0011L4\u0002\u0002\u0013\u0005\u00131L\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\f\t\u0007\u0003?\n\t'!\u0014\u000e\u0003YJ1!a\u00197\u0005!IE/\u001a:bi>\u0014\b\"CA4O\u0006\u0005I\u0011AA5\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA6\u0003c\u00022!DA7\u0013\r\tyG\u0004\u0002\b\u0005>|G.Z1o\u0011)\t)&!\u001a\u0002\u0002\u0003\u0007\u0011Q\n\u0005\n\u0003k:\u0017\u0011!C!\u0003o\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003B\u0011\"a\u001fh\u0003\u0003%\t%! \u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\f\t\u0013\u0005\u0005u-!A\u0005B\u0005\r\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005\u0015\u0005BCA+\u0003\u007f\n\t\u00111\u0001\u0002N!I\u0011\u0011R\"\u0003\u0012\u0003\u0006I\u0001Y\u0001\u000eW\u0016L8/\u00138Ck\u000e\\W\r\u001e\u0011\t\r\u0005\u001aE\u0011AAG)\u0015\t\u0015qRAI\u0011\u0019i\u00151\u0012a\u0001\u001f\"1a,a#A\u0002\u0001D\u0001B`\"\u0002\u0002\u0013\u0005\u0011Q\u0013\u000b\u0006\u0003\u0006]\u0015\u0011\u0014\u0005\t\u001b\u0006M\u0005\u0013!a\u0001\u001f\"Aa,a%\u0011\u0002\u0003\u0007\u0001\rC\u0005\u0002\b\r\u000b\n\u0011\"\u0001\u0002\n!I\u0011\u0011E\"\u0012\u0002\u0013\u0005\u0011qT\u000b\u0003\u0003CS3\u0001YA\u0007\u0011%\tIcQA\u0001\n\u0003\nY\u0003C\u0005\u0002>\r\u000b\t\u0011\"\u0001\u0002@!I\u0011\u0011J\"\u0002\u0002\u0013\u0005\u0011\u0011\u0016\u000b\u0005\u0003\u001b\nY\u000b\u0003\u0006\u0002V\u0005\u001d\u0016\u0011!a\u0001\u0003\u0003B\u0011\"!\u0017D\u0003\u0003%\t%a\u0017\t\u0013\u0005\u001d4)!A\u0005\u0002\u0005EF\u0003BA6\u0003gC!\"!\u0016\u00020\u0006\u0005\t\u0019AA'\u0011%\t)hQA\u0001\n\u0003\n9\bC\u0005\u0002|\r\u000b\t\u0011\"\u0011\u0002~!I\u0011\u0011Q\"\u0002\u0002\u0013\u0005\u00131\u0018\u000b\u0005\u0003W\ni\f\u0003\u0006\u0002V\u0005e\u0016\u0011!a\u0001\u0003\u001bBq!!1\u0001A\u0003%!'\u0001\tck\u000e\\W\r\u001e#bi\u0006\u001cFo\u001c:fA!I\u0011Q\u0019\u0001C\u0002\u0013%\u0011qY\u0001\u0013[VdG/\u001b9beR$V-\u001c9Ti>\u0014X-\u0006\u0002\u0002JB)1\u0007\u000f\u001e\u0002LB)\u0011-!4\u0002R&\u0019\u0011q\u001a2\u0003\u0013M{'\u000f^3e'\u0016$\bc\u0001\"\u0002T\u001a1\u0011Q\u001b\u0001E\u0003/\u0014a\"T;mi&\u0004\u0018M\u001d;DQVt7nE\u0004\u0002T2\tINR%\u0011\r\u0005m\u00171^Ai\u001d\u0011\ti.a:\u000f\t\u0005}\u0017Q]\u0007\u0003\u0003CT1!a9\u000b\u0003\u0019a$o\\8u}%\tq\"C\u0002\u0002j:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002n\u0006=(aB(sI\u0016\u0014X\r\u001a\u0006\u0004\u0003St\u0001bCAz\u0003'\u0014)\u001a!C\u0001\u0003\u007f\ta\u0001]1si:{\u0007bCA|\u0003'\u0014\t\u0012)A\u0005\u0003\u0003\nq\u0001]1si:{\u0007\u0005C\u0005p\u0003'\u0014)\u001a!C\u0001a\"I\u00010a5\u0003\u0012\u0003\u0006I!\u001d\u0005\bC\u0005MG\u0011AA\u0000)\u0019\t\tN!\u0001\u0003\u0004!A\u00111_A\u007f\u0001\u0004\t\t\u0005\u0003\u0004p\u0003{\u0004\r!\u001d\u0005\t\u0005\u000f\t\u0019\u000e\"\u0011\u0003\n\u000591m\\7qCJ,G\u0003BA!\u0005\u0017A\u0001B!\u0004\u0003\u0006\u0001\u0007\u0011\u0011[\u0001\u0005i\"\fG\u000fC\u0005\u007f\u0003'\f\t\u0011\"\u0001\u0003\u0012Q1\u0011\u0011\u001bB\n\u0005+A!\"a=\u0003\u0010A\u0005\t\u0019AA!\u0011!y'q\u0002I\u0001\u0002\u0004\t\bBCA\u0004\u0003'\f\n\u0011\"\u0001\u0003\u001aU\u0011!1\u0004\u0016\u0005\u0003\u0003\ni\u0001\u0003\u0006\u0002\"\u0005M\u0017\u0013!C\u0001\u0003GA!\"!\u000b\u0002T\u0006\u0005I\u0011IA\u0016\u0011)\ti$a5\u0002\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u0013\n\u0019.!A\u0005\u0002\t\u0015B\u0003BA'\u0005OA!\"!\u0016\u0003$\u0005\u0005\t\u0019AA!\u0011)\tI&a5\u0002\u0002\u0013\u0005\u00131\f\u0005\u000b\u0003O\n\u0019.!A\u0005\u0002\t5B\u0003BA6\u0005_A!\"!\u0016\u0003,\u0005\u0005\t\u0019AA'\u0011)\t)(a5\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\u000b\u0003w\n\u0019.!A\u0005B\u0005u\u0004BCAA\u0003'\f\t\u0011\"\u0011\u00038Q!\u00111\u000eB\u001d\u0011)\t)F!\u000e\u0002\u0002\u0003\u0007\u0011Q\n\u0005\t\u0005{\u0001\u0001\u0015!\u0003\u0002J\u0006\u0019R.\u001e7uSB\f'\u000f\u001e+f[B\u001cFo\u001c:fA\u001dI!\u0011\t\u0001\u0002\u0002#%!1I\u0001\u000f\u0005V\u001c7.\u001a;D_:$XM\u001c;t!\r\u0011%Q\t\u0004\t\t\u0002\t\t\u0011#\u0003\u0003HM)!Q\tB%\u0013B9!1\nB)\u001f\u0002\fUB\u0001B'\u0015\r\u0011yED\u0001\beVtG/[7f\u0013\u0011\u0011\u0019F!\u0014\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\"\u0005\u000b\"\tAa\u0016\u0015\u0005\t\r\u0003BCA>\u0005\u000b\n\t\u0011\"\u0012\u0002~!Q!Q\fB#\u0003\u0003%\tIa\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b\u0005\u0013\tGa\u0019\t\r5\u0013Y\u00061\u0001P\u0011\u0019q&1\fa\u0001A\"Q!q\rB#\u0003\u0003%\tI!\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\u000eB<!\u0015i!Q\u000eB9\u0013\r\u0011yG\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b5\u0011\u0019h\u00141\n\u0007\tUdB\u0001\u0004UkBdWM\r\u0005\n\u0005s\u0012)'!AA\u0002\u0005\u000b1\u0001\u001f\u00131\u000f%\u0011i\bAA\u0001\u0012\u0013\u0011y(A\u0006LKf\u001cuN\u001c;f]R\u001c\bc\u0001\"\u0003\u0002\u001aA\u0001\u000eAA\u0001\u0012\u0013\u0011\u0019iE\u0003\u0003\u0002\n\u0015\u0015\nE\u0004\u0003L\tEs*\u001d4\t\u000f\u0005\u0012\t\t\"\u0001\u0003\nR\u0011!q\u0010\u0005\u000b\u0003w\u0012\t)!A\u0005F\u0005u\u0004B\u0003B/\u0005\u0003\u000b\t\u0011\"!\u0003\u0010R)aM!%\u0003\u0014\"11N!$A\u0002=Caa\u001cBG\u0001\u0004\t\bB\u0003B4\u0005\u0003\u000b\t\u0011\"!\u0003\u0018R!!\u0011\u0014BO!\u0015i!Q\u000eBN!\u0015i!1O(r\u0011%\u0011IH!&\u0002\u0002\u0003\u0007amB\u0005\u0003\"\u0002\t\t\u0011#\u0003\u0003$\u0006qQ*\u001e7uSB\f'\u000f^\"ik:\\\u0007c\u0001\"\u0003&\u001aI\u0011Q\u001b\u0001\u0002\u0002#%!qU\n\u0006\u0005K\u0013I+\u0013\t\n\u0005\u0017\u0012\t&!\u0011r\u0003#Dq!\tBS\t\u0003\u0011i\u000b\u0006\u0002\u0003$\"Q\u00111\u0010BS\u0003\u0003%)%! \t\u0015\tu#QUA\u0001\n\u0003\u0013\u0019\f\u0006\u0004\u0002R\nU&q\u0017\u0005\t\u0003g\u0014\t\f1\u0001\u0002B!1qN!-A\u0002ED!Ba\u001a\u0003&\u0006\u0005I\u0011\u0011B^)\u0011\u0011iL!1\u0011\u000b5\u0011iGa0\u0011\r5\u0011\u0019(!\u0011r\u0011)\u0011IH!/\u0002\u0002\u0003\u0007\u0011\u0011\u001b\u0005\b\u0005\u000b\u0004A\u0011\tBd\u00035iW\r^1eCR\f7\u000b^8sKV\u0011!\u0011\u001a\t\u0004Q\t-\u0017b\u0001BgS\tiQ*\u001a;bI\u0006$\u0018m\u0015;pe\u0016DqA!5\u0001\t\u0003\u0012\u0019.A\u0006mSN$()^2lKR\u001cXC\u0001Bk!\u0011\u00119N!8\u000e\u0005\te'b\u0001Bn\t\u0005A!/Z:q_:\u001cX-\u0003\u0003\u0003`\ne'\u0001\u0005'jgR\fE\u000e\\'z\u0005V\u001c7.\u001a;t\u0011\u001d\u0011\u0019\u000f\u0001C!\u0005K\f!\u0002\\5ti\n+8m[3u)!\u00119O!<\u0003r\n]\b\u0003\u0002Bl\u0005SLAAa;\u0003Z\nQA*[:u\u0005V\u001c7.\u001a;\t\u000f\t=(\u0011\u001da\u0001u\u00051!-^2lKRD\u0001Ba=\u0003b\u0002\u0007!Q_\u0001\u0007aJ,g-\u001b=\u0011\t5\u0011iG\u000f\u0005\t\u0005s\u0014\t\u000f1\u0001\u0003v\u0006IA-\u001a7j[&$XM\u001d\u0005\b\u0005{\u0004A\u0011\tB\u0000\u00031\u0019'/Z1uK\n+8m[3u)\u0019\u0019\taa\u0002\u0004\fA!!q[B\u0002\u0013\u0011\u0019)A!7\u0003\u0019\r\u0013X-\u0019;f\u0005V\u001c7.\u001a;\t\u000f\r%!1 a\u0001u\u0005!a.Y7f\u0011!\u0019iAa?A\u0002\r=\u0011\u0001\u00042vG.,GoQ8oM&<\u0007\u0003BB\t\u0007/i!aa\u0005\u000b\u0007\rUA!A\u0004sKF,Xm\u001d;\n\t\re11\u0003\u0002\u001a\u0007J,\u0017\r^3Ck\u000e\\W\r^\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0004\u001e\u0001!\tea\b\u0002\u0013A,Ho\u00142kK\u000e$HCCB\u0011\u0007O\u0019Ic!\f\u00040A\u0019Qba\t\n\u0007\r\u0015bB\u0001\u0003V]&$\bb\u0002Bx\u00077\u0001\rA\u000f\u0005\b\u0007W\u0019Y\u00021\u0001;\u0003\rYW-\u001f\u0005\u0007_\u000em\u0001\u0019A9\t\u0015\rE21\u0004I\u0001\u0002\u0004\u0019\u0019$\u0001\bpE*,7\r^'fi\u0006$\u0017\r^1\u0011\u000b5\u0011ig!\u000e\u0011\t\r]2qI\u0007\u0003\u0007sQ1AUB\u001e\u0015\u0011\u0019ida\u0010\u0002\u0005M\u001c$\u0002BB!\u0007\u0007\n\u0001b]3sm&\u001cWm\u001d\u0006\u0004\u0007\u000bb\u0012!C1nCj|g.Y<t\u0013\u0011\u0019Ie!\u000f\u0003\u001d=\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\"91Q\n\u0001\u0005B\r=\u0013!C4fi>\u0013'.Z2u)\u0019\u0019\tfa\u0016\u0004ZA\u00191ca\u0015\n\u0007\rU#AA\u0007HKR|%M[3di\u0012\u000bG/\u0019\u0005\b\u0005_\u001cY\u00051\u0001;\u0011\u001d\u0019Yca\u0013A\u0002iBqa!\u0018\u0001\t\u0003\u001ay&A\fqkR|%M[3di6+H\u000e^5qCJ$8\u000b^1siR11\u0011MB4\u0007S\u0002BAa6\u0004d%!1Q\rBm\u0005uIe.\u001b;jCR,W*\u001e7uSB\f'\u000f^+qY>\fGMU3tk2$\bb\u0002Bx\u00077\u0002\rA\u000f\u0005\b\u0007W\u0019Y\u00061\u0001;\u0011\u001d\u0019i\u0007\u0001C!\u0007_\na\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siB\u000b'\u000f\u001e\u000b\r\u0007C\u0019\tha\u001d\u0004v\re4Q\u0010\u0005\b\u0005_\u001cY\u00071\u0001;\u0011\u001d\u0019Yca\u001bA\u0002iB\u0001ba\u001e\u0004l\u0001\u0007\u0011\u0011I\u0001\u000ba\u0006\u0014HOT;nE\u0016\u0014\bbBB>\u0007W\u0002\rAO\u0001\tkBdw.\u00193JI\"1qna\u001bA\u0002EDqa!!\u0001\t\u0003\u001a\u0019)\u0001\u000eqkR|%M[3di6+H\u000e^5qCJ$8i\\7qY\u0016$X\r\u0006\u0006\u0004\u0006\u000e-5QRBH\u0007#\u0003BAa6\u0004\b&!1\u0011\u0012Bm\u0005u\u0019u.\u001c9mKR,W*\u001e7uSB\f'\u000f^+qY>\fGMU3tk2$\bb\u0002Bx\u0007\u007f\u0002\rA\u000f\u0005\b\u0007W\u0019y\b1\u0001;\u0011\u001d\u0019Yha A\u0002iB\u0001b!\u0006\u0004\u0000\u0001\u000711\u0013\t\u0005\u0007#\u0019)*\u0003\u0003\u0004\u0018\u000eM!aF\"p[BdW\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e\u0011\u001d\u0019Y\n\u0001C!\u0007;\u000b!bY8qs>\u0013'.Z2u)1\u0019yj!*\u0004*\u000e56\u0011WB[!\u0011\u00119n!)\n\t\r\r&\u0011\u001c\u0002\u0011\u0007>\u0004\u0018p\u00142kK\u000e$(+Z:vYRDqaa*\u0004\u001a\u0002\u0007!(\u0001\u0007t_V\u00148-\u001a\"vG.,G\u000fC\u0004\u0004,\u000ee\u0005\u0019\u0001\u001e\u0002\u0013M|WO]2f\u0017\u0016L\bbBBX\u00073\u0003\rAO\u0001\u000bI\u0016\u001cHOQ;dW\u0016$\bbBBZ\u00073\u0003\rAO\u0001\bI\u0016\u001cHoS3z\u0011)\u00199l!'\u0011\u0002\u0003\u000711G\u0001\b]\u0016<X*\u001a;b\u0011\u001d\u0019Y\f\u0001C!\u0007{\u000bA\u0002Z3mKR,wJ\u00196fGR$ba!\t\u0004@\u000e\u0005\u0007b\u0002Bx\u0007s\u0003\rA\u000f\u0005\b\u0007W\u0019I\f1\u0001;\u0011\u001d\u0019)\r\u0001C!\u0007\u000f\fA\u0002Z3mKR,')^2lKR$Ba!\t\u0004J\"9!q^Bb\u0001\u0004Q\u0004\"CBg\u0001E\u0005I\u0011IBh\u0003M\u0001X\u000f^(cU\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tN\u000b\u0003\u00044\u00055\u0001\"CBk\u0001E\u0005I\u0011IBh\u0003Q\u0019w\u000e]=PE*,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u0001")
public class InMemoryProvider
implements Provider,
LazyLogging {
    private final InMemoryMetadataStore mdStore;
    private final TrieMap<String, BucketContents> bucketDataStore;
    private final TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore;
    private volatile InMemoryProvider$BucketContents$ io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module;
    private volatile InMemoryProvider$KeyContents$ io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module;
    private volatile InMemoryProvider$MultipartChunk$ io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module;
    private final Logger logger;
    private volatile boolean bitmap$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InMemoryProvider$BucketContents$ io$findify$s3mock$provider$InMemoryProvider$$BucketContents$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module != null) return this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module;
            this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module = new InMemoryProvider$BucketContents$(this);
            return this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InMemoryProvider$KeyContents$ io$findify$s3mock$provider$InMemoryProvider$$KeyContents$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module != null) return this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module;
            this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module = new InMemoryProvider$KeyContents$(this);
            return this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InMemoryProvider$MultipartChunk$ io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module != null) return this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module;
            this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module = new InMemoryProvider$MultipartChunk$(this);
            return this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module;
        }
    }

    private Logger logger$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private InMemoryMetadataStore mdStore() {
        return this.mdStore;
    }

    private TrieMap<String, BucketContents> bucketDataStore() {
        return this.bucketDataStore;
    }

    private TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore() {
        return this.multipartTempStore;
    }

    public InMemoryProvider$BucketContents$ io$findify$s3mock$provider$InMemoryProvider$$BucketContents() {
        return this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module == null ? this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$lzycompute() : this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents$module;
    }

    public InMemoryProvider$KeyContents$ io$findify$s3mock$provider$InMemoryProvider$$KeyContents() {
        return this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module == null ? this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$lzycompute() : this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents$module;
    }

    public InMemoryProvider$MultipartChunk$ io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk() {
        return this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module == null ? this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$lzycompute() : this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk$module;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.mdStore();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.Iterable buckets = (scala.collection.mutable.Iterable)this.bucketDataStore().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Bucket apply(Tuple2<String, BucketContents> x0$1) {
                Tuple2<String, BucketContents> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    BucketContents data = (BucketContents)tuple2._2();
                    Bucket bucket = new Bucket(name, data.creationTime());
                    return bucket;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing buckets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buckets.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Bucket x$1) {
                    return x$1.name();
                }
            }, Iterable$.MODULE$.canBuildFrom())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets.toList());
    }

    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter) {
        Option option;
        block6: {
            Option<String> option2;
            block9: {
                Nil$ nil$;
                Iterable matchResults;
                block8: {
                    block7: {
                        BoxedUnit boxedUnit;
                        String prefix2 = (String)prefix.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        });
                        option = this.bucketDataStore().get((Object)bucket);
                        if (!(option instanceof Some)) break block6;
                        Some some = (Some)option;
                        BucketContents bucketContent = (BucketContents)some.x();
                        Map matchingKeys = bucketContent.keysInBucket().filterKeys((Function1)new Serializable(this, prefix2){
                            public static final long serialVersionUID = 0L;
                            private final String prefix2$1;

                            public final boolean apply(String x$2) {
                                return x$2.startsWith(this.prefix2$1);
                            }
                            {
                                this.prefix2$1 = prefix2$1;
                            }
                        });
                        matchResults = (Iterable)matchingKeys.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Content apply(Tuple2<String, KeyContents> x0$2) {
                                Tuple2<String, KeyContents> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String name = (String)tuple2._1();
                                    KeyContents content = (KeyContents)tuple2._2();
                                    Content content2 = new Content(name, content.lastModificationTime(), DigestUtils.md5Hex((byte[])content.data()), content.data().length, "STANDARD");
                                    return content2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing bucket contents: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{matchResults.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Content x$3) {
                                    return x$3.key();
                                }
                            }, scala.collection.Iterable$.MODULE$.canBuildFrom())})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        option2 = delimiter;
                        if (!(option2 instanceof Some)) break block7;
                        Some some2 = (Some)option2;
                        String del = (String)some2.x();
                        nil$ = (List)((SeqLike)((TraversableOnce)matchResults.flatMap((Function1)new Serializable(this, prefix2, del){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ InMemoryProvider $outer;
                            private final String prefix2$1;
                            private final String del$1;

                            public final Iterable<String> apply(Content f) {
                                return Option$.MODULE$.option2Iterable(this.$outer.io$findify$s3mock$provider$InMemoryProvider$$commonPrefix$1(f.key(), this.prefix2$1, this.del$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.prefix2$1 = prefix2$1;
                                this.del$1 = del$1;
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).distinct();
                        break block8;
                    }
                    if (!None$.MODULE$.equals(option2)) break block9;
                    nil$ = Nil$.MODULE$;
                }
                Nil$ commonPrefixes = nil$;
                List filteredFiles = ((TraversableOnce)matchResults.filterNot((Function1)new Serializable(this, (List)commonPrefixes){
                    public static final long serialVersionUID = 0L;
                    private final List commonPrefixes$1;

                    public final boolean apply(Content f) {
                        return this.commonPrefixes$1.exists((Function1)new Serializable(this, f){
                            public static final long serialVersionUID = 0L;
                            private final Content f$1;

                            public final boolean apply(String p) {
                                return this.f$1.key().startsWith(p);
                            }
                            {
                                this.f$1 = f$1;
                            }
                        });
                    }
                    {
                        this.commonPrefixes$1 = commonPrefixes$1;
                    }
                })).toList();
                ListBucket listBucket2 = new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)((List)filteredFiles.sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Content x$4) {
                        return x$4.key();
                    }
                }, (Ordering)Ordering.String$.MODULE$)));
                return listBucket2;
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        this.bucketDataStore().putIfAbsent((Object)name, (Object)this.io$findify$s3mock$provider$InMemoryProvider$$BucketContents().apply(DateTime$.MODULE$.now(), (scala.collection.mutable.Map<String, KeyContents>)new TrieMap()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating bucket ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, Option<ObjectMetadata> objectMetadata) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.x();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"putting object for s3://", "/", ", bytes = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key, BoxesRunTime.boxToInteger((int)data.length)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bucketContent.keysInBucket().put((Object)key, (Object)this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents().apply(DateTime$.MODULE$.now(), data));
            objectMetadata.foreach((Function1)new Serializable(this, bucket, key){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ InMemoryProvider $outer;
                private final String bucket$1;
                private final String key$1;

                public final void apply(ObjectMetadata meta) {
                    this.$outer.metadataStore().put(this.bucket$1, this.key$1, meta);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.bucket$1 = bucket$1;
                    this.key$1 = key$1;
                }
            });
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<ObjectMetadata> putObject$default$4() {
        return None$.MODULE$;
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.x();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                GetObjectData getObjectData;
                BoxedUnit boxedUnit;
                Some some2 = (Some)option2;
                KeyContents keyContent = (KeyContents)some2.x();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reading object for s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
                GetObjectData getObjectData2 = getObjectData = new GetObjectData(keyContent.data(), meta);
                return getObjectData2;
            }
            if (None$.MODULE$.equals(option2)) {
                throw new NoSuchKeyException(bucket, key);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            String id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
            this.multipartTempStore().putIfAbsent((Object)id, (Object)new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult(bucket, key, id);
            return initiateMultipartUploadResult;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uploading multipart chunk ", " for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ((SetLike)this.multipartTempStore().getOrElseUpdate((Object)uploadId, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TreeSet<MultipartChunk> apply() {
                    return new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                }
            })).add((Object)this.io$findify$s3mock$provider$InMemoryProvider$$MultipartChunk().apply(partNumber, data));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.x();
            byte[] completeBytes = (byte[])((TraversableOnce)((scala.collection.SetLike)this.multipartTempStore().apply((Object)uploadId)).toSeq().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(MultipartChunk x$5) {
                    return x$5.data();
                }
            }, Seq$.MODULE$.canBuildFrom())).fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(byte[] x$6, byte[] x$7) {
                    return (byte[])Predef$.MODULE$.byteArrayOps(x$6).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(x$7), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                }
            });
            bucketContent.keysInBucket().put((Object)key, (Object)this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents().apply(DateTime$.MODULE$.now(), completeBytes));
            this.multipartTempStore().remove((Object)uploadId);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completed multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult(bucket, key, DigestUtils.md5Hex((byte[])completeBytes));
            return completeMultipartUploadResult;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        Option option;
        Tuple2 tuple2 = new Tuple2((Object)this.bucketDataStore().get((Object)sourceBucket), (Object)this.bucketDataStore().get((Object)destBucket));
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                BucketContents srcBucketContent = (BucketContents)some.x();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    BucketContents dstBucketContent = (BucketContents)some2.x();
                    Option option4 = srcBucketContent.keysInBucket().get((Object)sourceKey);
                    if (option4 instanceof Some) {
                        CopyObjectResult copyObjectResult;
                        BoxedUnit boxedUnit;
                        Some some3 = (Some)option4;
                        KeyContents srcKeyContent = (KeyContents)some3.x();
                        DateTime destFileModTime = DateTime$.MODULE$.now();
                        dstBucketContent.keysInBucket().put((Object)destKey, (Object)this.io$findify$s3mock$provider$InMemoryProvider$$KeyContents().apply(destFileModTime, (byte[])srcKeyContent.data().clone()));
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied s3://", "/", " to s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceBucket, sourceKey, destBucket, destKey})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Option sourceMeta = newMeta.orElse((Function0)new Serializable(this, sourceBucket, sourceKey){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ InMemoryProvider $outer;
                            private final String sourceBucket$1;
                            private final String sourceKey$1;

                            public final Option<ObjectMetadata> apply() {
                                return this.$outer.metadataStore().get(this.sourceBucket$1, this.sourceKey$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.sourceBucket$1 = sourceBucket$1;
                                this.sourceKey$1 = sourceKey$1;
                            }
                        });
                        sourceMeta.foreach((Function1)new Serializable(this, destBucket, destKey){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ InMemoryProvider $outer;
                            private final String destBucket$1;
                            private final String destKey$1;

                            public final void apply(ObjectMetadata meta) {
                                this.$outer.metadataStore().put(this.destBucket$1, this.destKey$1, meta);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.destBucket$1 = destBucket$1;
                                this.destKey$1 = destKey$1;
                            }
                        });
                        CopyObjectResult copyObjectResult2 = copyObjectResult = new CopyObjectResult(destFileModTime, DigestUtils.md5Hex((byte[])srcKeyContent.data()));
                        return copyObjectResult2;
                    }
                    if (None$.MODULE$.equals(option4)) {
                        throw new NoSuchKeyException(sourceBucket, sourceKey);
                    }
                    throw new MatchError((Object)option4);
                }
            }
        }
        if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
            throw new NoSuchBucketException(sourceBucket);
        }
        throw new NoSuchBucketException(destBucket);
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    @Override
    public void deleteObject(String bucket, String key) {
        Option option;
        block11: {
            Option option2;
            block14: {
                Option option3;
                block15: {
                    block13: {
                        BoxedUnit boxedUnit;
                        BucketContents bucketContent;
                        block12: {
                            BoxedUnit boxedUnit2;
                            option = this.bucketDataStore().get((Object)bucket);
                            if (!(option instanceof Some)) break block11;
                            Some some = (Some)option;
                            bucketContent = (BucketContents)some.x();
                            option2 = bucketContent.keysInBucket().get((Object)key);
                            if (!(option2 instanceof Some)) break block12;
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting object s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            bucketContent.keysInBucket().remove((Object)key);
                            this.metadataStore().delete(bucket, key);
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            break block13;
                        }
                        if (!None$.MODULE$.equals(option2)) break block14;
                        option3 = bucketContent.keysInBucket().keys().find((Function1)new Serializable(this, key){
                            public static final long serialVersionUID = 0L;
                            private final String key$2;

                            public final boolean apply(String x$8) {
                                return x$8.startsWith(this.key$2);
                            }
                            {
                                this.key$2 = key$2;
                            }
                        });
                        if (!(option3 instanceof Some)) break block15;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recursive delete by prefix is not supported by S3"})).s((Seq)Nil$.MODULE$));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (None$.MODULE$.equals(option3)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key does not exist"})).s((Seq)Nil$.MODULE$));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NoSuchKeyException(bucket, key);
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void deleteBucket(String bucket) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting bucket s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.bucketDataStore().remove((Object)bucket);
            this.metadataStore().remove(bucket);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchBucketException(bucket);
        }
        throw new MatchError((Object)option);
    }

    public final Option io$findify$s3mock$provider$InMemoryProvider$$commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            default: {
                none$ = new Some((Object)new StringBuilder().append((Object)p).append((Object)dir.substring(p.length(), n)).append((Object)d).toString());
                break;
            }
            case -1: {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public InMemoryProvider() {
        Provider$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.mdStore = new InMemoryMetadataStore();
        this.bucketDataStore = new TrieMap();
        this.multipartTempStore = new TrieMap();
    }

    public class KeyContents
    implements Product,
    Serializable {
        private final DateTime lastModificationTime;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime lastModificationTime() {
            return this.lastModificationTime;
        }

        public byte[] data() {
            return this.data;
        }

        public KeyContents copy(DateTime lastModificationTime, byte[] data) {
            return new KeyContents(this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer(), lastModificationTime, data);
        }

        public DateTime copy$default$1() {
            return this.lastModificationTime();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "KeyContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.data();
                    break;
                }
                case 0: {
                    object = this.lastModificationTime();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KeyContents)) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyContents keyContents = (KeyContents)x$1;
            DateTime dateTime = this.lastModificationTime();
            DateTime dateTime2 = keyContents.lastModificationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (this.data() != keyContents.data()) return false;
            if (!keyContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() {
            return this.$outer;
        }

        public KeyContents(InMemoryProvider $outer, DateTime lastModificationTime, byte[] data) {
            this.lastModificationTime = lastModificationTime;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class BucketContents
    implements Product,
    Serializable {
        private final DateTime creationTime;
        private final scala.collection.mutable.Map<String, KeyContents> keysInBucket;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime creationTime() {
            return this.creationTime;
        }

        public scala.collection.mutable.Map<String, KeyContents> keysInBucket() {
            return this.keysInBucket;
        }

        public BucketContents copy(DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            return new BucketContents(this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer(), creationTime, keysInBucket);
        }

        public DateTime copy$default$1() {
            return this.creationTime();
        }

        public scala.collection.mutable.Map<String, KeyContents> copy$default$2() {
            return this.keysInBucket();
        }

        public String productPrefix() {
            return "BucketContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            DateTime dateTime;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    dateTime = this.keysInBucket();
                    break;
                }
                case 0: {
                    dateTime = this.creationTime();
                }
            }
            return dateTime;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BucketContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BucketContents)) return false;
            boolean bl = true;
            if (!bl) return false;
            BucketContents bucketContents = (BucketContents)x$1;
            DateTime dateTime = this.creationTime();
            DateTime dateTime2 = bucketContents.creationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            scala.collection.mutable.Map<String, KeyContents> map = this.keysInBucket();
            scala.collection.mutable.Map<String, KeyContents> map2 = bucketContents.keysInBucket();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!bucketContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() {
            return this.$outer;
        }

        public BucketContents(InMemoryProvider $outer, DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            this.creationTime = creationTime;
            this.keysInBucket = keysInBucket;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class MultipartChunk
    implements Ordered<MultipartChunk>,
    Product,
    Serializable {
        private final int partNo;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public boolean $less(Object that) {
            return Ordered.class.$less((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.class.$greater((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.class.$less$eq((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.class.$greater$eq((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.class.compareTo((Ordered)this, (Object)that);
        }

        public int partNo() {
            return this.partNo;
        }

        public byte[] data() {
            return this.data;
        }

        public int compare(MultipartChunk that) {
            return Predef$.MODULE$.int2Integer(this.partNo()).compareTo(Predef$.MODULE$.int2Integer(that.partNo()));
        }

        public MultipartChunk copy(int partNo, byte[] data) {
            return new MultipartChunk(this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer(), partNo, data);
        }

        public int copy$default$1() {
            return this.partNo();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "MultipartChunk";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.data();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.partNo());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MultipartChunk;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partNo());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MultipartChunk)) return false;
            boolean bl = true;
            if (!bl) return false;
            MultipartChunk multipartChunk = (MultipartChunk)x$1;
            if (this.partNo() != multipartChunk.partNo()) return false;
            if (this.data() != multipartChunk.data()) return false;
            if (!multipartChunk.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() {
            return this.$outer;
        }

        public MultipartChunk(InMemoryProvider $outer, int partNo, byte[] data) {
            this.partNo = partNo;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.class.$init$((Ordered)this);
            Product.class.$init$((Product)this);
        }
    }
}

