/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime$;
import better.files.File;
import better.files.File$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.Provider$class;
import io.findify.s3mock.provider.metadata.MapMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CompleteMultipartUploadPart;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.File;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001-\u0011ABR5mKB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011A\u0014xN^5eKJT!!\u0002\u0004\u0002\rM\u001cTn\\2l\u0015\t9\u0001\"A\u0004gS:$\u0017NZ=\u000b\u0003%\t!![8\u0004\u0001M!\u0001\u0001\u0004\n\u0017!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\t!J|g/\u001b3feB\u0011qCH\u0007\u00021)\u0011\u0011DG\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00037q\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002;\u0005\u00191m\\7\n\u0005}A\"a\u0003'bufdunZ4j]\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0004I&\u0014\bCA\u0012'\u001d\tiA%\u0003\u0002&\u001d\u00051\u0001K]3eK\u001aL!a\n\u0015\u0003\rM#(/\u001b8h\u0015\t)c\u0002C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0003Y5\u0002\"a\u0005\u0001\t\u000b\u0005J\u0003\u0019\u0001\u0012\t\u000f=\u0002!\u0019!C\u0001a\u00059qo\u001c:l\t&\u0014X#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!\u00024jY\u0016\u001c(\"\u0001\u001c\u0002\r\t,G\u000f^3s\u0013\tA4G\u0001\u0003GS2,\u0007B\u0002\u001e\u0001A\u0003%\u0011'\u0001\u0005x_J\\G)\u001b:!\u0011\u001da\u0004A1A\u0005\nu\nA!\\3uCV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\u0005\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002D\u0001\n\u0001R*\u00199NKR\fG-\u0019;b'R|'/\u001a\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002 \u0002\u000b5,G/\u0019\u0011\t\u000b\u001d\u0003A\u0011\t%\u0002\u001b5,G/\u00193bi\u0006\u001cFo\u001c:f+\u0005I\u0005CA K\u0013\tY\u0005IA\u0007NKR\fG-\u0019;b'R|'/\u001a\u0005\u0006\u001b\u0002!\tET\u0001\fY&\u001cHOQ;dW\u0016$8/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0005sKN\u0004xN\\:f\u0013\t!\u0016K\u0001\tMSN$\u0018\t\u001c7Ns\n+8m[3ug\")a\u000b\u0001C!/\u0006QA.[:u\u0005V\u001c7.\u001a;\u0015\u000ba[VL\u00193\u0011\u0005AK\u0016B\u0001.R\u0005)a\u0015n\u001d;Ck\u000e\\W\r\u001e\u0005\u00069V\u0003\rAI\u0001\u0007EV\u001c7.\u001a;\t\u000by+\u0006\u0019A0\u0002\rA\u0014XMZ5y!\ri\u0001MI\u0005\u0003C:\u0011aa\u00149uS>t\u0007\"B2V\u0001\u0004y\u0016!\u00033fY&l\u0017\u000e^3s\u0011\u0015)W\u000b1\u0001g\u0003\u001di\u0017\r_6fsN\u00042!\u00041h!\ti\u0001.\u0003\u0002j\u001d\t\u0019\u0011J\u001c;\t\u000b-\u0004A\u0011\t7\u0002\u0019\r\u0014X-\u0019;f\u0005V\u001c7.\u001a;\u0015\u00075\u0004(\u000f\u0005\u0002Q]&\u0011q.\u0015\u0002\r\u0007J,\u0017\r^3Ck\u000e\\W\r\u001e\u0005\u0006c*\u0004\rAI\u0001\u0005]\u0006lW\rC\u0003tU\u0002\u0007A/\u0001\u0007ck\u000e\\W\r^\"p]\u001aLw\r\u0005\u0002vq6\taO\u0003\u0002x\t\u00059!/Z9vKN$\u0018BA=w\u0005e\u0019%/Z1uK\n+8m[3u\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bm\u0004A\u0011\t?\u0002\u0013A,Ho\u00142kK\u000e$H#C?\u0002\u0002\u0005\r\u0011qAA\f!\tia0\u0003\u0002\u0000\u001d\t!QK\\5u\u0011\u0015a&\u00101\u0001#\u0011\u0019\t)A\u001fa\u0001E\u0005\u00191.Z=\t\u000f\u0005%!\u00101\u0001\u0002\f\u0005!A-\u0019;b!\u0015i\u0011QBA\t\u0013\r\tyA\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001b\u0005M\u0011bAA\u000b\u001d\t!!)\u001f;f\u0011\u001d\tIB\u001fa\u0001\u00037\tab\u001c2kK\u000e$X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002\u001e\u0005=RBAA\u0010\u0015\u0011\t\t#a\t\u0002\u000b5|G-\u001a7\u000b\t\u0005\u0015\u0012qE\u0001\u0003gNRA!!\u000b\u0002,\u0005A1/\u001a:wS\u000e,7OC\u0002\u0002.q\t\u0011\"Y7bu>t\u0017m^:\n\t\u0005E\u0012q\u0004\u0002\u000f\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0011\u001d\t)\u0004\u0001C!\u0003o\t\u0011bZ3u\u001f\nTWm\u0019;\u0015\r\u0005e\u0012qHA!!\r\u0019\u00121H\u0005\u0004\u0003{\u0011!!D$fi>\u0013'.Z2u\t\u0006$\u0018\r\u0003\u0004]\u0003g\u0001\rA\t\u0005\b\u0003\u000b\t\u0019\u00041\u0001#\u0011\u001d\t)\u0005\u0001C!\u0003\u000f\nq\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siN#\u0018M\u001d;\u0015\r\u0005%\u0013qJA)!\r\u0001\u00161J\u0005\u0004\u0003\u001b\n&!H%oSRL\u0017\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e%\u0016\u001cX\u000f\u001c;\t\rq\u000b\u0019\u00051\u0001#\u0011\u001d\t)!a\u0011A\u0002\tBq!!\u0016\u0001\t\u0003\n9&\u0001\fqkR|%M[3di6+H\u000e^5qCJ$\b+\u0019:u)-i\u0018\u0011LA.\u0003;\n\t'!\u001a\t\rq\u000b\u0019\u00061\u0001#\u0011\u001d\t)!a\u0015A\u0002\tBq!a\u0018\u0002T\u0001\u0007q-\u0001\u0006qCJ$h*^7cKJDq!a\u0019\u0002T\u0001\u0007!%\u0001\u0005va2|\u0017\rZ%e\u0011!\tI!a\u0015A\u0002\u0005-\u0001bBA5\u0001\u0011\u0005\u00131N\u0001\u001baV$xJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014HoQ8na2,G/\u001a\u000b\u000b\u0003[\n\u0019(!\u001e\u0002x\u0005e\u0004c\u0001)\u0002p%\u0019\u0011\u0011O)\u0003;\r{W\u000e\u001d7fi\u0016lU\u000f\u001c;ja\u0006\u0014H/\u00169m_\u0006$'+Z:vYRDa\u0001XA4\u0001\u0004\u0011\u0003bBA\u0003\u0003O\u0002\rA\t\u0005\b\u0003G\n9\u00071\u0001#\u0011\u001d9\u0018q\ra\u0001\u0003w\u00022!^A?\u0013\r\tyH\u001e\u0002\u0018\u0007>l\u0007\u000f\\3uK6+H\u000e^5qCJ$X\u000b\u001d7pC\u0012Dq!a!\u0001\t\u0003\n))\u0001\u0006d_BLxJ\u00196fGR$B\"a\"\u0002\u000e\u0006E\u0015QSAM\u0003;\u00032\u0001UAE\u0013\r\tY)\u0015\u0002\u0011\u0007>\u0004\u0018p\u00142kK\u000e$(+Z:vYRDq!a$\u0002\u0002\u0002\u0007!%\u0001\u0007t_V\u00148-\u001a\"vG.,G\u000fC\u0004\u0002\u0014\u0006\u0005\u0005\u0019\u0001\u0012\u0002\u0013M|WO]2f\u0017\u0016L\bbBAL\u0003\u0003\u0003\rAI\u0001\u000bI\u0016\u001cHOQ;dW\u0016$\bbBAN\u0003\u0003\u0003\rAI\u0001\bI\u0016\u001cHoS3z\u0011)\ty*!!\u0011\u0002\u0003\u0007\u0011\u0011U\u0001\b]\u0016<X*\u001a;b!\u0011i\u0001-a\u0007\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006aA-\u001a7fi\u0016|%M[3diR)Q0!+\u0002,\"1A,a)A\u0002\tBq!!\u0002\u0002$\u0002\u0007!\u0005C\u0004\u00020\u0002!\t%!-\u0002\u0019\u0011,G.\u001a;f\u0005V\u001c7.\u001a;\u0015\u0007u\f\u0019\f\u0003\u0004]\u0003[\u0003\rA\t\u0005\b\u0003o\u0003A\u0011BA]\u0003\u00191'o\\7PgR\u0019!%a/\t\u000f\u0005u\u0016Q\u0017a\u0001E\u0005!\u0001/\u0019;i\u0011%\t\t\rAI\u0001\n\u0003\n\u0019-\u0001\u000bd_BLxJ\u00196fGR$C-\u001a4bk2$H%N\u000b\u0003\u0003\u000bTC!!)\u0002H.\u0012\u0011\u0011\u001a\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003%)hn\u00195fG.,GMC\u0002\u0002T:\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9.!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class FileProvider
implements Provider,
LazyLogging {
    public final String io$findify$s3mock$provider$FileProvider$$dir;
    private final better.files.File workDir;
    private final MapMetadataStore meta;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileProvider fileProvider = this;
        synchronized (fileProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public better.files.File workDir() {
        return this.workDir;
    }

    private MapMetadataStore meta() {
        return this.meta;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.meta();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        List buckets = File$.MODULE$.apply(this.io$findify$s3mock$provider$FileProvider$$dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).list().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileProvider $outer;

            public final Bucket apply(better.files.File f) {
                return new Bucket(this.$outer.io$findify$s3mock$provider$FileProvider$$fromOs(f.name()), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing buckets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buckets.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Bucket x$1) {
                    return x$1.name();
                }
            }, List$.MODULE$.canBuildFrom())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets);
    }

    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter, Option<Object> maxkeys) {
        block5: {
            Option<String> option;
            block8: {
                Nil$ nil$;
                List files;
                block7: {
                    block6: {
                        BoxedUnit boxedUnit;
                        String prefixNoLeadingSlash = (String)new StringOps(Predef$.MODULE$.augmentString((String)prefix.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }))).dropWhile((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(char x$2) {
                                return x$2 == '/';
                            }
                        });
                        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                        if (!bucketFile.exists(bucketFile.exists$default$1())) break block5;
                        String bucketFileString = this.io$findify$s3mock$provider$FileProvider$$fromOs(bucketFile.toString());
                        Iterator bucketFiles = bucketFile.listRecursively(bucketFile.listRecursively$default$1()).filter((Function1)new Serializable(this, prefixNoLeadingSlash, bucketFileString){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileProvider $outer;
                            private final String prefixNoLeadingSlash$1;
                            private final String bucketFileString$1;

                            public final boolean apply(better.files.File f) {
                                String fString = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(this.$outer.io$findify$s3mock$provider$FileProvider$$fromOs(f.toString()))).drop(this.bucketFileString$1.length()))).dropWhile((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(char x$3) {
                                        return x$3 == '/';
                                    }
                                });
                                return fString.startsWith(this.prefixNoLeadingSlash$1) && !f.isDirectory(f.isDirectory$default$1());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.prefixNoLeadingSlash$1 = prefixNoLeadingSlash$1;
                                this.bucketFileString$1 = bucketFileString$1;
                            }
                        });
                        files = bucketFiles.map((Function1)new Serializable(this, bucketFileString){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileProvider $outer;
                            private final String bucketFileString$1;

                            public final Content apply(better.files.File f) {
                                return new Content((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(this.$outer.io$findify$s3mock$provider$FileProvider$$fromOs(f.toString()))).drop(this.bucketFileString$1.length() + 1))).dropWhile((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(char x$4) {
                                        return x$4 == '/';
                                    }
                                }), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()), "0", f.size(f.size$default$1()), "STANDARD");
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.bucketFileString$1 = bucketFileString$1;
                            }
                        }).toList();
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing bucket contents: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Content x$5) {
                                    return x$5.key();
                                }
                            }, List$.MODULE$.canBuildFrom())})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        option = delimiter;
                        if (!(option instanceof Some)) break block6;
                        Some some = (Some)option;
                        String del = (String)some.x();
                        nil$ = (List)((SeqLike)((SeqLike)files.flatMap((Function1)new Serializable(this, prefixNoLeadingSlash, del){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ FileProvider $outer;
                            private final String prefixNoLeadingSlash$1;
                            private final String del$1;

                            public final Iterable<String> apply(Content f) {
                                return Option$.MODULE$.option2Iterable(this.$outer.io$findify$s3mock$provider$FileProvider$$commonPrefix$1(f.key(), this.prefixNoLeadingSlash$1, this.del$1));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.prefixNoLeadingSlash$1 = prefixNoLeadingSlash$1;
                                this.del$1 = del$1;
                            }
                        }, List$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
                        break block7;
                    }
                    if (!None$.MODULE$.equals(option)) break block8;
                    nil$ = Nil$.MODULE$;
                }
                Nil$ commonPrefixes = nil$;
                List filteredFiles = (List)files.filterNot((Function1)new Serializable(this, (List)commonPrefixes){
                    public static final long serialVersionUID = 0L;
                    private final List commonPrefixes$1;

                    public final boolean apply(Content f) {
                        return this.commonPrefixes$1.exists((Function1)new Serializable(this, f){
                            public static final long serialVersionUID = 0L;
                            private final Content f$1;

                            public final boolean apply(String p) {
                                return this.f$1.key().startsWith(p);
                            }
                            {
                                this.f$1 = f$1;
                            }
                        });
                    }
                    {
                        this.commonPrefixes$1 = commonPrefixes$1;
                    }
                });
                int count = BoxesRunTime.unboxToInt((Object)maxkeys.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return Integer.MAX_VALUE;
                    }
                }));
                List result = (List)filteredFiles.sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Content x$6) {
                        return x$6.key();
                    }
                }, (Ordering)Ordering.String$.MODULE$);
                return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)result.take(count), result.size() > count);
            }
            throw new MatchError(option);
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        better.files.File bucket = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, name})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = bucket.exists(bucket.exists$default$1()) ? BoxedUnit.UNIT : bucket.createDirectory(bucket.createDirectory$default$1());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating bucket ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, ObjectMetadata objectMetadata) {
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            BoxedUnit boxedUnit;
            boolean x$10;
            boolean x$9 = true;
            boolean x$11 = x$10 = file.createIfNotExists$default$1();
            boolean x$12 = x$9;
            Seq x$13 = file.createIfNotExists$default$3(x$11, x$12);
            Seq x$14 = file.createIfNotExists$default$4(x$11, x$12);
            file.createIfNotExists(x$11, x$12, x$13, x$14);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writing file for s3://", "/", " to ", "/", "/", ", bytes = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key, this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key, BoxesRunTime.boxToInteger((int)data.length)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
            this.metadataStore().put(bucket, key, objectMetadata);
            return;
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reading object for s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            if (file.exists(file.exists$default$1())) {
                if (file.isDirectory(file.isDirectory$default$1())) {
                    throw new NoSuchKeyException(bucket, key);
                }
                Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
                return new GetObjectData(file.byteArray(), meta);
            }
            throw new NoSuchKeyException(bucket, key);
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key) {
        String id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            BoxedUnit boxedUnit;
            boolean x$16;
            better.files.File qual$1 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/.keep"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key, id})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            boolean x$15 = true;
            boolean x$17 = x$16 = qual$1.createIfNotExists$default$1();
            boolean x$18 = x$15;
            Seq x$19 = qual$1.createIfNotExists$default$3(x$17, x$18);
            Seq x$20 = qual$1.createIfNotExists$default$4(x$17, x$18);
            qual$1.createIfNotExists(x$17, x$18, x$19, x$20);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new InitiateMultipartUploadResult(bucket, key, id);
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            BoxedUnit boxedUnit;
            better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key, uploadId, BoxesRunTime.boxToInteger((int)partNumber)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uploading multipart chunk ", " for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
            return;
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            BoxedUnit boxedUnit;
            boolean x$22;
            List files = (List)request.parts().map((Function1)new Serializable(this, bucket, key, uploadId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileProvider $outer;
                private final String bucket$1;
                private final String key$1;
                private final String uploadId$1;

                public final better.files.File apply(CompleteMultipartUploadPart part) {
                    return File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.io$findify$s3mock$provider$FileProvider$$dir, this.bucket$1, this.key$1, this.uploadId$1, BoxesRunTime.boxToInteger((int)part.partNumber())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.bucket$1 = bucket$1;
                    this.key$1 = key$1;
                    this.uploadId$1 = uploadId$1;
                }
            }, List$.MODULE$.canBuildFrom());
            List parts = (List)files.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(better.files.File f) {
                    return f.byteArray();
                }
            }, List$.MODULE$.canBuildFrom());
            better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            boolean x$21 = true;
            boolean x$23 = x$22 = file.createIfNotExists$default$1();
            boolean x$24 = x$21;
            Seq x$25 = file.createIfNotExists$default$3(x$23, x$24);
            Seq x$26 = file.createIfNotExists$default$4(x$23, x$24);
            file.createIfNotExists(x$23, x$24, x$25, x$26);
            byte[] data = (byte[])parts.fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(byte[] x$7, byte[] x$8) {
                    return (byte[])Predef$.MODULE$.byteArrayOps(x$7).$plus$plus((GenTraversableOnce)Predef$.MODULE$.byteArrayOps(x$8), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                }
            });
            Iterator x$27 = Predef$.MODULE$.byteArrayOps(data).toIterator();
            Seq x$28 = file.writeBytes$default$2(x$27);
            file.writeBytes(x$27, x$28);
            better.files.File qual$2 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            boolean x$29 = qual$2.delete$default$1();
            qual$2.delete(x$29);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completed multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new CompleteMultipartUploadResult(bucket, key, file.md5());
        }
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        better.files.File sourceBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, sourceBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File destBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, destBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (sourceBucketFile.exists(sourceBucketFile.exists$default$1())) {
            if (destBucketFile.exists(destBucketFile.exists$default$1())) {
                BoxedUnit boxedUnit;
                boolean x$31;
                better.files.File sourceFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, sourceBucket, sourceKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                better.files.File destFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, destBucket, destKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                boolean x$30 = true;
                boolean x$32 = x$31 = destFile.createIfNotExists$default$1();
                boolean x$33 = x$30;
                Seq x$34 = destFile.createIfNotExists$default$3(x$32, x$33);
                Seq x$35 = destFile.createIfNotExists$default$4(x$32, x$33);
                destFile.createIfNotExists(x$32, x$33, x$34, x$35);
                better.files.File x$36 = destFile;
                boolean x$37 = true;
                Seq x$38 = sourceFile.copyTo$default$3(x$36, x$37);
                sourceFile.copyTo(x$36, x$37, x$38);
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied s3://", "/", " to s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceBucket, sourceKey, destBucket, destKey})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Option sourceMeta = newMeta.orElse((Function0)new Serializable(this, sourceBucket, sourceKey){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileProvider $outer;
                    private final String sourceBucket$1;
                    private final String sourceKey$1;

                    public final Option<ObjectMetadata> apply() {
                        return this.$outer.metadataStore().get(this.sourceBucket$1, this.sourceKey$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sourceBucket$1 = sourceBucket$1;
                        this.sourceKey$1 = sourceKey$1;
                    }
                });
                sourceMeta.foreach((Function1)new Serializable(this, destBucket, destKey){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileProvider $outer;
                    private final String destBucket$1;
                    private final String destKey$1;

                    public final void apply(ObjectMetadata meta) {
                        this.$outer.metadataStore().put(this.destBucket$1, this.destKey$1, meta);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.destBucket$1 = destBucket$1;
                        this.destKey$1 = destKey$1;
                    }
                });
                return new CopyObjectResult(DateTime$.MODULE$.apply(sourceFile.lastModifiedTime(sourceFile.lastModifiedTime$default$1()).toEpochMilli()), destFile.md5());
            }
            throw new NoSuchBucketException(destBucket);
        }
        throw new NoSuchBucketException(sourceBucket);
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    @Override
    public void deleteObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting object s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (file.exists(file.exists$default$1())) {
            if (!file.isDirectory(file.isDirectory$default$1())) {
                file.delete(file.delete$default$1());
                this.metadataStore().delete(bucket, key);
            }
            return;
        }
        throw new NoSuchKeyException(bucket, key);
    }

    @Override
    public void deleteBucket(String bucket) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.io$findify$s3mock$provider$FileProvider$$dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting bucket s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (bucketFile.exists(bucketFile.exists$default$1())) {
            bucketFile.delete(bucketFile.delete$default$1());
            this.metadataStore().remove(bucket);
            return;
        }
        throw new NoSuchBucketException(bucket);
    }

    public String io$findify$s3mock$provider$FileProvider$$fromOs(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public final Option io$findify$s3mock$provider$FileProvider$$commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            default: {
                none$ = new Some((Object)new StringBuilder().append((Object)p).append((Object)dir.substring(p.length(), n)).append((Object)d).toString());
                break;
            }
            case -1: {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public FileProvider(String dir) {
        this.io$findify$s3mock$provider$FileProvider$$dir = dir;
        Provider$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.workDir = File$.MODULE$.apply(dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = this.workDir().exists(this.workDir().exists$default$1()) ? BoxedUnit.UNIT : this.workDir().createDirectories(this.workDir().createDirectories$default$1());
        this.meta = new MapMetadataStore(dir);
    }
}

