/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.route;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.HashSet;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MetadataUtil$
implements LazyLogging {
    public static final MetadataUtil$ MODULE$;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetadataUtil$();
    }

    private Logger logger$lzycompute() {
        MetadataUtil$ metadataUtil$ = this;
        synchronized (metadataUtil$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public ObjectMetadata populateObjectMetadata(HttpRequest request) {
        void var2_2;
        ObjectMetadata metadata = new ObjectMetadata();
        HashSet<String> ignoredHeaders = new HashSet<String>();
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
        ignoredHeaders.add("X-Amz-Cf-Id");
        ignoredHeaders.add("Connection");
        Iterable headers = request.getHeaders();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(headers).asScala()).foreach((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final ObjectMetadata metadata$1;

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(HttpHeader header) {
                String key = header.name();
                if (StringUtils.beginsWithIgnoreCase((String)key, (String)"x-amz-meta-")) {
                    key = key.substring("x-amz-meta-".length());
                    this.metadata$1.addUserMetadata(key, header.value());
                    return;
                } else {
                    if (key.equalsIgnoreCase("Last-Modified")) {
                        this.metadata$1.setHeader(key, (Object)ServiceUtils.parseRfc822Date((String)header.value()));
                        return;
                    }
                    if (key.equalsIgnoreCase("Content-Length")) {
                        this.metadata$1.setHeader(key, (Object)BoxesRunTime.boxToLong((long)Long.parseLong(header.value())));
                        return;
                    }
                    if (key.equalsIgnoreCase("ETag")) {
                        this.metadata$1.setHeader(key, (Object)ServiceUtils.removeQuotes((String)header.value()));
                        return;
                    } else if (key.equalsIgnoreCase("Expires")) {
                        this.metadata$1.setHttpExpiresDate(DateUtils.parseRFC822Date((String)header.value()));
                        return;
                    } else if (key.equalsIgnoreCase("x-amz-mp-parts-count")) {
                        this.metadata$1.setHeader(key, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(header.value())).toInt()));
                        return;
                    } else {
                        this.metadata$1.setHeader(key, (Object)header.value());
                    }
                }
                return;
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (MetadataUtil$.MODULE$.logger().underlying().isWarnEnabled()) {
                        MetadataUtil$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Unable to parse last modified date: ").append((Object)header.value()).toString(), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
                catch (NumberFormatException numberFormatException) {
                    throw new AmazonClientException(new StringBuilder().append((Object)"Unable to parse content length. Header 'Content-Length' has corrupted data").append((Object)numberFormatException.getMessage()).toString(), (Throwable)numberFormatException);
                }
                catch (Exception exception) {
                    BoxedUnit boxedUnit;
                    if (MetadataUtil$.MODULE$.logger().underlying().isWarnEnabled()) {
                        MetadataUtil$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Unable to parse http expiration date: ").append((Object)header.value()).toString(), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
                catch (NumberFormatException numberFormatException) {
                    throw new AmazonClientException(new StringBuilder().append((Object)"Unable to parse part count. Header x-amz-mp-parts-count has corrupted data").append((Object)numberFormatException.getMessage()).toString(), (Throwable)numberFormatException);
                }
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        if (metadata.getContentType() == null) {
            metadata.setContentType(request.entity().getContentType().toString());
        }
        return var2_2;
    }

    private MetadataUtil$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

