/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime$;
import better.files.File;
import better.files.File$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.MapMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.Serializable;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001-\u0011ABR5mKB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011A\u0014xN^5eKJT!!\u0002\u0004\u0002\rM\u001cTn\\2l\u0015\t9\u0001\"A\u0004gS:$\u0017NZ=\u000b\u0003%\t!![8\u0004\u0001M!\u0001\u0001\u0004\n\u0017!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\t!J|g/\u001b3feB\u0011qCH\u0007\u00021)\u0011\u0011DG\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00037q\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002;\u0005\u00191m\\7\n\u0005}A\"a\u0003'bufdunZ4j]\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0004I&\u0014\bCA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&\u001d5\taE\u0003\u0002(\u0015\u00051AH]8pizJ!!\u000b\b\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S9AQA\f\u0001\u0005\u0002=\na\u0001P5oSRtDC\u0001\u00192!\t\u0019\u0002\u0001C\u0003\"[\u0001\u0007!\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\u000f]|'o\u001b#jeV\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u0005)a-\u001b7fg*\t!(\u0001\u0004cKR$XM]\u0005\u0003y]\u0012AAR5mK\"1a\b\u0001Q\u0001\nU\n\u0001b^8sW\u0012K'\u000f\t\u0005\u0006\u0001\u0002!\t%Q\u0001\u000e[\u0016$\u0018\rZ1uCN#xN]3\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0002\u0002\u00115,G/\u00193bi\u0006L!a\u0012#\u0003\u001b5+G/\u00193bi\u0006\u001cFo\u001c:f\u0011\u0015I\u0005\u0001\"\u0011K\u0003-a\u0017n\u001d;Ck\u000e\\W\r^:\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0003\u0002\u0011I,7\u000f]8og\u0016L!\u0001U'\u0003!1K7\u000f^!mY6K()^2lKR\u001c\b\"\u0002*\u0001\t\u0003\u001a\u0016A\u00037jgR\u0014UoY6fiR!AkV-_!\taU+\u0003\u0002W\u001b\nQA*[:u\u0005V\u001c7.\u001a;\t\u000ba\u000b\u0006\u0019\u0001\u0012\u0002\r\t,8m[3u\u0011\u0015Q\u0016\u000b1\u0001\\\u0003\u0019\u0001(/\u001a4jqB\u0019Q\u0002\u0018\u0012\n\u0005us!AB(qi&|g\u000eC\u0003`#\u0002\u00071,A\u0005eK2LW.\u001b;fe\")\u0011\r\u0001C!E\u0006a1M]3bi\u0016\u0014UoY6fiR\u00191M\u001a5\u0011\u00051#\u0017BA3N\u00051\u0019%/Z1uK\n+8m[3u\u0011\u00159\u0007\r1\u0001#\u0003\u0011q\u0017-\\3\t\u000b%\u0004\u0007\u0019\u00016\u0002\u0019\t,8m[3u\u0007>tg-[4\u0011\u0005-tW\"\u00017\u000b\u00055$\u0011a\u0002:fcV,7\u000f^\u0005\u0003_2\u0014\u0011d\u0011:fCR,')^2lKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")\u0011\u000f\u0001C!e\u0006I\u0001/\u001e;PE*,7\r\u001e\u000b\u0007gZ<\u00180a\u0001\u0011\u00055!\u0018BA;\u000f\u0005\u0011)f.\u001b;\t\u000ba\u0003\b\u0019\u0001\u0012\t\u000ba\u0004\b\u0019\u0001\u0012\u0002\u0007-,\u0017\u0010C\u0003{a\u0002\u000710\u0001\u0003eCR\f\u0007cA\u0007}}&\u0011QP\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001b}L1!!\u0001\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0013\u0005\u0015\u0001\u000f%AA\u0002\u0005\u001d\u0011AD8cU\u0016\u001cG/T3uC\u0012\fG/\u0019\t\u0005\u001bq\u000bI\u0001\u0005\u0003\u0002\f\u0005uQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u000b5|G-\u001a7\u000b\t\u0005M\u0011QC\u0001\u0003gNRA!a\u0006\u0002\u001a\u0005A1/\u001a:wS\u000e,7OC\u0002\u0002\u001cq\t\u0011\"Y7bu>t\u0017m^:\n\t\u0005}\u0011Q\u0002\u0002\u000f\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\t\u0011bZ3u\u001f\nTWm\u0019;\u0015\r\u0005\u001d\u0012QFA\u0018!\r\u0019\u0012\u0011F\u0005\u0004\u0003W\u0011!!D$fi>\u0013'.Z2u\t\u0006$\u0018\r\u0003\u0004Y\u0003C\u0001\rA\t\u0005\u0007q\u0006\u0005\u0002\u0019\u0001\u0012\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u00059\u0002/\u001e;PE*,7\r^'vYRL\u0007/\u0019:u'R\f'\u000f\u001e\u000b\u0007\u0003o\ti$a\u0010\u0011\u00071\u000bI$C\u0002\u0002<5\u0013Q$\u00138ji&\fG/Z'vYRL\u0007/\u0019:u+Bdw.\u00193SKN,H\u000e\u001e\u0005\u00071\u0006E\u0002\u0019\u0001\u0012\t\ra\f\t\u00041\u0001#\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000b\na\u0003];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1siB\u000b'\u000f\u001e\u000b\fg\u0006\u001d\u0013\u0011JA&\u0003+\nI\u0006\u0003\u0004Y\u0003\u0003\u0002\rA\t\u0005\u0007q\u0006\u0005\u0003\u0019\u0001\u0012\t\u0011\u00055\u0013\u0011\ta\u0001\u0003\u001f\n!\u0002]1si:+XNY3s!\ri\u0011\u0011K\u0005\u0004\u0003'r!aA%oi\"9\u0011qKA!\u0001\u0004\u0011\u0013\u0001C;qY>\fG-\u00133\t\ri\f\t\u00051\u0001|\u0011\u001d\ti\u0006\u0001C!\u0003?\n!\u0004];u\u001f\nTWm\u0019;Nk2$\u0018\u000e]1si\u000e{W\u000e\u001d7fi\u0016$\"\"!\u0019\u0002h\u0005%\u00141NA7!\ra\u00151M\u0005\u0004\u0003Kj%!H\"p[BdW\r^3Nk2$\u0018\u000e]1siV\u0003Hn\\1e%\u0016\u001cX\u000f\u001c;\t\ra\u000bY\u00061\u0001#\u0011\u0019A\u00181\fa\u0001E!9\u0011qKA.\u0001\u0004\u0011\u0003bB7\u0002\\\u0001\u0007\u0011q\u000e\t\u0004W\u0006E\u0014bAA:Y\n92i\\7qY\u0016$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\r\u001a\u0005\b\u0003o\u0002A\u0011IA=\u0003)\u0019w\u000e]=PE*,7\r\u001e\u000b\r\u0003w\n\t)!\"\u0002\n\u00065\u0015\u0011\u0013\t\u0004\u0019\u0006u\u0014bAA@\u001b\n\u00012i\u001c9z\u001f\nTWm\u0019;SKN,H\u000e\u001e\u0005\b\u0003\u0007\u000b)\b1\u0001#\u00031\u0019x.\u001e:dK\n+8m[3u\u0011\u001d\t9)!\u001eA\u0002\t\n\u0011b]8ve\u000e,7*Z=\t\u000f\u0005-\u0015Q\u000fa\u0001E\u0005QA-Z:u\u0005V\u001c7.\u001a;\t\u000f\u0005=\u0015Q\u000fa\u0001E\u00059A-Z:u\u0017\u0016L\bBCAJ\u0003k\u0002\n\u00111\u0001\u0002\b\u00059a.Z<NKR\f\u0007bBAL\u0001\u0011\u0005\u0013\u0011T\u0001\rI\u0016dW\r^3PE*,7\r\u001e\u000b\u0006g\u0006m\u0015Q\u0014\u0005\u00071\u0006U\u0005\u0019\u0001\u0012\t\ra\f)\n1\u0001#\u0011\u001d\t\t\u000b\u0001C!\u0003G\u000bA\u0002Z3mKR,')^2lKR$2a]AS\u0011\u0019A\u0016q\u0014a\u0001E!I\u0011\u0011\u0016\u0001\u0012\u0002\u0013\u0005\u00131V\u0001\u0014aV$xJ\u00196fGR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[SC!a\u0002\u00020.\u0012\u0011\u0011\u0017\t\u0005\u0003g\u000bi,\u0004\u0002\u00026*!\u0011qWA]\u0003%)hn\u00195fG.,GMC\u0002\u0002<:\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty,!.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002D\u0002\t\n\u0011\"\u0011\u0002,\u0006!2m\u001c9z\u001f\nTWm\u0019;%I\u00164\u0017-\u001e7uIU\u0002")
public class FileProvider
implements Provider,
LazyLogging {
    private final String dir;
    private final File workDir;
    private volatile Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileProvider fileProvider = this;
        synchronized (fileProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public File workDir() {
        return this.workDir;
    }

    @Override
    public MetadataStore metadataStore() {
        return new MapMetadataStore(this.dir);
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        List buckets = File$.MODULE$.apply(this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).list().map((Function1 & Serializable & scala.Serializable)f -> new Bucket(f.name(), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()))).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing buckets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buckets.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets);
    }

    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter) {
        Nil$ nil$;
        BoxedUnit boxedUnit;
        String prefixNoLeadingSlash = (String)new StringOps(Predef$.MODULE$.augmentString((String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$2(BoxesRunTime.unboxToChar((Object)x$2))));
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        String bucketFileString = bucketFile.toString();
        Iterator bucketFiles = bucketFile.listRecursively(bucketFile.listRecursively$default$1()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$3(prefixNoLeadingSlash, bucketFileString, f)));
        List files = bucketFiles.map((Function1 & Serializable & scala.Serializable)f -> new Content((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(f.toString())).drop(bucketFileString.length() + 1))).dropWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$6(BoxesRunTime.unboxToChar((Object)x$4)))), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()), "0", f.size(f.size$default$1()), "STANDARD")).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing bucket contents: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{files.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.key(), List$.MODULE$.canBuildFrom())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<String> option = delimiter;
        if (option instanceof Some) {
            Some some = (Some)option;
            String del = (String)some.value();
            nil$ = (List)((SeqLike)files.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(FileProvider.commonPrefix$1(f.key(), prefixNoLeadingSlash, del)), List$.MODULE$.canBuildFrom())).distinct();
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ commonPrefixes = nil$;
        List filteredFiles = (List)files.filterNot(arg_0 -> FileProvider.$anonfun$listBucket$9$adapted((List)commonPrefixes, arg_0));
        return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)filteredFiles);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        File bucket = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, name})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = !bucket.exists(bucket.exists$default$1()) ? bucket.createDirectory(bucket.createDirectory$default$1()) : BoxedUnit.UNIT;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating bucket ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, Option<ObjectMetadata> objectMetadata) {
        BoxedUnit boxedUnit;
        boolean x$9;
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        boolean x$8 = true;
        boolean x$10 = x$9 = file.createIfNotExists$default$1();
        boolean x$11 = x$8;
        Seq x$12 = file.createIfNotExists$default$3(x$10, x$11);
        Seq x$13 = file.createIfNotExists$default$4(x$10, x$11);
        file.createIfNotExists(x$10, x$11, x$12, x$13);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writing file for s3://", "/", " to ", "/", "/", ", bytes = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key, this.dir, bucket, key, BoxesRunTime.boxToInteger((int)data.length)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
        objectMetadata.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            FileProvider.$anonfun$putObject$1(this, bucket, key, meta);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<ObjectMetadata> putObject$default$4() {
        return None$.MODULE$;
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reading object for s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        if (!file.exists(file.exists$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
        return new GetObjectData(file.byteArray(), meta);
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key) {
        BoxedUnit boxedUnit;
        boolean x$15;
        String id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        File qual$1 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/.keep"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key, id})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$14 = true;
        boolean x$16 = x$15 = qual$1.createIfNotExists$default$1();
        boolean x$17 = x$14;
        Seq x$18 = qual$1.createIfNotExists$default$3(x$16, x$17);
        Seq x$19 = qual$1.createIfNotExists$default$4(x$16, x$17);
        qual$1.createIfNotExists(x$16, x$17, x$18, x$19);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new InitiateMultipartUploadResult(bucket, key, id);
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        BoxedUnit boxedUnit;
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key, uploadId, BoxesRunTime.boxToInteger((int)partNumber)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uploading multipart chunk ", " for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        BoxedUnit boxedUnit;
        boolean x$21;
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        List files = (List)request.parts().map((Function1 & Serializable & scala.Serializable)part -> File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.dir, bucket, key, uploadId, BoxesRunTime.boxToInteger((int)part.partNumber())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), List$.MODULE$.canBuildFrom());
        List parts = (List)files.map((Function1 & Serializable & scala.Serializable)f -> f.byteArray(), List$.MODULE$.canBuildFrom());
        File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$20 = true;
        boolean x$22 = x$21 = file.createIfNotExists$default$1();
        boolean x$23 = x$20;
        Seq x$24 = file.createIfNotExists$default$3(x$22, x$23);
        Seq x$25 = file.createIfNotExists$default$4(x$22, x$23);
        file.createIfNotExists(x$22, x$23, x$24, x$25);
        byte[] data = (byte[])parts.fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
        Iterator x$26 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).toIterator();
        Seq x$27 = file.writeBytes$default$2(x$26);
        file.writeBytes(x$26, x$27);
        File qual$2 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$28 = qual$2.delete$default$1();
        qual$2.delete(x$28);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completed multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CompleteMultipartUploadResult(bucket, key, file.md5());
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        BoxedUnit boxedUnit;
        boolean x$30;
        File sourceBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, sourceBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        File destBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, destBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!sourceBucketFile.exists(sourceBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(sourceBucket);
        }
        if (!destBucketFile.exists(destBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(destBucket);
        }
        File sourceFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, sourceBucket, sourceKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        File destFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, destBucket, destKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$29 = true;
        boolean x$31 = x$30 = destFile.createIfNotExists$default$1();
        boolean x$32 = x$29;
        Seq x$33 = destFile.createIfNotExists$default$3(x$31, x$32);
        Seq x$34 = destFile.createIfNotExists$default$4(x$31, x$32);
        destFile.createIfNotExists(x$31, x$32, x$33, x$34);
        File x$35 = destFile;
        boolean x$36 = true;
        Seq x$37 = sourceFile.copyTo$default$3(x$35, x$36);
        sourceFile.copyTo(x$35, x$36, x$37);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied s3://", "/", " to s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceBucket, sourceKey, destBucket, destKey})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option sourceMeta = newMeta.orElse((Function0 & Serializable & scala.Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
        sourceMeta.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            FileProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
            return BoxedUnit.UNIT;
        });
        return new CopyObjectResult(DateTime$.MODULE$.apply(sourceFile.lastModifiedTime(sourceFile.lastModifiedTime$default$1()).toEpochMilli()), destFile.md5());
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    @Override
    public void deleteObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting object s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!file.exists(file.exists$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        file.delete(file.delete$default$1());
        this.metadataStore().delete(bucket, key);
    }

    @Override
    public void deleteBucket(String bucket) {
        BoxedUnit boxedUnit;
        File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting bucket s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        bucketFile.delete(bucketFile.delete$default$1());
        this.metadataStore().remove(bucket);
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)(p + dir.substring(p.length(), n) + d));
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$2(char x$2) {
        return x$2 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$4(char x$3) {
        return x$3 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$3(String prefixNoLeadingSlash$1, String bucketFileString$1, File f) {
        String fString = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(f.toString())).drop(bucketFileString$1.length()))).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$4(BoxesRunTime.unboxToChar((Object)x$3))));
        return fString.startsWith(prefixNoLeadingSlash$1) && !f.isDirectory(f.isDirectory$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$6(char x$4) {
        return x$4 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$10(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$putObject$1(FileProvider $this, String bucket$1, String key$1, ObjectMetadata meta) {
        $this.metadataStore().put(bucket$1, key$1, meta);
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(FileProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public FileProvider(String dir) {
        this.dir = dir;
        LazyLogging.$init$((LazyLogging)this);
        this.workDir = File$.MODULE$.apply(dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = !this.workDir().exists(this.workDir().exists$default$1()) ? this.workDir().createDirectories(this.workDir().createDirectories$default$1()) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$listBucket$9$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$10(f, p))));
    }
}

