/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime;
import akka.http.scaladsl.model.DateTime$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.InMemoryProvider$BucketContents$;
import io.findify.s3mock.provider.InMemoryProvider$KeyContents$;
import io.findify.s3mock.provider.InMemoryProvider$MultipartChunk$;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.InMemoryMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.TreeSet;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\reg\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00138NK6|'/\u001f)s_ZLG-\u001a:\u000b\u0005\r!\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u00151\u0011AB:4[>\u001c7N\u0003\u0002\b\u0011\u00059a-\u001b8eS\u001aL(\"A\u0005\u0002\u0005%|7\u0001A\n\u0005\u00011\u0011b\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0001\u0002\u0015:pm&$WM\u001d\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005\u0019\u0003CA\n\u0001\u0011\u001d)\u0003A1A\u0005\n\u0019\nq!\u001c3Ti>\u0014X-F\u0001(!\tA3&D\u0001*\u0015\tQ#!\u0001\u0005nKR\fG-\u0019;b\u0013\ta\u0013FA\u000bJ]6+Wn\u001c:z\u001b\u0016$\u0018\rZ1uCN#xN]3\t\r9\u0002\u0001\u0015!\u0003(\u0003!iGm\u0015;pe\u0016\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%I!M\u0001\u0010EV\u001c7.\u001a;ECR\f7\u000b^8sKV\t!\u0007\u0005\u00034qi*U\"\u0001\u001b\u000b\u0005U2\u0014AC2p]\u000e,(O]3oi*\u0011qGD\u0001\u000bG>dG.Z2uS>t\u0017BA\u001d5\u0005\u001d!&/[3NCB\u0004\"a\u000f\"\u000f\u0005q\u0002\u0005CA\u001f\u000f\u001b\u0005q$BA \u000b\u0003\u0019a$o\\8u}%\u0011\u0011ID\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002B\u001dA\u0011aiR\u0007\u0002\u0001\u0019!\u0001\n\u0001#J\u00059\u0011UoY6fi\u000e{g\u000e^3oiN\u001cBa\u0012\u0007K\u001bB\u0011QbS\u0005\u0003\u0019:\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u000e\u001d&\u0011qJ\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t#\u001e\u0013)\u001a!C\u0001%\u0006a1M]3bi&|g\u000eV5nKV\t1\u000b\u0005\u0002U;6\tQK\u0003\u0002W/\u0006)Qn\u001c3fY*\u0011\u0001,W\u0001\tg\u000e\fG.\u00193tY*\u0011!lW\u0001\u0005QR$\bOC\u0001]\u0003\u0011\t7n[1\n\u0005y+&\u0001\u0003#bi\u0016$\u0016.\\3\t\u0011\u0001<%\u0011#Q\u0001\nM\u000bQb\u0019:fCRLwN\u001c+j[\u0016\u0004\u0003\u0002\u00032H\u0005+\u0007I\u0011A2\u0002\u0019-,\u0017p]%o\u0005V\u001c7.\u001a;\u0016\u0003\u0011\u0004B!\u001a5;U6\taM\u0003\u0002hm\u00059Q.\u001e;bE2,\u0017BA5g\u0005\ri\u0015\r\u001d\t\u0003\r.4A\u0001\u001c\u0001E[\nY1*Z=D_:$XM\u001c;t'\u0011YGBS'\t\u0011=\\'Q3A\u0005\u0002I\u000bA\u0003\\1ti6{G-\u001b4jG\u0006$\u0018n\u001c8US6,\u0007\u0002C9l\u0005#\u0005\u000b\u0011B*\u0002+1\f7\u000f^'pI&4\u0017nY1uS>tG+[7fA!A1o\u001bBK\u0002\u0013\u0005A/\u0001\u0003eCR\fW#A;\u0011\u000751\b0\u0003\u0002x\u001d\t)\u0011I\u001d:bsB\u0011Q\"_\u0005\u0003u:\u0011AAQ=uK\"AAp\u001bB\tB\u0003%Q/A\u0003eCR\f\u0007\u0005C\u0003\"W\u0012\u0005a\u0010\u0006\u0003k\u007f\u0006\u0005\u0001\"B8~\u0001\u0004\u0019\u0006\"B:~\u0001\u0004)\b\"CA\u0003W\u0006\u0005I\u0011AA\u0004\u0003\u0011\u0019w\u000e]=\u0015\u000b)\fI!a\u0003\t\u0011=\f\u0019\u0001%AA\u0002MC\u0001b]A\u0002!\u0003\u0005\r!\u001e\u0005\n\u0003\u001fY\u0017\u0013!C\u0001\u0003#\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014)\u001a1+!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\u000bl#\u0003%\t!a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0006\u0016\u0004k\u0006U\u0001\"CA\u0019W\u0006\u0005I\u0011IA\u001a\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006L1aQA\u001d\u0011%\t)e[A\u0001\n\u0003\t9%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002JA\u0019Q\"a\u0013\n\u0007\u00055cBA\u0002J]RD\u0011\"!\u0015l\u0003\u0003%\t!a\u0015\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QKA.!\ri\u0011qK\u0005\u0004\u00033r!aA!os\"Q\u0011QLA(\u0003\u0003\u0005\r!!\u0013\u0002\u0007a$\u0013\u0007C\u0005\u0002b-\f\t\u0011\"\u0011\u0002d\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002fA1\u0011qMA5\u0003+j\u0011AN\u0005\u0004\u0003W2$\u0001C%uKJ\fGo\u001c:\t\u0013\u0005=4.!A\u0005\u0002\u0005E\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0014\u0011\u0010\t\u0004\u001b\u0005U\u0014bAA<\u001d\t9!i\\8mK\u0006t\u0007BCA/\u0003[\n\t\u00111\u0001\u0002V!I\u0011QP6\u0002\u0002\u0013\u0005\u0013qP\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\n\u0005\n\u0003\u0007[\u0017\u0011!C!\u0003\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003kA\u0011\"!#l\u0003\u0003%\t%a#\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019(!$\t\u0015\u0005u\u0013qQA\u0001\u0002\u0004\t)\u0006C\u0005\u0002\u0012\u001e\u0013\t\u0012)A\u0005I\u0006i1.Z=t\u0013:\u0014UoY6fi\u0002Ba!I$\u0005\u0002\u0005UE#B#\u0002\u0018\u0006e\u0005BB)\u0002\u0014\u0002\u00071\u000b\u0003\u0004c\u0003'\u0003\r\u0001\u001a\u0005\n\u0003\u000b9\u0015\u0011!C\u0001\u0003;#R!RAP\u0003CC\u0001\"UAN!\u0003\u0005\ra\u0015\u0005\tE\u0006m\u0005\u0013!a\u0001I\"I\u0011qB$\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\n\u0003S9\u0015\u0013!C\u0001\u0003O+\"!!++\u0007\u0011\f)\u0002C\u0005\u00022\u001d\u000b\t\u0011\"\u0011\u00024!I\u0011QI$\u0002\u0002\u0013\u0005\u0011q\t\u0005\n\u0003#:\u0015\u0011!C\u0001\u0003c#B!!\u0016\u00024\"Q\u0011QLAX\u0003\u0003\u0005\r!!\u0013\t\u0013\u0005\u0005t)!A\u0005B\u0005\r\u0004\"CA8\u000f\u0006\u0005I\u0011AA])\u0011\t\u0019(a/\t\u0015\u0005u\u0013qWA\u0001\u0002\u0004\t)\u0006C\u0005\u0002~\u001d\u000b\t\u0011\"\u0011\u0002\u0000!I\u00111Q$\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0003\u0013;\u0015\u0011!C!\u0003\u0007$B!a\u001d\u0002F\"Q\u0011QLAa\u0003\u0003\u0005\r!!\u0016\t\u000f\u0005%\u0007\u0001)A\u0005e\u0005\u0001\"-^2lKR$\u0015\r^1Ti>\u0014X\r\t\u0005\n\u0003\u001b\u0004!\u0019!C\u0005\u0003\u001f\f!#\\;mi&\u0004\u0018M\u001d;UK6\u00048\u000b^8sKV\u0011\u0011\u0011\u001b\t\u0006gaR\u00141\u001b\t\u0006K\u0006U\u0017\u0011\\\u0005\u0004\u0003/4'!C*peR,GmU3u!\r1\u00151\u001c\u0004\u0007\u0003;\u0004A)a8\u0003\u001d5+H\u000e^5qCJ$8\t[;oWN9\u00111\u001c\u0007\u0002b*k\u0005CBAr\u0003[\fIN\u0004\u0003\u0002f\u0006%hbA\u001f\u0002h&\tq\"C\u0002\u0002l:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002p\u0006E(aB(sI\u0016\u0014X\r\u001a\u0006\u0004\u0003Wt\u0001bCA{\u00037\u0014)\u001a!C\u0001\u0003\u000f\na\u0001]1si:{\u0007bCA}\u00037\u0014\t\u0012)A\u0005\u0003\u0013\nq\u0001]1si:{\u0007\u0005C\u0005t\u00037\u0014)\u001a!C\u0001i\"IA0a7\u0003\u0012\u0003\u0006I!\u001e\u0005\bC\u0005mG\u0011\u0001B\u0001)\u0019\tINa\u0001\u0003\u0006!A\u0011Q_A\u0000\u0001\u0004\tI\u0005\u0003\u0004t\u0003\u007f\u0004\r!\u001e\u0005\t\u0005\u0013\tY\u000e\"\u0011\u0003\f\u000591m\\7qCJ,G\u0003BA%\u0005\u001bA\u0001Ba\u0004\u0003\b\u0001\u0007\u0011\u0011\\\u0001\u0005i\"\fG\u000f\u0003\u0006\u0002\u0006\u0005m\u0017\u0011!C\u0001\u0005'!b!!7\u0003\u0016\t]\u0001BCA{\u0005#\u0001\n\u00111\u0001\u0002J!A1O!\u0005\u0011\u0002\u0003\u0007Q\u000f\u0003\u0006\u0002\u0010\u0005m\u0017\u0013!C\u0001\u00057)\"A!\b+\t\u0005%\u0013Q\u0003\u0005\u000b\u0003S\tY.%A\u0005\u0002\u0005-\u0002BCA\u0019\u00037\f\t\u0011\"\u0011\u00024!Q\u0011QIAn\u0003\u0003%\t!a\u0012\t\u0015\u0005E\u00131\\A\u0001\n\u0003\u00119\u0003\u0006\u0003\u0002V\t%\u0002BCA/\u0005K\t\t\u00111\u0001\u0002J!Q\u0011\u0011MAn\u0003\u0003%\t%a\u0019\t\u0015\u0005=\u00141\\A\u0001\n\u0003\u0011y\u0003\u0006\u0003\u0002t\tE\u0002BCA/\u0005[\t\t\u00111\u0001\u0002V!Q\u0011QPAn\u0003\u0003%\t%a \t\u0015\u0005\r\u00151\\A\u0001\n\u0003\n)\t\u0003\u0006\u0002\n\u0006m\u0017\u0011!C!\u0005s!B!a\u001d\u0003<!Q\u0011Q\fB\u001c\u0003\u0003\u0005\r!!\u0016\t\u0011\t}\u0002\u0001)A\u0005\u0003#\f1#\\;mi&\u0004\u0018M\u001d;UK6\u00048\u000b^8sK\u0002:\u0011Ba\u0011\u0001\u0003\u0003EIA!\u0012\u0002\u001d\t+8m[3u\u0007>tG/\u001a8ugB\u0019aIa\u0012\u0007\u0011!\u0003\u0011\u0011!E\u0005\u0005\u0013\u001aRAa\u0012\u0003L5\u0003rA!\u0014\u0003TM#W)\u0004\u0002\u0003P)\u0019!\u0011\u000b\b\u0002\u000fI,h\u000e^5nK&!!Q\u000bB(\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bC\t\u001dC\u0011\u0001B-)\t\u0011)\u0005\u0003\u0006\u0002\u0004\n\u001d\u0013\u0011!C#\u0003\u000bC!Ba\u0018\u0003H\u0005\u0005I\u0011\u0011B1\u0003\u0015\t\u0007\u000f\u001d7z)\u0015)%1\rB3\u0011\u0019\t&Q\fa\u0001'\"1!M!\u0018A\u0002\u0011D!B!\u001b\u0003H\u0005\u0005I\u0011\u0011B6\u0003\u001d)h.\u00199qYf$BA!\u001c\u0003zA)QBa\u001c\u0003t%\u0019!\u0011\u000f\b\u0003\r=\u0003H/[8o!\u0015i!QO*e\u0013\r\u00119H\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tm$qMA\u0001\u0002\u0004)\u0015a\u0001=%a\u001dI!q\u0010\u0001\u0002\u0002#%!\u0011Q\u0001\f\u0017\u0016L8i\u001c8uK:$8\u000fE\u0002G\u0005\u00073\u0001\u0002\u001c\u0001\u0002\u0002#%!QQ\n\u0006\u0005\u0007\u00139)\u0014\t\b\u0005\u001b\u0012\u0019fU;k\u0011\u001d\t#1\u0011C\u0001\u0005\u0017#\"A!!\t\u0015\u0005\r%1QA\u0001\n\u000b\n)\t\u0003\u0006\u0003`\t\r\u0015\u0011!CA\u0005##RA\u001bBJ\u0005+Caa\u001cBH\u0001\u0004\u0019\u0006BB:\u0003\u0010\u0002\u0007Q\u000f\u0003\u0006\u0003j\t\r\u0015\u0011!CA\u00053#BAa'\u0003 B)QBa\u001c\u0003\u001eB)QB!\u001eTk\"I!1\u0010BL\u0003\u0003\u0005\rA[\u0004\n\u0005G\u0003\u0011\u0011!E\u0005\u0005K\u000ba\"T;mi&\u0004\u0018M\u001d;DQVt7\u000eE\u0002G\u0005O3\u0011\"!8\u0001\u0003\u0003EIA!+\u0014\u000b\t\u001d&1V'\u0011\u0013\t5#1KA%k\u0006e\u0007bB\u0011\u0003(\u0012\u0005!q\u0016\u000b\u0003\u0005KC!\"a!\u0003(\u0006\u0005IQIAC\u0011)\u0011yFa*\u0002\u0002\u0013\u0005%Q\u0017\u000b\u0007\u00033\u00149L!/\t\u0011\u0005U(1\u0017a\u0001\u0003\u0013Baa\u001dBZ\u0001\u0004)\bB\u0003B5\u0005O\u000b\t\u0011\"!\u0003>R!!q\u0018Bb!\u0015i!q\u000eBa!\u0019i!QOA%k\"Q!1\u0010B^\u0003\u0003\u0005\r!!7\t\u000f\t\u001d\u0007\u0001\"\u0011\u0003J\u0006iQ.\u001a;bI\u0006$\u0018m\u0015;pe\u0016,\"Aa3\u0011\u0007!\u0012i-C\u0002\u0003P&\u0012Q\"T3uC\u0012\fG/Y*u_J,\u0007b\u0002Bj\u0001\u0011\u0005#Q[\u0001\fY&\u001cHOQ;dW\u0016$8/\u0006\u0002\u0003XB!!\u0011\u001cBp\u001b\t\u0011YNC\u0002\u0003^\u0012\t\u0001B]3ta>t7/Z\u0005\u0005\u0005C\u0014YN\u0001\tMSN$\u0018\t\u001c7Ns\n+8m[3ug\"9!Q\u001d\u0001\u0005B\t\u001d\u0018A\u00037jgR\u0014UoY6fiRA!\u0011\u001eBx\u0005g\u0014I\u0010\u0005\u0003\u0003Z\n-\u0018\u0002\u0002Bw\u00057\u0014!\u0002T5ti\n+8m[3u\u0011\u001d\u0011\tPa9A\u0002i\naAY;dW\u0016$\b\u0002\u0003B{\u0005G\u0004\rAa>\u0002\rA\u0014XMZ5y!\u0011i!q\u000e\u001e\t\u0011\tm(1\u001da\u0001\u0005o\f\u0011\u0002Z3mS6LG/\u001a:\t\u000f\t}\b\u0001\"\u0011\u0004\u0002\u0005a1M]3bi\u0016\u0014UoY6fiR111AB\u0005\u0007\u001b\u0001BA!7\u0004\u0006%!1q\u0001Bn\u00051\u0019%/Z1uK\n+8m[3u\u0011\u001d\u0019YA!@A\u0002i\nAA\\1nK\"A1q\u0002B\u007f\u0001\u0004\u0019\t\"\u0001\u0007ck\u000e\\W\r^\"p]\u001aLw\r\u0005\u0003\u0004\u0014\reQBAB\u000b\u0015\r\u00199\u0002B\u0001\be\u0016\fX/Z:u\u0013\u0011\u0019Yb!\u0006\u00033\r\u0013X-\u0019;f\u0005V\u001c7.\u001a;D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0007?\u0001A\u0011IB\u0011\u0003%\u0001X\u000f^(cU\u0016\u001cG\u000f\u0006\u0006\u0004$\r%21FB\u0018\u0007c\u00012!DB\u0013\u0013\r\u00199C\u0004\u0002\u0005+:LG\u000fC\u0004\u0003r\u000eu\u0001\u0019\u0001\u001e\t\u000f\r52Q\u0004a\u0001u\u0005\u00191.Z=\t\rM\u001ci\u00021\u0001v\u0011)\u0019\u0019d!\b\u0011\u0002\u0003\u00071QG\u0001\u000f_\nTWm\u0019;NKR\fG-\u0019;b!\u0015i!qNB\u001c!\u0011\u0019Id!\u0013\u000e\u0005\rm\"b\u0001,\u0004>)!1qHB!\u0003\t\u00198G\u0003\u0003\u0004D\r\u0015\u0013\u0001C:feZL7-Z:\u000b\u0007\r\u001dC$A\u0005b[\u0006TxN\\1xg&!11JB\u001e\u00059y%M[3di6+G/\u00193bi\u0006Dqaa\u0014\u0001\t\u0003\u001a\t&A\u0005hKR|%M[3diR111KB-\u00077\u00022aEB+\u0013\r\u00199F\u0001\u0002\u000e\u000f\u0016$xJ\u00196fGR$\u0015\r^1\t\u000f\tE8Q\na\u0001u!91QFB'\u0001\u0004Q\u0004bBB0\u0001\u0011\u00053\u0011M\u0001\u0018aV$xJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014Ho\u0015;beR$baa\u0019\u0004j\r-\u0004\u0003\u0002Bm\u0007KJAaa\u001a\u0003\\\ni\u0012J\\5uS\u0006$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\r\u001a*fgVdG\u000fC\u0004\u0003r\u000eu\u0003\u0019\u0001\u001e\t\u000f\r52Q\fa\u0001u!91q\u000e\u0001\u0005B\rE\u0014A\u00069vi>\u0013'.Z2u\u001bVdG/\u001b9beR\u0004\u0016M\u001d;\u0015\u0019\r\r21OB;\u0007o\u001aYha \t\u000f\tE8Q\u000ea\u0001u!91QFB7\u0001\u0004Q\u0004\u0002CB=\u0007[\u0002\r!!\u0013\u0002\u0015A\f'\u000f\u001e(v[\n,'\u000fC\u0004\u0004~\r5\u0004\u0019\u0001\u001e\u0002\u0011U\u0004Hn\\1e\u0013\u0012Daa]B7\u0001\u0004)\bbBBB\u0001\u0011\u00053QQ\u0001\u001baV$xJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014HoQ8na2,G/\u001a\u000b\u000b\u0007\u000f\u001biia$\u0004\u0012\u000eM\u0005\u0003\u0002Bm\u0007\u0013KAaa#\u0003\\\ni2i\\7qY\u0016$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\r\u001a*fgVdG\u000fC\u0004\u0003r\u000e\u0005\u0005\u0019\u0001\u001e\t\u000f\r52\u0011\u0011a\u0001u!91QPBA\u0001\u0004Q\u0004\u0002CB\f\u0007\u0003\u0003\ra!&\u0011\t\rM1qS\u0005\u0005\u00073\u001b)BA\fD_6\u0004H.\u001a;f\u001bVdG/\u001b9beR,\u0006\u000f\\8bI\"91Q\u0014\u0001\u0005B\r}\u0015AC2paf|%M[3diRa1\u0011UBT\u0007W\u001byka-\u00048B!!\u0011\\BR\u0013\u0011\u0019)Ka7\u0003!\r{\u0007/_(cU\u0016\u001cGOU3tk2$\bbBBU\u00077\u0003\rAO\u0001\rg>,(oY3Ck\u000e\\W\r\u001e\u0005\b\u0007[\u001bY\n1\u0001;\u0003%\u0019x.\u001e:dK.+\u0017\u0010C\u0004\u00042\u000em\u0005\u0019\u0001\u001e\u0002\u0015\u0011,7\u000f\u001e\"vG.,G\u000fC\u0004\u00046\u000em\u0005\u0019\u0001\u001e\u0002\u000f\u0011,7\u000f^&fs\"Q1\u0011XBN!\u0003\u0005\ra!\u000e\u0002\u000f9,w/T3uC\"91Q\u0018\u0001\u0005B\r}\u0016\u0001\u00043fY\u0016$Xm\u00142kK\u000e$HCBB\u0012\u0007\u0003\u001c\u0019\rC\u0004\u0003r\u000em\u0006\u0019\u0001\u001e\t\u000f\r521\u0018a\u0001u!91q\u0019\u0001\u0005B\r%\u0017\u0001\u00043fY\u0016$XMQ;dW\u0016$H\u0003BB\u0012\u0007\u0017DqA!=\u0004F\u0002\u0007!\bC\u0005\u0004P\u0002\t\n\u0011\"\u0011\u0004R\u0006\u0019\u0002/\u001e;PE*,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u001b\u0016\u0005\u0007k\t)\u0002C\u0005\u0004X\u0002\t\n\u0011\"\u0011\u0004R\u0006!2m\u001c9z\u001f\nTWm\u0019;%I\u00164\u0017-\u001e7uIU\u0002")
public class InMemoryProvider
implements Provider,
LazyLogging {
    private volatile InMemoryProvider$BucketContents$ BucketContents$module;
    private volatile InMemoryProvider$KeyContents$ KeyContents$module;
    private volatile InMemoryProvider$MultipartChunk$ MultipartChunk$module;
    private final InMemoryMetadataStore mdStore;
    private final TrieMap<String, BucketContents> bucketDataStore;
    private final TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore;
    private volatile Logger logger;
    private volatile boolean bitmap$0;

    private InMemoryProvider$BucketContents$ BucketContents() {
        if (this.BucketContents$module == null) {
            this.BucketContents$lzycompute$1();
        }
        return this.BucketContents$module;
    }

    private InMemoryProvider$KeyContents$ KeyContents() {
        if (this.KeyContents$module == null) {
            this.KeyContents$lzycompute$1();
        }
        return this.KeyContents$module;
    }

    private InMemoryProvider$MultipartChunk$ MultipartChunk() {
        if (this.MultipartChunk$module == null) {
            this.MultipartChunk$lzycompute$1();
        }
        return this.MultipartChunk$module;
    }

    private Logger logger$lzycompute() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private InMemoryMetadataStore mdStore() {
        return this.mdStore;
    }

    private TrieMap<String, BucketContents> bucketDataStore() {
        return this.bucketDataStore;
    }

    private TrieMap<String, SortedSet<MultipartChunk>> multipartTempStore() {
        return this.multipartTempStore;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.mdStore();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.Iterable buckets = (scala.collection.mutable.Iterable)this.bucketDataStore().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            BucketContents data = (BucketContents)tuple2._2();
            Bucket bucket = new Bucket(name, data.creationTime());
            return bucket;
        }, Iterable$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing buckets: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buckets.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Iterable$.MODULE$.canBuildFrom())})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter) {
        String prefix2 = (String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Nil$ nil$;
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Map matchingKeys = bucketContent.keysInBucket().filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(prefix2)));
            Iterable matchResults = (Iterable)matchingKeys.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                KeyContents content = (KeyContents)tuple2._2();
                Content content2 = new Content(name, content.lastModificationTime(), DigestUtils.md5Hex((byte[])content.data()), content.data().length, "STANDARD");
                return content2;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listing bucket contents: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{matchResults.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.key(), scala.collection.Iterable$.MODULE$.canBuildFrom())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<String> option2 = delimiter;
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String del = (String)some2.value();
                nil$ = (List)((SeqLike)((TraversableOnce)matchResults.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(InMemoryProvider.commonPrefix$1(f.key(), prefix2, del)), scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).distinct();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                nil$ = Nil$.MODULE$;
            }
            Nil$ commonPrefixes = nil$;
            List filteredFiles = ((TraversableOnce)matchResults.filterNot(arg_0 -> InMemoryProvider.$anonfun$listBucket$6$adapted((List)commonPrefixes, arg_0))).toList();
            return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)((List)filteredFiles.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.key(), (Ordering)Ordering.String$.MODULE$)));
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        throw new NoSuchBucketException(bucket);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        this.bucketDataStore().putIfAbsent((Object)name, (Object)new BucketContents(this, DateTime$.MODULE$.now(), (scala.collection.mutable.Map<String, KeyContents>)new TrieMap()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"creating bucket ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, Option<ObjectMetadata> objectMetadata) {
        BucketContents bucketContent;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            bucketContent = (BucketContents)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"putting object for s3://", "/", ", bytes = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key, BoxesRunTime.boxToInteger((int)data.length)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), data));
        objectMetadata.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            InMemoryProvider.$anonfun$putObject$1(this, bucket, key, meta);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public Option<ObjectMetadata> putObject$default$4() {
        return None$.MODULE$;
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        GetObjectData getObjectData;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            KeyContents keyContent;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                Some some2 = (Some)option2;
                keyContent = (KeyContents)some2.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reading object for s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new NoSuchKeyException(bucket, key);
                }
                throw new MatchError((Object)option2);
            }
            Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
            getObjectData = new GetObjectData(keyContent.data(), meta);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        GetObjectData getObjectData2 = getObjectData;
        return getObjectData2;
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key) {
        String id;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
            this.multipartTempStore().putIfAbsent((Object)id, (Object)new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"starting multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult(bucket, key, id);
        return initiateMultipartUploadResult;
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uploading multipart chunk ", " for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        ((SetLike)this.multipartTempStore().getOrElseUpdate((Object)uploadId, (Function0 & Serializable & scala.Serializable)() -> new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).add((Object)new MultipartChunk(this, partNumber, data));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        byte[] completeBytes;
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            completeBytes = (byte[])((TraversableOnce)((SetLike)this.multipartTempStore().apply((Object)uploadId)).toSeq().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.data(), Seq$.MODULE$.canBuildFrom())).fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            bucketContent.keysInBucket().put((Object)key, (Object)new KeyContents(this, DateTime$.MODULE$.now(), completeBytes));
            this.multipartTempStore().remove((Object)uploadId);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"completed multipart upload for s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult(bucket, key, DigestUtils.md5Hex((byte[])completeBytes));
        return completeMultipartUploadResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        Tuple2 tuple2 = new Tuple2((Object)this.bucketDataStore().get((Object)sourceBucket), (Object)this.bucketDataStore().get((Object)destBucket));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                BucketContents srcBucketContent = (BucketContents)some.value();
                if (option2 instanceof Some) {
                    DateTime destFileModTime;
                    KeyContents srcKeyContent;
                    Some some2 = (Some)option2;
                    BucketContents dstBucketContent = (BucketContents)some2.value();
                    Option option3 = srcBucketContent.keysInBucket().get((Object)sourceKey);
                    if (option3 instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some3 = (Some)option3;
                        srcKeyContent = (KeyContents)some3.value();
                        destFileModTime = DateTime$.MODULE$.now();
                        dstBucketContent.keysInBucket().put((Object)destKey, (Object)new KeyContents(this, destFileModTime, (byte[])srcKeyContent.data().clone()));
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copied s3://", "/", " to s3://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceBucket, sourceKey, destBucket, destKey})));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                        throw new NoSuchKeyException(sourceBucket, sourceKey);
                    }
                    Option sourceMeta = newMeta.orElse((Function0 & Serializable & scala.Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
                    sourceMeta.foreach((Function1 & Serializable & scala.Serializable)meta -> {
                        InMemoryProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
                        return BoxedUnit.UNIT;
                    });
                    CopyObjectResult copyObjectResult = new CopyObjectResult(destFileModTime, DigestUtils.md5Hex((byte[])srcKeyContent.data()));
                    return copyObjectResult;
                }
            }
        }
        if (tuple2 == null) throw new NoSuchBucketException(destBucket);
        Option option = (Option)tuple2._1();
        if (!None$.MODULE$.equals(option)) throw new NoSuchBucketException(destBucket);
        throw new NoSuchBucketException(sourceBucket);
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteObject(String bucket, String key) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketContents bucketContent = (BucketContents)some.value();
            Option option2 = bucketContent.keysInBucket().get((Object)key);
            if (option2 instanceof Some) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting object s://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, key})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bucketContent.keysInBucket().remove((Object)key);
                this.metadataStore().delete(bucket, key);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                Option option3 = bucketContent.keysInBucket().keys().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(key)));
                if (option3 instanceof Some) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recursive delete by prefix is not supported by S3"})).s((Seq)Nil$.MODULE$));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    if (!None$.MODULE$.equals(option3)) throw new MatchError((Object)option3);
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key does not exist"})).s((Seq)Nil$.MODULE$));
                        boxedUnit = BoxedUnit.UNIT;
                        throw new NoSuchKeyException(bucket, key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NoSuchKeyException(bucket, key);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            throw new NoSuchBucketException(bucket);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void deleteBucket(String bucket) {
        Option option = this.bucketDataStore().get((Object)bucket);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"deleting bucket s://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NoSuchBucketException(bucket);
            }
            throw new MatchError((Object)option);
        }
        this.bucketDataStore().remove((Object)bucket);
        this.metadataStore().remove(bucket);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void BucketContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.BucketContents$module == null) {
                this.BucketContents$module = new InMemoryProvider$BucketContents$(this);
            }
        }
    }

    private final void KeyContents$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.KeyContents$module == null) {
                this.KeyContents$module = new InMemoryProvider$KeyContents$(this);
            }
        }
    }

    private final void MultipartChunk$lzycompute$1() {
        InMemoryProvider inMemoryProvider = this;
        synchronized (inMemoryProvider) {
            if (this.MultipartChunk$module == null) {
                this.MultipartChunk$module = new InMemoryProvider$MultipartChunk$(this);
            }
        }
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)(p + dir.substring(p.length(), n) + d));
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$7(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$putObject$1(InMemoryProvider $this, String bucket$1, String key$1, ObjectMetadata meta) {
        $this.metadataStore().put(bucket$1, key$1, meta);
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(InMemoryProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public InMemoryProvider() {
        LazyLogging.$init$((LazyLogging)this);
        this.mdStore = new InMemoryMetadataStore();
        this.bucketDataStore = new TrieMap();
        this.multipartTempStore = new TrieMap();
    }

    public static final /* synthetic */ Object $anonfun$listBucket$6$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)InMemoryProvider.$anonfun$listBucket$7(f, p))));
    }

    public class BucketContents
    implements Product,
    scala.Serializable {
        private final DateTime creationTime;
        private final scala.collection.mutable.Map<String, KeyContents> keysInBucket;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime creationTime() {
            return this.creationTime;
        }

        public scala.collection.mutable.Map<String, KeyContents> keysInBucket() {
            return this.keysInBucket;
        }

        public BucketContents copy(DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            return new BucketContents(this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer(), creationTime, keysInBucket);
        }

        public DateTime copy$default$1() {
            return this.creationTime();
        }

        public scala.collection.mutable.Map<String, KeyContents> copy$default$2() {
            return this.keysInBucket();
        }

        public String productPrefix() {
            return "BucketContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            scala.collection.mutable.Map<String, KeyContents> map;
            int n = x$1;
            switch (n) {
                case 0: {
                    map = this.creationTime();
                    break;
                }
                case 1: {
                    map = this.keysInBucket();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return map;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BucketContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BucketContents)) return false;
            if (((BucketContents)object).io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BucketContents bucketContents = (BucketContents)x$1;
            DateTime dateTime = this.creationTime();
            DateTime dateTime2 = bucketContents.creationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            scala.collection.mutable.Map<String, KeyContents> map = this.keysInBucket();
            scala.collection.mutable.Map<String, KeyContents> map2 = bucketContents.keysInBucket();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!bucketContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$BucketContents$$$outer() {
            return this.$outer;
        }

        public BucketContents(InMemoryProvider $outer, DateTime creationTime, scala.collection.mutable.Map<String, KeyContents> keysInBucket) {
            this.creationTime = creationTime;
            this.keysInBucket = keysInBucket;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class KeyContents
    implements Product,
    scala.Serializable {
        private final DateTime lastModificationTime;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public DateTime lastModificationTime() {
            return this.lastModificationTime;
        }

        public byte[] data() {
            return this.data;
        }

        public KeyContents copy(DateTime lastModificationTime, byte[] data) {
            return new KeyContents(this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer(), lastModificationTime, data);
        }

        public DateTime copy$default$1() {
            return this.lastModificationTime();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "KeyContents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.lastModificationTime();
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof KeyContents)) return false;
            if (((KeyContents)object).io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            KeyContents keyContents = (KeyContents)x$1;
            DateTime dateTime = this.lastModificationTime();
            DateTime dateTime2 = keyContents.lastModificationTime();
            if (dateTime == null) {
                if (dateTime2 != null) {
                    return false;
                }
            } else if (!dateTime.equals(dateTime2)) return false;
            if (this.data() != keyContents.data()) return false;
            if (!keyContents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$KeyContents$$$outer() {
            return this.$outer;
        }

        public KeyContents(InMemoryProvider $outer, DateTime lastModificationTime, byte[] data) {
            this.lastModificationTime = lastModificationTime;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class MultipartChunk
    implements Ordered<MultipartChunk>,
    Product,
    scala.Serializable {
        private final int partNo;
        private final byte[] data;
        public final /* synthetic */ InMemoryProvider $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public int partNo() {
            return this.partNo;
        }

        public byte[] data() {
            return this.data;
        }

        public int compare(MultipartChunk that) {
            return Predef$.MODULE$.int2Integer(this.partNo()).compareTo(Predef$.MODULE$.int2Integer(that.partNo()));
        }

        public MultipartChunk copy(int partNo, byte[] data) {
            return new MultipartChunk(this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer(), partNo, data);
        }

        public int copy$default$1() {
            return this.partNo();
        }

        public byte[] copy$default$2() {
            return this.data();
        }

        public String productPrefix() {
            return "MultipartChunk";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.partNo());
                    break;
                }
                case 1: {
                    object = this.data();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MultipartChunk;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.partNo());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MultipartChunk)) return false;
            if (((MultipartChunk)object).io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() != this.io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MultipartChunk multipartChunk = (MultipartChunk)x$1;
            if (this.partNo() != multipartChunk.partNo()) return false;
            if (this.data() != multipartChunk.data()) return false;
            if (!multipartChunk.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InMemoryProvider io$findify$s3mock$provider$InMemoryProvider$MultipartChunk$$$outer() {
            return this.$outer;
        }

        public MultipartChunk(InMemoryProvider $outer, int partNo, byte[] data) {
            this.partNo = partNo;
            this.data = data;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

