/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock.provider;

import akka.http.scaladsl.model.DateTime$;
import better.files.File;
import better.files.File$;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.error.NoSuchBucketException;
import io.findify.s3mock.error.NoSuchKeyException;
import io.findify.s3mock.provider.GetObjectData;
import io.findify.s3mock.provider.Provider;
import io.findify.s3mock.provider.metadata.MapMetadataStore;
import io.findify.s3mock.provider.metadata.MetadataStore;
import io.findify.s3mock.request.CompleteMultipartUpload;
import io.findify.s3mock.request.CreateBucketConfiguration;
import io.findify.s3mock.response.Bucket;
import io.findify.s3mock.response.CompleteMultipartUploadResult;
import io.findify.s3mock.response.Content;
import io.findify.s3mock.response.CopyObjectResult;
import io.findify.s3mock.response.CreateBucket;
import io.findify.s3mock.response.InitiateMultipartUploadResult;
import io.findify.s3mock.response.ListAllMyBuckets;
import io.findify.s3mock.response.ListBucket;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001-\u0011ABR5mKB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011A\u0014xN^5eKJT!!\u0002\u0004\u0002\rM\u001cTn\\2l\u0015\t9\u0001\"A\u0004gS:$\u0017NZ=\u000b\u0003%\t!![8\u0004\u0001M!\u0001\u0001\u0004\n\u0017!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\t!J|g/\u001b3feB\u0011qCH\u0007\u00021)\u0011\u0011DG\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00037q\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002;\u0005\u00191m\\7\n\u0005}A\"a\u0003'bufdunZ4j]\u001eD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0004I&\u0014\bCA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&\u001d5\taE\u0003\u0002(\u0015\u00051AH]8pizJ!!\u000b\b\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S9AQA\f\u0001\u0005\u0002=\na\u0001P5oSRtDC\u0001\u00192!\t\u0019\u0002\u0001C\u0003\"[\u0001\u0007!\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\u000f]|'o\u001b#jeV\tQ\u0007\u0005\u00027w5\tqG\u0003\u00029s\u0005)a-\u001b7fg*\t!(\u0001\u0004cKR$XM]\u0005\u0003y]\u0012AAR5mK\"1a\b\u0001Q\u0001\nU\n\u0001b^8sW\u0012K'\u000f\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0003\u0011iW\r^1\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0002\u0002\u00115,G/\u00193bi\u0006L!a\u0012#\u0003!5\u000b\u0007/T3uC\u0012\fG/Y*u_J,\u0007BB%\u0001A\u0003%!)A\u0003nKR\f\u0007\u0005C\u0003L\u0001\u0011\u0005C*A\u0007nKR\fG-\u0019;b'R|'/Z\u000b\u0002\u001bB\u00111IT\u0005\u0003\u001f\u0012\u0013Q\"T3uC\u0012\fG/Y*u_J,\u0007\"B)\u0001\t\u0003\u0012\u0016a\u00037jgR\u0014UoY6fiN,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0012\t\u0001B]3ta>t7/Z\u0005\u00031V\u0013\u0001\u0003T5ti\u0006cG.T=Ck\u000e\\W\r^:\t\u000bi\u0003A\u0011I.\u0002\u00151L7\u000f\u001e\"vG.,G\u000fF\u0003]?\u00064\u0007\u000e\u0005\u0002U;&\u0011a,\u0016\u0002\u000b\u0019&\u001cHOQ;dW\u0016$\b\"\u00021Z\u0001\u0004\u0011\u0013A\u00022vG.,G\u000fC\u0003c3\u0002\u00071-\u0001\u0004qe\u00164\u0017\u000e\u001f\t\u0004\u001b\u0011\u0014\u0013BA3\u000f\u0005\u0019y\u0005\u000f^5p]\")q-\u0017a\u0001G\u0006IA-\u001a7j[&$XM\u001d\u0005\u0006Sf\u0003\rA[\u0001\b[\u0006D8.Z=t!\riAm\u001b\t\u0003\u001b1L!!\u001c\b\u0003\u0007%sG\u000fC\u0003p\u0001\u0011\u0005\u0003/\u0001\u0007de\u0016\fG/\u001a\"vG.,G\u000fF\u0002riZ\u0004\"\u0001\u0016:\n\u0005M,&\u0001D\"sK\u0006$XMQ;dW\u0016$\b\"B;o\u0001\u0004\u0011\u0013\u0001\u00028b[\u0016DQa\u001e8A\u0002a\fABY;dW\u0016$8i\u001c8gS\u001e\u0004\"!\u001f?\u000e\u0003iT!a\u001f\u0003\u0002\u000fI,\u0017/^3ti&\u0011QP\u001f\u0002\u001a\u0007J,\u0017\r^3Ck\u000e\\W\r^\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011A\u0001\naV$xJ\u00196fGR$\"\"a\u0001\u0002\n\u0005-\u0011qBA\u0010!\ri\u0011QA\u0005\u0004\u0003\u000fq!\u0001B+oSRDQ\u0001\u0019@A\u0002\tBa!!\u0004\u007f\u0001\u0004\u0011\u0013aA6fs\"9\u0011\u0011\u0003@A\u0002\u0005M\u0011\u0001\u00023bi\u0006\u0004R!DA\u000b\u00033I1!a\u0006\u000f\u0005\u0015\t%O]1z!\ri\u00111D\u0005\u0004\u0003;q!\u0001\u0002\"zi\u0016Dq!!\t\u007f\u0001\u0004\t\u0019#\u0001\bpE*,7\r^'fi\u0006$\u0017\r^1\u0011\t\u0005\u0015\u0012qG\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005)Qn\u001c3fY*!\u0011QFA\u0018\u0003\t\u00198G\u0003\u0003\u00022\u0005M\u0012\u0001C:feZL7-Z:\u000b\u0007\u0005UB$A\u0005b[\u0006TxN\\1xg&!\u0011\u0011HA\u0014\u00059y%M[3di6+G/\u00193bi\u0006Dq!!\u0010\u0001\t\u0003\ny$A\u0005hKR|%M[3diR1\u0011\u0011IA$\u0003\u0013\u00022aEA\"\u0013\r\t)E\u0001\u0002\u000e\u000f\u0016$xJ\u00196fGR$\u0015\r^1\t\r\u0001\fY\u00041\u0001#\u0011\u001d\ti!a\u000fA\u0002\tBq!!\u0014\u0001\t\u0003\ny%A\fqkR|%M[3di6+H\u000e^5qCJ$8\u000b^1siR1\u0011\u0011KA,\u00033\u00022\u0001VA*\u0013\r\t)&\u0016\u0002\u001e\u0013:LG/[1uK6+H\u000e^5qCJ$X\u000b\u001d7pC\u0012\u0014Vm];mi\"1\u0001-a\u0013A\u0002\tBq!!\u0004\u0002L\u0001\u0007!\u0005C\u0004\u0002^\u0001!\t%a\u0018\u0002-A,Ho\u00142kK\u000e$X*\u001e7uSB\f'\u000f\u001e)beR$B\"a\u0001\u0002b\u0005\r\u0014QMA5\u0003[Ba\u0001YA.\u0001\u0004\u0011\u0003bBA\u0007\u00037\u0002\rA\t\u0005\b\u0003O\nY\u00061\u0001l\u0003)\u0001\u0018M\u001d;Ok6\u0014WM\u001d\u0005\b\u0003W\nY\u00061\u0001#\u0003!)\b\u000f\\8bI&#\u0007\u0002CA\t\u00037\u0002\r!a\u0005\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t\u0005Q\u0002/\u001e;PE*,7\r^'vYRL\u0007/\u0019:u\u0007>l\u0007\u000f\\3uKRQ\u0011QOA>\u0003{\ny(!!\u0011\u0007Q\u000b9(C\u0002\u0002zU\u0013QdQ8na2,G/Z'vYRL\u0007/\u0019:u+Bdw.\u00193SKN,H\u000e\u001e\u0005\u0007A\u0006=\u0004\u0019\u0001\u0012\t\u000f\u00055\u0011q\u000ea\u0001E!9\u00111NA8\u0001\u0004\u0011\u0003bB>\u0002p\u0001\u0007\u00111\u0011\t\u0004s\u0006\u0015\u0015bAADu\n92i\\7qY\u0016$X-T;mi&\u0004\u0018M\u001d;Va2|\u0017\r\u001a\u0005\b\u0003\u0017\u0003A\u0011IAG\u0003)\u0019w\u000e]=PE*,7\r\u001e\u000b\r\u0003\u001f\u000b)*!'\u0002\u001e\u0006\u0005\u0016Q\u0015\t\u0004)\u0006E\u0015bAAJ+\n\u00012i\u001c9z\u001f\nTWm\u0019;SKN,H\u000e\u001e\u0005\b\u0003/\u000bI\t1\u0001#\u00031\u0019x.\u001e:dK\n+8m[3u\u0011\u001d\tY*!#A\u0002\t\n\u0011b]8ve\u000e,7*Z=\t\u000f\u0005}\u0015\u0011\u0012a\u0001E\u0005QA-Z:u\u0005V\u001c7.\u001a;\t\u000f\u0005\r\u0016\u0011\u0012a\u0001E\u00059A-Z:u\u0017\u0016L\bBCAT\u0003\u0013\u0003\n\u00111\u0001\u0002*\u00069a.Z<NKR\f\u0007\u0003B\u0007e\u0003GAq!!,\u0001\t\u0003\ny+A\nd_BLxJ\u00196fGRlU\u000f\u001c;ja\u0006\u0014H\u000f\u0006\u000b\u0002\u0010\u0006E\u00161WA[\u0003o\u000bI,!0\u0002@\u0006\r\u0017q\u0019\u0005\b\u0003/\u000bY\u000b1\u0001#\u0011\u001d\tY*a+A\u0002\tBq!a(\u0002,\u0002\u0007!\u0005C\u0004\u0002$\u0006-\u0006\u0019\u0001\u0012\t\u000f\u0005m\u00161\u0016a\u0001W\u0006!\u0001/\u0019:u\u0011\u001d\tY'a+A\u0002\tBq!!1\u0002,\u0002\u00071.\u0001\u0005ge>l')\u001f;f\u0011\u001d\t)-a+A\u0002-\fa\u0001^8CsR,\u0007BCAT\u0003W\u0003\n\u00111\u0001\u0002*\"9\u00111\u001a\u0001\u0005B\u00055\u0017\u0001\u00043fY\u0016$Xm\u00142kK\u000e$HCBA\u0002\u0003\u001f\f\t\u000e\u0003\u0004a\u0003\u0013\u0004\rA\t\u0005\b\u0003\u001b\tI\r1\u0001#\u0011\u001d\t)\u000e\u0001C!\u0003/\fA\u0002Z3mKR,')^2lKR$B!a\u0001\u0002Z\"1\u0001-a5A\u0002\tBq!!8\u0001\t\u0013\ty.\u0001\u0004ge>lwj\u001d\u000b\u0004E\u0005\u0005\bbBAr\u00037\u0004\rAI\u0001\u0005a\u0006$\b\u000eC\u0005\u0002h\u0002\t\n\u0011\"\u0011\u0002j\u0006!2m\u001c9z\u001f\nTWm\u0019;%I\u00164\u0017-\u001e7uIU*\"!a;+\t\u0005%\u0016Q^\u0016\u0003\u0003_\u0004B!!=\u0002|6\u0011\u00111\u001f\u0006\u0005\u0003k\f90A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011 \b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0006M(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u0001\u0001\u0012\u0002\u0013\u0005\u0013\u0011^\u0001\u001eG>\u0004\u0018p\u00142kK\u000e$X*\u001e7uSB\f'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%s\u0001")
public class FileProvider
implements Provider,
LazyLogging {
    private final String dir;
    private final better.files.File workDir;
    private final MapMetadataStore meta;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileProvider fileProvider = this;
        synchronized (fileProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public better.files.File workDir() {
        return this.workDir;
    }

    private MapMetadataStore meta() {
        return this.meta;
    }

    @Override
    public MetadataStore metadataStore() {
        return this.meta();
    }

    @Override
    public ListAllMyBuckets listBuckets() {
        BoxedUnit boxedUnit;
        List buckets = File$.MODULE$.apply(this.dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).list().map((Function1 & Serializable & scala.Serializable)f -> new Bucket(this.fromOs(f.name()), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()))).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing buckets: {}", new Object[]{buckets.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), List$.MODULE$.canBuildFrom())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ListAllMyBuckets("root", UUID.randomUUID().toString(), (List<Bucket>)buckets);
    }

    @Override
    public ListBucket listBucket(String bucket, Option<String> prefix, Option<String> delimiter, Option<Object> maxkeys) {
        Nil$ nil$;
        BoxedUnit boxedUnit;
        String prefixNoLeadingSlash = (String)new StringOps(Predef$.MODULE$.augmentString((String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$2(BoxesRunTime.unboxToChar((Object)x$2))));
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        String bucketFileString = this.fromOs(bucketFile.toString());
        Iterator bucketFiles = bucketFile.listRecursively(bucketFile.listRecursively$default$1()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$3(this, prefixNoLeadingSlash, bucketFileString, f)));
        List files = bucketFiles.map((Function1 & Serializable & scala.Serializable)f -> {
            FileInputStream stream = new FileInputStream(f.toJava());
            String md5 = DigestUtils.md5Hex((InputStream)stream);
            return new Content((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(this.fromOs(f.toString()))).drop(bucketFileString.length() + 1))).dropWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$6(BoxesRunTime.unboxToChar((Object)x$4)))), DateTime$.MODULE$.apply(f.lastModifiedTime(f.lastModifiedTime$default$1()).toEpochMilli()), md5, f.size(f.size$default$1()), "STANDARD");
        }).toList();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("listing bucket contents: {}", new Object[]{files.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.key(), List$.MODULE$.canBuildFrom())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<String> option = delimiter;
        if (option instanceof Some) {
            Some some = (Some)option;
            String del = (String)some.value();
            nil$ = (List)((SeqLike)((SeqLike)files.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(FileProvider.commonPrefix$1(f.key(), prefixNoLeadingSlash, del)), List$.MODULE$.canBuildFrom())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ commonPrefixes = nil$;
        List filteredFiles = (List)files.filterNot(arg_0 -> FileProvider.$anonfun$listBucket$9$adapted((List)commonPrefixes, arg_0));
        int count = BoxesRunTime.unboxToInt((Object)maxkeys.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        List result = (List)filteredFiles.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.key(), (Ordering)Ordering.String$.MODULE$);
        return new ListBucket(bucket, prefix, delimiter, (List<String>)commonPrefixes, (List<Content>)result.take(count), result.size() > count);
    }

    @Override
    public CreateBucket createBucket(String name, CreateBucketConfiguration bucketConfig) {
        BoxedUnit boxedUnit;
        better.files.File bucket = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, name})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = !bucket.exists(bucket.exists$default$1()) ? bucket.createDirectory(bucket.createDirectory$default$1()) : BoxedUnit.UNIT;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("creating bucket {}", new Object[]{name});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CreateBucket(name);
    }

    @Override
    public void putObject(String bucket, String key, byte[] data, ObjectMetadata objectMetadata) {
        BoxedUnit boxedUnit;
        boolean x$10;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        boolean x$9 = true;
        boolean x$11 = x$10 = file.createIfNotExists$default$1();
        boolean x$12 = x$9;
        Seq x$13 = file.createIfNotExists$default$3(x$11, x$12);
        Seq x$14 = file.createIfNotExists$default$4(x$11, x$12);
        file.createIfNotExists(x$11, x$12, x$13, x$14);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("writing file for s3://{}/{} to {}/{}/{}, bytes = {}", new Object[]{bucket, key, this.dir, bucket, key, BoxesRunTime.boxToInteger((int)data.length)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
        objectMetadata.setLastModified(DateTime.now().toDate());
        this.metadataStore().put(bucket, key, objectMetadata);
    }

    @Override
    public GetObjectData getObject(String bucket, String key) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("reading object for s://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        if (!file.exists(file.exists$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        if (file.isDirectory(file.isDirectory$default$1())) {
            throw new NoSuchKeyException(bucket, key);
        }
        Option<ObjectMetadata> meta = this.metadataStore().get(bucket, key);
        return new GetObjectData(file.byteArray(), meta);
    }

    @Override
    public InitiateMultipartUploadResult putObjectMultipartStart(String bucket, String key) {
        BoxedUnit boxedUnit;
        boolean x$16;
        String id = ((Object)BoxesRunTime.boxToLong((long)Math.abs(Random$.MODULE$.nextLong()))).toString();
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        better.files.File qual$1 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/.keep"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key, id})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$15 = true;
        boolean x$17 = x$16 = qual$1.createIfNotExists$default$1();
        boolean x$18 = x$15;
        Seq x$19 = qual$1.createIfNotExists$default$3(x$17, x$18);
        Seq x$20 = qual$1.createIfNotExists$default$4(x$17, x$18);
        qual$1.createIfNotExists(x$17, x$18, x$19, x$20);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("starting multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new InitiateMultipartUploadResult(bucket, key, id);
    }

    @Override
    public void putObjectMultipartPart(String bucket, String key, int partNumber, String uploadId, byte[] data) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key, uploadId, BoxesRunTime.boxToInteger((int)partNumber)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("uploading multipart chunk {} for s3://{}/{}", new Object[]{BoxesRunTime.boxToInteger((int)partNumber), bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        file.writeByteArray(data, File.OpenOptions$.MODULE$.default());
    }

    @Override
    public CompleteMultipartUploadResult putObjectMultipartComplete(String bucket, String key, String uploadId, CompleteMultipartUpload request) {
        BoxedUnit boxedUnit;
        boolean x$22;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        List files = (List)request.parts().map((Function1 & Serializable & scala.Serializable)part -> File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.dir, bucket, key, uploadId, BoxesRunTime.boxToInteger((int)part.partNumber())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), List$.MODULE$.canBuildFrom());
        List parts = (List)files.map((Function1 & Serializable & scala.Serializable)f -> f.byteArray(), List$.MODULE$.canBuildFrom());
        better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$21 = true;
        boolean x$23 = x$22 = file.createIfNotExists$default$1();
        boolean x$24 = x$21;
        Seq x$25 = file.createIfNotExists$default$3(x$23, x$24);
        Seq x$26 = file.createIfNotExists$default$4(x$23, x$24);
        file.createIfNotExists(x$23, x$24, x$25, x$26);
        byte[] data = (byte[])parts.fold(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$7)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
        Iterator x$27 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).toIterator();
        Seq x$28 = file.writeBytes$default$2(x$27);
        file.writeBytes(x$27, x$28);
        better.files.File qual$2 = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/.mp/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$29 = qual$2.delete$default$1();
        qual$2.delete(x$29);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("completed multipart upload for s3://{}/{}", (Object[])new String[]{bucket, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new CompleteMultipartUploadResult(bucket, key, file.md5());
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucket, String sourceKey, String destBucket, String destKey, Option<ObjectMetadata> newMeta) {
        BoxedUnit boxedUnit;
        boolean x$31;
        better.files.File sourceBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, sourceBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File destBucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, destBucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!sourceBucketFile.exists(sourceBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(sourceBucket);
        }
        if (!destBucketFile.exists(destBucketFile.exists$default$1())) {
            throw new NoSuchBucketException(destBucket);
        }
        better.files.File sourceFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, sourceBucket, sourceKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        better.files.File destFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, destBucket, destKey})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$30 = true;
        boolean x$32 = x$31 = destFile.createIfNotExists$default$1();
        boolean x$33 = x$30;
        Seq x$34 = destFile.createIfNotExists$default$3(x$32, x$33);
        Seq x$35 = destFile.createIfNotExists$default$4(x$32, x$33);
        destFile.createIfNotExists(x$32, x$33, x$34, x$35);
        better.files.File x$36 = destFile;
        boolean x$37 = true;
        Seq x$38 = sourceFile.copyTo$default$3(x$36, x$37);
        sourceFile.copyTo(x$36, x$37, x$38);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Copied s3://{}/{} to s3://{}/{}", new Object[]{sourceBucket, sourceKey, destBucket, destKey});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option sourceMeta = newMeta.orElse((Function0 & Serializable & scala.Serializable)() -> this.metadataStore().get(sourceBucket, sourceKey));
        sourceMeta.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            FileProvider.$anonfun$copyObject$2(this, destBucket, destKey, meta);
            return BoxedUnit.UNIT;
        });
        return new CopyObjectResult(DateTime$.MODULE$.apply(sourceFile.lastModifiedTime(sourceFile.lastModifiedTime$default$1()).toEpochMilli()), destFile.md5());
    }

    @Override
    public Option<ObjectMetadata> copyObject$default$5() {
        return None$.MODULE$;
    }

    @Override
    public CopyObjectResult copyObjectMultipart(String sourceBucket, String sourceKey, String destBucket, String destKey, int part, String uploadId, int fromByte, int toByte, Option<ObjectMetadata> newMeta) {
        byte[] data = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getObject(sourceBucket, sourceKey).bytes())).slice(fromByte, toByte + 1);
        this.putObjectMultipartPart(destBucket, destKey, part, uploadId, data);
        return new CopyObjectResult(DateTime$.MODULE$.now(), DigestUtils.md5Hex((byte[])data));
    }

    @Override
    public Option<ObjectMetadata> copyObjectMultipart$default$9() {
        return None$.MODULE$;
    }

    @Override
    public void deleteObject(String bucket, String key) {
        block3: {
            BoxedUnit boxedUnit;
            better.files.File file = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket, key})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("deleting object s://{}/{}", (Object[])new String[]{bucket, key});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!file.exists(file.exists$default$1())) {
                throw new NoSuchKeyException(bucket, key);
            }
            if (file.isDirectory(file.isDirectory$default$1())) break block3;
            file.delete(file.delete$default$1());
            this.metadataStore().delete(bucket, key);
        }
    }

    @Override
    public void deleteBucket(String bucket) {
        BoxedUnit boxedUnit;
        better.files.File bucketFile = File$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir, bucket})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("deleting bucket s://{}", new Object[]{bucket});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!bucketFile.exists(bucketFile.exists$default$1())) {
            throw new NoSuchBucketException(bucket);
        }
        bucketFile.delete(bucketFile.delete$default$1());
        this.metadataStore().remove(bucket);
    }

    private String fromOs(String path) {
        return path.replace(File.separatorChar, '/');
    }

    private static final Option commonPrefix$1(String dir, String p, String d) {
        None$ none$;
        int n = dir.indexOf(d, p.length());
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = new Some((Object)(p + dir.substring(p.length(), n) + d));
                break;
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$2(char x$2) {
        return x$2 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$4(char x$3) {
        return x$3 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$3(FileProvider $this, String prefixNoLeadingSlash$1, String bucketFileString$1, better.files.File f) {
        String fString = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString($this.fromOs(f.toString()))).drop(bucketFileString$1.length()))).dropWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$4(BoxesRunTime.unboxToChar((Object)x$3))));
        return fString.startsWith(prefixNoLeadingSlash$1) && !f.isDirectory(f.isDirectory$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$6(char x$4) {
        return x$4 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$listBucket$10(Content f$1, String p) {
        return f$1.key().startsWith(p);
    }

    public static final /* synthetic */ void $anonfun$copyObject$2(FileProvider $this, String destBucket$1, String destKey$1, ObjectMetadata meta) {
        $this.metadataStore().put(destBucket$1, destKey$1, meta);
    }

    public FileProvider(String dir) {
        this.dir = dir;
        LazyLogging.$init$((LazyLogging)this);
        this.workDir = File$.MODULE$.apply(dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Object object = !this.workDir().exists(this.workDir().exists$default$1()) ? this.workDir().createDirectories(this.workDir().createDirectories$default$1(), this.workDir().createDirectories$default$2()) : BoxedUnit.UNIT;
        this.meta = new MapMetadataStore(dir);
    }

    public static final /* synthetic */ Object $anonfun$listBucket$9$adapted(List commonPrefixes$1, Content f) {
        return BoxesRunTime.boxToBoolean((boolean)commonPrefixes$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileProvider.$anonfun$listBucket$10(f, p))));
    }
}

