/*
 * Decompiled with CFR 0.152.
 */
package io.findify.s3mock;

import akka.util.ByteString;
import akka.util.ByteString$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.findify.s3mock.Header;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00114A!\u0004\b\u0001+!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0003Y\u0003BB\u001c\u0001A\u0003%A\u0006C\u00049\u0001\u0001\u0007I\u0011A\u001d\t\u000fu\u0002\u0001\u0019!C\u0001}!1A\t\u0001Q!\niBq!\u0012\u0001A\u0002\u0013\u0005a\tC\u0004P\u0001\u0001\u0007I\u0011\u0001)\t\rI\u0003\u0001\u0015)\u0003H\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015y\u0006\u0001\"\u0001a\u0005-\u0019\u0005.\u001e8l\u0005V4g-\u001a:\u000b\u0005=\u0001\u0012AB:4[>\u001c7N\u0003\u0002\u0012%\u00059a-\u001b8eS\u001aL(\"A\n\u0002\u0005%|7\u0001A\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005a1oY1mC2|wmZ5oO*\u0011\u0011EI\u0001\tif\u0004Xm]1gK*\t1%A\u0002d_6L!!\n\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u00039\t\u0001\u0002[3y\u0007\"\f'o]\u000b\u0002YA\u0019QF\r\u001b\u000e\u00039R!a\f\u0019\u0002\u0013%lW.\u001e;bE2,'BA\u0019\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g9\u00121aU3u!\t9R'\u0003\u000271\t!!)\u001f;f\u0003%AW\r_\"iCJ\u001c\b%\u0001\u0003tSj,W#\u0001\u001e\u0011\u0005]Y\u0014B\u0001\u001f\u0019\u0005\rIe\u000e^\u0001\tg&TXm\u0018\u0013fcR\u0011qH\u0011\t\u0003/\u0001K!!\u0011\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\u0016\t\t\u00111\u0001;\u0003\rAH%M\u0001\u0006g&TX\rI\u0001\u0007EV4g-\u001a:\u0016\u0003\u001d\u0003\"\u0001S'\u000e\u0003%S!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!\u0011m[6b\u0013\tq\u0015J\u0001\u0006CsR,7\u000b\u001e:j]\u001e\f!BY;gM\u0016\u0014x\fJ3r)\ty\u0014\u000bC\u0004D\u0011\u0005\u0005\t\u0019A$\u0002\u000f\t,hMZ3sA\u0005A\u0011\r\u001a3DQVt7\u000e\u0006\u0002@+\")aK\u0003a\u0001\u000f\u0006!A-\u0019;b\u0003)\u0011X-\u00193IK\u0006$WM]\u000b\u00023B\u0019qC\u0017/\n\u0005mC\"AB(qi&|g\u000e\u0005\u0002*;&\u0011aL\u0004\u0002\u0007\u0011\u0016\fG-\u001a:\u0002\u0013A,H\u000e\\\"ik:\\GCA1c!\r9\"l\u0012\u0005\u0006G2\u0001\r\u0001X\u0001\u0007Q\u0016\fG-\u001a:")
public class ChunkBuffer
implements LazyLogging {
    private final Set<Object> hexChars;
    private int size;
    private ByteString buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ChunkBuffer chunkBuffer = this;
        synchronized (chunkBuffer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Set<Object> hexChars() {
        return this.hexChars;
    }

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public ByteString buffer() {
        return this.buffer;
    }

    public void buffer_$eq(ByteString x$1) {
        this.buffer = x$1;
    }

    public void addChunk(ByteString data) {
        this.buffer_$eq(this.buffer().$plus$plus(data));
    }

    public Option<Header> readHeader() {
        None$ none$;
        ByteString headerBuffer = this.buffer().take(90);
        ByteString size = headerBuffer.takeWhile((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ChunkBuffer.$anonfun$readHeader$1(this, BoxesRunTime.unboxToByte((Object)elem))));
        ByteString sig = headerBuffer.drop(size.length()).take(83);
        if (size.length() <= 8 && sig.length() == 83 && sig.startsWith((IterableOnce)Predef$.MODULE$.wrapString(";chunk-signature="), sig.startsWith$default$2()) && sig.endsWith((Iterable)Predef$.MODULE$.wrapString("\r\n"))) {
            BoxedUnit boxedUnit;
            Header header = new Header(Integer.parseInt(size.utf8String(), 16), size.length() + 83, sig.drop(17).dropRight(2).utf8String());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("read header: {}", (Object)header);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)header);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("cannot read header");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<ByteString> pullChunk(Header header) {
        None$ none$;
        if (this.buffer().length() >= header.headerSize() + header.chunkSize() + 2) {
            BoxedUnit boxedUnit;
            this.buffer_$eq(this.buffer().drop(header.headerSize()));
            ByteString chunk = this.buffer().take(header.chunkSize());
            this.buffer_$eq(this.buffer().drop(header.chunkSize() + 2));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("pulled chunk, size={}", (Object)BoxesRunTime.boxToInteger((int)header.chunkSize()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = new Some((Object)chunk);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("not enough data to pull chunk: chunkSize = {}, bufferSize = {}", new Object[]{BoxesRunTime.boxToInteger((int)header.chunkSize()), BoxesRunTime.boxToInteger((int)this.buffer().length())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$readHeader$1(ChunkBuffer $this, byte elem) {
        return $this.hexChars().contains((Object)BoxesRunTime.boxToByte((byte)elem));
    }

    public ChunkBuffer() {
        LazyLogging.$init$((LazyLogging)this);
        this.hexChars = Predef$.MODULE$.wrapByteArray("0123456789abcdef".getBytes()).toSet();
        this.size = -1;
        this.buffer = ByteString$.MODULE$.apply("");
    }
}

