/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.util.Iterator;
import ml.dmlc.xgboost4j.LabeledPoint;
import ml.dmlc.xgboost4j.java.DataBatch;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;

public class DMatrix {
    protected long handle = 0L;

    public DMatrix(Iterator<LabeledPoint> iterator, String string) throws XGBoostError {
        if (iterator == null) {
            throw new NullPointerException("iter: null");
        }
        int n = 32768;
        DataBatch.BatchIterator batchIterator = new DataBatch.BatchIterator(iterator, n);
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromDataIter(batchIterator, string, lArray));
        this.handle = lArray[0];
    }

    public DMatrix(String string) throws XGBoostError {
        if (string == null) {
            throw new NullPointerException("dataPath: null");
        }
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromFile(string, 1, lArray));
        this.handle = lArray[0];
    }

    @Deprecated
    public DMatrix(long[] lArray, int[] nArray, float[] fArray, SparseType sparseType) throws XGBoostError {
        long[] lArray2 = new long[1];
        if (sparseType == SparseType.CSR) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSREx(lArray, nArray, fArray, 0, lArray2));
        } else if (sparseType == SparseType.CSC) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSCEx(lArray, nArray, fArray, 0, lArray2));
        } else {
            throw new UnknownError("unknow sparsetype");
        }
        this.handle = lArray2[0];
    }

    public DMatrix(long[] lArray, int[] nArray, float[] fArray, SparseType sparseType, int n) throws XGBoostError {
        long[] lArray2 = new long[1];
        if (sparseType == SparseType.CSR) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSREx(lArray, nArray, fArray, n, lArray2));
        } else if (sparseType == SparseType.CSC) {
            XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromCSCEx(lArray, nArray, fArray, n, lArray2));
        } else {
            throw new UnknownError("unknow sparsetype");
        }
        this.handle = lArray2[0];
    }

    public DMatrix(float[] fArray, int n, int n2) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromMat(fArray, n, n2, 0.0f, lArray));
        this.handle = lArray[0];
    }

    public DMatrix(float[] fArray, int n, int n2, float f) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixCreateFromMat(fArray, n, n2, f, lArray));
        this.handle = lArray[0];
    }

    protected DMatrix(long l) {
        this.handle = l;
    }

    public void setLabel(float[] fArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "label", fArray));
    }

    public void setWeight(float[] fArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "weight", fArray));
    }

    public void setBaseMargin(float[] fArray) throws XGBoostError {
        if ((long)fArray.length != this.rowNum()) {
            throw new IllegalArgumentException(String.format("base margin must have exactly %s elements, got %s", this.rowNum(), fArray.length));
        }
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetFloatInfo(this.handle, "base_margin", fArray));
    }

    public void setBaseMargin(float[][] fArray) throws XGBoostError {
        this.setBaseMargin(DMatrix.flatten(fArray));
    }

    public void setGroup(int[] nArray) throws XGBoostError {
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSetGroup(this.handle, nArray));
    }

    private float[] getFloatInfo(String string) throws XGBoostError {
        float[][] fArrayArray = new float[1][];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixGetFloatInfo(this.handle, string, fArrayArray));
        return fArrayArray[0];
    }

    private int[] getIntInfo(String string) throws XGBoostError {
        int[][] nArrayArray = new int[1][];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixGetUIntInfo(this.handle, string, nArrayArray));
        return nArrayArray[0];
    }

    public float[] getLabel() throws XGBoostError {
        return this.getFloatInfo("label");
    }

    public float[] getWeight() throws XGBoostError {
        return this.getFloatInfo("weight");
    }

    public float[] getBaseMargin() throws XGBoostError {
        return this.getFloatInfo("base_margin");
    }

    public DMatrix slice(int[] nArray) throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixSliceDMatrix(this.handle, nArray, lArray));
        long l = lArray[0];
        DMatrix dMatrix = new DMatrix(l);
        return dMatrix;
    }

    public long rowNum() throws XGBoostError {
        long[] lArray = new long[1];
        XGBoostJNI.checkCall(XGBoostJNI.XGDMatrixNumRow(this.handle, lArray));
        return lArray[0];
    }

    public void saveBinary(String string) {
        XGBoostJNI.XGDMatrixSaveBinary(this.handle, string, 1);
    }

    public long getHandle() {
        return this.handle;
    }

    private static float[] flatten(float[][] fArray) {
        int n = 0;
        for (float[] fArray2 : fArray) {
            n += fArray2.length;
        }
        float[] fArray3 = new float[n];
        int n2 = 0;
        for (float[] fArray4 : fArray) {
            System.arraycopy(fArray4, 0, fArray3, n2, fArray4.length);
            n2 += fArray4.length;
        }
        return fArray3;
    }

    protected void finalize() {
        this.dispose();
    }

    public synchronized void dispose() {
        if (this.handle != 0L) {
            XGBoostJNI.XGDMatrixFree(this.handle);
            this.handle = 0L;
        }
    }

    public static enum SparseType {
        CSR,
        CSC;

    }
}

