/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String nativePath = "../../lib/";
    private static final String nativeResourcePath = "/lib/";
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            for (String string : libNames) {
                NativeLibLoader.smartLoad(string);
            }
            initialized = true;
        }
    }

    private static void loadLibraryFromJar(String string) throws IOException, IllegalArgumentException {
        String string2 = NativeLibLoader.createTempFileFromResource(string);
        System.load(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createTempFileFromResource(String string) throws IOException, IllegalArgumentException {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] stringArray = string.split("/");
        String string2 = stringArray.length > 1 ? stringArray[stringArray.length - 1] : null;
        String string3 = "";
        String string4 = null;
        if (string2 != null) {
            stringArray = string2.split("\\.", 2);
            string3 = stringArray[0];
            String string5 = string4 = stringArray.length > 1 ? "." + stringArray[stringArray.length - 1] : null;
        }
        if (string2 == null || string3.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File file = File.createTempFile(string3, string4);
        file.deleteOnExit();
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
        }
        byte[] byArray = new byte[1024];
        InputStream inputStream = NativeLibLoader.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException("File " + string + " was not found inside JAR.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
        }
        return file.getAbsolutePath();
    }

    private static void smartLoad(String string) throws IOException {
        NativeLibLoader.addNativeDir(nativePath);
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                String string2 = nativeResourcePath + System.mapLibraryName(string);
                NativeLibLoader.loadLibraryFromJar(string2);
            }
            catch (IOException iOException) {
                logger.error((Object)"failed to load library from both native path and jar");
                throw iOException;
            }
        }
    }

    private static void addNativeDir(String string) throws IOException {
        try {
            String[] stringArray;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String string2 : stringArray = (String[])field.get(null)) {
                if (!string.equals(string2)) continue;
                return;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            field.set(null, stringArray2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)illegalAccessException.getMessage());
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.error((Object)noSuchFieldException.getMessage());
            throw new IOException("Failed to get field handle to set library path");
        }
    }
}

