/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.XGBoostJNI;

public class Rabit {
    private static void checkCall(int n) throws XGBoostError {
        if (n != 0) {
            throw new XGBoostError(XGBoostJNI.XGBGetLastError());
        }
    }

    public static void init(Map<String, String> map) throws XGBoostError {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = entry.getKey() + '=' + entry.getValue();
        }
        Rabit.checkCall(XGBoostJNI.RabitInit(stringArray));
    }

    public static void shutdown() throws XGBoostError {
        Rabit.checkCall(XGBoostJNI.RabitFinalize());
    }

    public static void trackerPrint(String string) throws XGBoostError {
        Rabit.checkCall(XGBoostJNI.RabitTrackerPrint(string));
    }

    public static int versionNumber() throws XGBoostError {
        int[] nArray = new int[1];
        Rabit.checkCall(XGBoostJNI.RabitVersionNumber(nArray));
        return nArray[0];
    }

    public static int getRank() throws XGBoostError {
        int[] nArray = new int[1];
        Rabit.checkCall(XGBoostJNI.RabitGetRank(nArray));
        return nArray[0];
    }

    public static int getWorldSize() throws XGBoostError {
        int[] nArray = new int[1];
        Rabit.checkCall(XGBoostJNI.RabitGetWorldSize(nArray));
        return nArray[0];
    }

    public static float[] allReduce(float[] fArray, OpType opType) {
        DataType dataType = DataType.FLOAT;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dataType.getSize() * fArray.length).order(ByteOrder.nativeOrder());
        for (float f : fArray) {
            byteBuffer.putFloat(f);
        }
        byteBuffer.flip();
        XGBoostJNI.RabitAllreduce(byteBuffer, fArray.length, dataType.getEnumOp(), opType.getOperand());
        float[] fArray2 = new float[fArray.length];
        byteBuffer.asFloatBuffer().get(fArray2);
        return fArray2;
    }

    public static enum DataType implements Serializable
    {
        CHAR(0, 1),
        UCHAR(1, 1),
        INT(2, 4),
        UNIT(3, 4),
        LONG(4, 8),
        ULONG(5, 8),
        FLOAT(6, 4),
        DOUBLE(7, 8),
        LONGLONG(8, 8),
        ULONGLONG(9, 8);

        private int enumOp;
        private int size;

        public int getEnumOp() {
            return this.enumOp;
        }

        public int getSize() {
            return this.size;
        }

        private DataType(int n2, int n3) {
            this.enumOp = n2;
            this.size = n3;
        }
    }

    public static enum OpType implements Serializable
    {
        MAX(0),
        MIN(1),
        SUM(2),
        BITWISE_OR(3);

        private int op;

        public int getOperand() {
            return this.op;
        }

        private OpType(int n2) {
            this.op = n2;
        }
    }
}

