/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.dsl.antlr;

public class ScoreException
extends Exception {
    private static final long serialVersionUID = 6950517934100277304L;
    private final int columnNumber;
    private final int lineNumber;

    public ScoreException() {
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScoreException(String message) {
        super(message);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScoreException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ScoreException(String message, int lineNumber, int columnNumber, Throwable cause) {
        super(message, cause);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ScoreException(String message, Throwable cause) {
        super(message, cause);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScoreException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScoreException(Throwable cause) {
        super(cause);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

