/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.dsl.antlr;

import io.fixprotocol.orchestra.dsl.antlr.BaseSemanticErrorListener;
import io.fixprotocol.orchestra.dsl.antlr.ScoreParser;
import io.fixprotocol.orchestra.dsl.antlr.ScoreVisitor;
import io.fixprotocol.orchestra.dsl.antlr.SemanticErrorListener;
import io.fixprotocol.orchestra.dsl.datetime.DateTimeFormatters;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

class ScoreTranslator
extends AbstractParseTreeVisitor<String>
implements ScoreVisitor<String> {
    private final SemanticErrorListener errorListener;
    private final Map<String, String> tokenMap;
    private boolean trace = false;

    private static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    private static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    private static String ordinal(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + sufixes[i % 10];
    }

    private static Map<String, String> tokenMap() {
        return Collections.unmodifiableMap(Stream.of(ScoreTranslator.entry("eq", "equals"), ScoreTranslator.entry("==", "equals"), ScoreTranslator.entry("ne", "does not equal"), ScoreTranslator.entry("!=", "does not equal"), ScoreTranslator.entry("+", "plus"), ScoreTranslator.entry("-", "minus"), ScoreTranslator.entry("<", "less than"), ScoreTranslator.entry("lt", "less than"), ScoreTranslator.entry("<=", "less than or equal to"), ScoreTranslator.entry("le", "less than or equal to"), ScoreTranslator.entry(">", "greater than"), ScoreTranslator.entry("gt", "greater than"), ScoreTranslator.entry(">=", "greater than or equal to"), ScoreTranslator.entry("ge", "greater than or equal to"), ScoreTranslator.entry("*", "times"), ScoreTranslator.entry("/", "divided by"), ScoreTranslator.entry("%", "modulo"), ScoreTranslator.entry("mod", "modulo"), ScoreTranslator.entry("&&", "and"), ScoreTranslator.entry("and", "and"), ScoreTranslator.entry("||", "or"), ScoreTranslator.entry("or", "or"), ScoreTranslator.entry("!", "not"), ScoreTranslator.entry("not", "not"), ScoreTranslator.entry("=", "is set to"), ScoreTranslator.entry("if", "if"), ScoreTranslator.entry("exists", "exists"), ScoreTranslator.entry("between", "between"), ScoreTranslator.entry("in", "equals one of"), ScoreTranslator.entry("where", "where"), ScoreTranslator.entry("$", "variable"), ScoreTranslator.entry("in.", "incoming"), ScoreTranslator.entry("out.", "outgoing"), ScoreTranslator.entry("^", "")).collect(ScoreTranslator.entriesToMap()));
    }

    public ScoreTranslator() {
        this(new BaseSemanticErrorListener());
    }

    public ScoreTranslator(SemanticErrorListener errorListener) {
        this.errorListener = errorListener;
        this.tokenMap = ScoreTranslator.tokenMap();
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public String visitAddSub(ScoreParser.AddSubContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitAnyExpression(ScoreParser.AnyExpressionContext ctx) {
        return (String)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public String visitAssignment(ScoreParser.AssignmentContext ctx) {
        String val = (String)this.visit((ParseTree)ctx.expr());
        if (val == null) {
            this.errorListener.onError(String.format("Semantic error; missing val for assignment at '%s'", ctx.getText()));
            return null;
        }
        String var = this.visitVar(ctx.var());
        return String.format("%s %s %s", var, this.translateToken("="), val);
    }

    @Override
    public String visitCharacter(ScoreParser.CharacterContext ctx) {
        return ctx.CHAR().getText().substring(1);
    }

    @Override
    public String visitContains(ScoreParser.ContainsContext ctx) {
        String val = (String)this.visit((ParseTree)ctx.val);
        List memberStrings = ctx.member.stream().map(arg_0 -> ((ScoreTranslator)this).visit(arg_0)).collect(Collectors.toList());
        return String.format("%s %s %s %s", this.translateToken("if"), val, this.translateToken("in"), String.join((CharSequence)", ", memberStrings));
    }

    @Override
    public String visitDateonly(ScoreParser.DateonlyContext ctx) {
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(LocalDate.parse(ctx.DATE().getText()));
    }

    @Override
    public String visitDecimal(ScoreParser.DecimalContext ctx) {
        return ctx.DECIMAL().getText();
    }

    @Override
    public String visitDuration(ScoreParser.DurationContext ctx) {
        return Duration.parse(ctx.PERIOD().getText()).toString().substring(2).replace("D", " days").replace("H", " hours").replace("M", " minutes").replace("S", " seconds");
    }

    @Override
    public String visitEquality(ScoreParser.EqualityContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitExist(ScoreParser.ExistContext ctx) {
        return String.format("%s %s %s", this.translateToken("if"), this.visit((ParseTree)ctx.var()), this.translateToken("exists"));
    }

    @Override
    public String visitIndex(ScoreParser.IndexContext ctx) {
        if (ctx.UINT() != null) {
            return ScoreTranslator.ordinal(Integer.parseInt(ctx.UINT().getText()));
        }
        return "";
    }

    @Override
    public String visitInteger(ScoreParser.IntegerContext ctx) {
        return ctx.UINT().getText();
    }

    @Override
    public String visitLogicalAnd(ScoreParser.LogicalAndContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitLogicalNot(ScoreParser.LogicalNotContext ctx) {
        return String.format("%s %s", this.translateToken("!"), this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public String visitLogicalOr(ScoreParser.LogicalOrContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitMulDiv(ScoreParser.MulDivContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitParens(ScoreParser.ParensContext ctx) {
        return (String)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public String visitPred(ScoreParser.PredContext ctx) {
        TerminalNode id = ctx.ID();
        ScoreParser.ExprContext expr = ctx.expr();
        return null;
    }

    @Override
    public String visitQual(ScoreParser.QualContext ctx) {
        String id = ctx.ID().getText();
        ScoreParser.IndexContext indexContext = ctx.index();
        if (indexContext != null) {
            return String.format("%s %s", this.visitIndex(indexContext), id);
        }
        ScoreParser.PredContext predContext = ctx.pred();
        if (predContext != null) {
            String predId = predContext.ID().getText();
            ScoreParser.ExprContext expr = predContext.expr();
            return String.format("%s %s %s %s %s", id, this.translateToken("where"), predId, this.translateToken("=="), this.visit((ParseTree)expr));
        }
        return id;
    }

    @Override
    public String visitRange(ScoreParser.RangeContext ctx) {
        String val = (String)this.visit((ParseTree)ctx.val);
        String min = (String)this.visit((ParseTree)ctx.min);
        String max = (String)this.visit((ParseTree)ctx.max);
        return String.format("%s %s %s %s %s %s", this.translateToken("if"), val, this.translateToken("between"), min, this.translateToken("and"), max);
    }

    @Override
    public String visitRelational(ScoreParser.RelationalContext ctx) {
        String operand0 = (String)this.visit((ParseTree)ctx.expr(0));
        String operand1 = (String)this.visit((ParseTree)ctx.expr(1));
        return String.format("%s %s %s", operand0, this.translateToken(ctx.op.getText()), operand1);
    }

    @Override
    public String visitString(ScoreParser.StringContext ctx) {
        return ctx.STRING().getText().substring(1, ctx.STRING().getText().length() - 1);
    }

    @Override
    public String visitTimeonly(ScoreParser.TimeonlyContext ctx) {
        LocalTime localTime = LocalTime.parse(ctx.TIME().getText(), DateTimeFormatters.TIME_ONLY);
        return DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).withZone(ZoneId.systemDefault()).format(localTime);
    }

    @Override
    public String visitTimestamp(ScoreParser.TimestampContext ctx) {
        Instant instant = DateTimeFormatters.DATE_TIME.parse((CharSequence)ctx.DATETIME().getText(), Instant::from);
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withZone(ZoneId.of("Z")).format(instant);
    }

    @Override
    public String visitUnaryMinus(ScoreParser.UnaryMinusContext ctx) {
        return String.format("-%s", this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public String visitVar(ScoreParser.VarContext ctx) {
        String scopeText = ctx.scope == null ? "in." : ctx.scope.getText();
        List<ScoreParser.QualContext> qualifiers = ctx.qual();
        List qualStrings = qualifiers.stream().map(arg_0 -> ((ScoreTranslator)this).visit(arg_0)).collect(Collectors.toList());
        return String.format("%s %s", this.translateToken(scopeText), String.join((CharSequence)"-", qualStrings));
    }

    @Override
    public String visitVariable(ScoreParser.VariableContext ctx) {
        return (String)this.visit((ParseTree)ctx.var());
    }

    private Object translateToken(String token) {
        return this.tokenMap.get(token);
    }
}

