/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.dsl.antlr;

import io.fixprotocol.orchestra.dsl.antlr.BaseSemanticErrorListener;
import io.fixprotocol.orchestra.dsl.antlr.ScoreParser;
import io.fixprotocol.orchestra.dsl.antlr.ScoreVisitor;
import io.fixprotocol.orchestra.dsl.antlr.SemanticErrorListener;
import io.fixprotocol.orchestra.dsl.datetime.DateTimeFormatters;
import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.FixType;
import io.fixprotocol.orchestra.model.FixValue;
import io.fixprotocol.orchestra.model.FixValueFactory;
import io.fixprotocol.orchestra.model.FixValueOperations;
import io.fixprotocol.orchestra.model.ModelException;
import io.fixprotocol.orchestra.model.PathStep;
import io.fixprotocol.orchestra.model.Scope;
import io.fixprotocol.orchestra.model.SymbolResolver;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

class ScoreVisitorImpl
extends AbstractParseTreeVisitor<FixValue<?>>
implements ScoreVisitor<FixValue<?>> {
    private Scope currentScope;
    private final SemanticErrorListener errorListener;
    private final FixValueOperations fixValueOperations = new FixValueOperations();
    private PathStep pathStep;
    private final SymbolResolver symbolResolver;
    private boolean trace = false;

    public ScoreVisitorImpl(SymbolResolver symbolResolver) {
        this(symbolResolver, new BaseSemanticErrorListener());
    }

    public ScoreVisitorImpl(SymbolResolver symbolResolver, SemanticErrorListener errorListener) {
        this.symbolResolver = symbolResolver;
        this.errorListener = errorListener;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public FixValue<?> visitAddSub(ScoreParser.AddSubContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "+": {
                    return this.fixValueOperations.add.apply(operand0, operand1);
                }
                case "-": {
                    return this.fixValueOperations.subtract.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitAnyExpression(ScoreParser.AnyExpressionContext ctx) {
        return (FixValue)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public FixValue<?> visitAssignment(ScoreParser.AssignmentContext ctx) {
        FixValue val = (FixValue)this.visit((ParseTree)ctx.expr());
        if (val == null) {
            this.errorListener.onError(String.format("Semantic error; missing val for assignment at '%s'", ctx.getText()));
            return null;
        }
        Object var = this.visitVar(ctx.var());
        try {
            if (var != null) {
                ((FixValue)var).assign(val);
                return var;
            }
            FixValue<?> namedVal = FixValueFactory.copy(this.pathStep.getName(), val);
            return this.currentScope.assign(this.pathStep, namedVal);
        }
        catch (ModelException e) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", e.getMessage(), ctx.getText()));
            return null;
        }
    }

    @Override
    public FixValue<?> visitCharacter(ScoreParser.CharacterContext ctx) {
        return new FixValue<Character>(FixType.charType, Character.valueOf(ctx.CHAR().getText().charAt(1)));
    }

    @Override
    public FixValue<?> visitContains(ScoreParser.ContainsContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.val);
        for (ScoreParser.ExprContext memberExpr : ctx.member) {
            FixValue member = (FixValue)this.visit((ParseTree)memberExpr);
            FixValue<Boolean> result = this.fixValueOperations.eq.apply(operand0, member);
            if (!result.getValue().booleanValue()) continue;
            return result;
        }
        return new FixValue<Boolean>(FixType.BooleanType, Boolean.FALSE);
    }

    @Override
    public FixValue<?> visitDateonly(ScoreParser.DateonlyContext ctx) {
        return new FixValue<LocalDate>(FixType.UTCDateOnly, LocalDate.parse(ctx.DATE().getText()));
    }

    @Override
    public FixValue<?> visitDecimal(ScoreParser.DecimalContext ctx) {
        return new FixValue<BigDecimal>(FixType.floatType, new BigDecimal(ctx.DECIMAL().getText()));
    }

    @Override
    public FixValue<?> visitDuration(ScoreParser.DurationContext ctx) {
        return new FixValue<Duration>(FixType.Duration, Duration.parse(ctx.PERIOD().getText()));
    }

    @Override
    public FixValue<Boolean> visitEquality(ScoreParser.EqualityContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "==": 
                case "eq": {
                    return this.fixValueOperations.eq.apply(operand0, operand1);
                }
                case "!=": 
                case "ne": {
                    return this.fixValueOperations.ne.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitExist(ScoreParser.ExistContext ctx) {
        FixValue<Boolean> result = new FixValue<Boolean>("", FixType.BooleanType);
        FixValue var = (FixValue)this.visit((ParseTree)ctx.var());
        result.setValue(var != null);
        return result;
    }

    @Override
    public FixValue<?> visitIndex(ScoreParser.IndexContext ctx) {
        if (ctx.UINT() != null) {
            this.pathStep.setIndex(Integer.parseInt(ctx.UINT().getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitInteger(ScoreParser.IntegerContext ctx) {
        return new FixValue<Integer>(FixType.intType, Integer.parseInt(ctx.UINT().getText()));
    }

    @Override
    public FixValue<Boolean> visitLogicalAnd(ScoreParser.LogicalAndContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "&&": 
                case "and": {
                    return this.fixValueOperations.and.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<Boolean> visitLogicalNot(ScoreParser.LogicalNotContext ctx) {
        FixValue operand = (FixValue)this.visit((ParseTree)ctx.expr());
        try {
            return this.fixValueOperations.not.apply(operand);
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
            return null;
        }
    }

    @Override
    public FixValue<Boolean> visitLogicalOr(ScoreParser.LogicalOrContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "||": 
                case "or": {
                    return this.fixValueOperations.or.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitMulDiv(ScoreParser.MulDivContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "*": {
                    return this.fixValueOperations.multiply.apply(operand0, operand1);
                }
                case "/": {
                    return this.fixValueOperations.divide.apply(operand0, operand1);
                }
                case "%": 
                case "mod": {
                    return this.fixValueOperations.mod.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitParens(ScoreParser.ParensContext ctx) {
        return (FixValue)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public FixValue<?> visitPred(ScoreParser.PredContext ctx) {
        TerminalNode id = ctx.ID();
        ScoreParser.ExprContext expr = ctx.expr();
        return null;
    }

    @Override
    public FixValue<?> visitQual(ScoreParser.QualContext ctx) {
        FixNode node;
        ScoreParser.PredContext predContext;
        this.pathStep = new PathStep(ctx.ID().getText());
        ScoreParser.IndexContext indexContext = ctx.index();
        if (indexContext != null) {
            this.visitIndex(indexContext);
        }
        if ((predContext = ctx.pred()) != null) {
            String id = predContext.ID().getText();
            ScoreParser.ExprContext exprContext = predContext.expr();
        }
        if ((node = this.currentScope.resolve(this.pathStep)) instanceof Scope) {
            this.currentScope = (Scope)node;
            if (this.isTrace()) {
                System.out.format("Current scope %s%n", this.currentScope.getName());
            }
            return null;
        }
        if (node == null) {
            return null;
        }
        return (FixValue)node;
    }

    @Override
    public FixValue<?> visitRange(ScoreParser.RangeContext ctx) {
        FixValue val = (FixValue)this.visit((ParseTree)ctx.val);
        FixValue min = (FixValue)this.visit((ParseTree)ctx.min);
        FixValue max = (FixValue)this.visit((ParseTree)ctx.max);
        return this.fixValueOperations.and.apply(this.fixValueOperations.ge.apply(val, min), this.fixValueOperations.le.apply(val, max));
    }

    @Override
    public FixValue<Boolean> visitRelational(ScoreParser.RelationalContext ctx) {
        FixValue operand0 = (FixValue)this.visit((ParseTree)ctx.expr(0));
        FixValue operand1 = (FixValue)this.visit((ParseTree)ctx.expr(1));
        try {
            switch (ctx.op.getText()) {
                case "<": 
                case "lt": {
                    return this.fixValueOperations.lt.apply(operand0, operand1);
                }
                case "<=": 
                case "le": {
                    return this.fixValueOperations.le.apply(operand0, operand1);
                }
                case ">": 
                case "gt": {
                    return this.fixValueOperations.gt.apply(operand0, operand1);
                }
                case ">=": 
                case "ge": {
                    return this.fixValueOperations.ge.apply(operand0, operand1);
                }
            }
        }
        catch (Exception ex) {
            this.errorListener.onError(String.format("Semantic error; %s at '%s'", ex.getMessage(), ctx.getText()));
        }
        return null;
    }

    @Override
    public FixValue<?> visitString(ScoreParser.StringContext ctx) {
        String text = ctx.STRING().getText();
        return new FixValue<String>(FixType.StringType, text.substring(1, text.length() - 1));
    }

    @Override
    public FixValue<?> visitTimeonly(ScoreParser.TimeonlyContext ctx) {
        return new FixValue<LocalTime>(FixType.UTCTimeOnly, LocalTime.parse(ctx.TIME().getText(), DateTimeFormatters.TIME_ONLY));
    }

    @Override
    public FixValue<?> visitTimestamp(ScoreParser.TimestampContext ctx) {
        Instant instant = DateTimeFormatters.DATE_TIME.parse((CharSequence)ctx.DATETIME().getText(), Instant::from);
        return new FixValue<Instant>(FixType.UTCTimestamp, instant);
    }

    @Override
    public FixValue<?> visitUnaryMinus(ScoreParser.UnaryMinusContext ctx) {
        FixValue unsigned = (FixValue)this.visit((ParseTree)ctx.expr());
        Object val = unsigned.getValue();
        if (val instanceof Integer) {
            unsigned.setValue((Integer)val * -1);
        } else if (val instanceof BigDecimal) {
            unsigned.setValue(((BigDecimal)val).multiply(BigDecimal.valueOf(-1L)));
        } else {
            this.errorListener.onError(String.format("Semantic error; cannot apply unary minus at '%s'", ctx.getText()));
        }
        return unsigned;
    }

    @Override
    public FixValue<?> visitVar(ScoreParser.VarContext ctx) {
        Object value = null;
        this.currentScope = this.symbolResolver;
        String scopeText = ctx.scope == null ? "this." : ctx.scope.getText();
        this.pathStep = new PathStep(scopeText);
        FixNode node = this.currentScope.resolve(this.pathStep);
        if (node instanceof Scope) {
            this.currentScope = (Scope)node;
            if (this.isTrace()) {
                System.out.format("Current scope %s%n", this.currentScope.getName());
            }
            List<ScoreParser.QualContext> qualifiers = ctx.qual();
            for (ScoreParser.QualContext qualifier : qualifiers) {
                value = this.visitQual(qualifier);
            }
        } else {
            this.errorListener.onError(String.format("Unknown symbol scope; %s at '%s'", this.pathStep.getName(), ctx.getText()));
        }
        return value;
    }

    @Override
    public FixValue<?> visitVariable(ScoreParser.VariableContext ctx) {
        return (FixValue)this.visit((ParseTree)ctx.var());
    }
}

