/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.PathStep;
import io.fixprotocol.orchestra.model.Scope;
import java.util.function.Consumer;

public abstract class AbstractScope
implements Scope {
    protected static boolean trace = false;
    protected static Consumer<String> traceHandler = System.out::println;

    public boolean isTrace() {
        return trace;
    }

    public void setTrace(boolean trace) {
        AbstractScope.trace = trace;
    }

    public void setTraceHandler(Consumer<String> traceHandler) {
        AbstractScope.traceHandler = traceHandler;
    }

    protected void traceNest(PathStep pathStep, Scope nested) {
        if (this.isTrace()) {
            traceHandler.accept(String.format("Path %s scope %s nested under scope %s", pathStep.getName(), nested.getName(), this.getName()));
        }
    }

    protected void traceRemove(PathStep pathStep, FixNode removed) {
        if (this.isTrace()) {
            traceHandler.accept(String.format("Path %s node %s removed from scope %s", pathStep.getName(), removed.getName(), this.getName()));
        }
    }
}

