/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;

public enum FixType {
    Amt{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    BooleanType{

        @Override
        public Boolean fromString(String text) {
            return Boolean.parseBoolean(text);
        }

        @Override
        public FixType getBaseType() {
            return BooleanType;
        }

        public Class<Boolean> getValueClass() {
            return Boolean.class;
        }
    }
    ,
    charType{

        @Override
        public Character fromString(String text) {
            return Character.valueOf(text.charAt(0));
        }

        @Override
        public FixType getBaseType() {
            return charType;
        }

        public Class<Character> getValueClass() {
            return Character.class;
        }
    }
    ,
    Country{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    Currency{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    data{

        public byte[] fromString(String text) {
            return text.getBytes();
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<byte[]> getValueClass() {
            return byte[].class;
        }
    }
    ,
    DayOfMonth{

        @Override
        public Integer fromString(String text) {
            return Integer.parseInt(text);
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    Exchange{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    floatType{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    intType{

        @Override
        public Integer fromString(String text) {
            return Integer.parseInt(text);
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    Language{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    Length{

        @Override
        public Integer fromString(String text) {
            return Integer.parseInt(text);
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    LocalMktDate{

        @Override
        public LocalDate fromString(String text) {
            return LocalDate.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<LocalDate> getValueClass() {
            return LocalDate.class;
        }
    }
    ,
    LocalMktTime{

        @Override
        public LocalTime fromString(String text) {
            return LocalTime.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<LocalTime> getValueClass() {
            return LocalTime.class;
        }
    }
    ,
    MonthYear{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    MultipleCharValue{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    MultipleStringValue{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    NumInGroup{

        @Override
        public Integer fromString(String text) {
            return Integer.parseInt(text);
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    Percentage{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    Price{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    PriceOffset{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    Qty{

        @Override
        public BigDecimal fromString(String text) {
            return new BigDecimal(text);
        }

        @Override
        public FixType getBaseType() {
            return floatType;
        }

        public Class<BigDecimal> getValueClass() {
            return BigDecimal.class;
        }
    }
    ,
    SeqNum{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    StringType{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    TagNum{

        @Override
        public Integer fromString(String text) {
            return Integer.parseInt(text);
        }

        @Override
        public FixType getBaseType() {
            return intType;
        }

        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
    ,
    TZTimeOnly{

        @Override
        public ZonedDateTime fromString(String text) {
            return ZonedDateTime.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<ZonedDateTime> getValueClass() {
            return ZonedDateTime.class;
        }
    }
    ,
    TZTimestamp{

        @Override
        public ZonedDateTime fromString(String text) {
            return ZonedDateTime.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<ZonedDateTime> getValueClass() {
            return ZonedDateTime.class;
        }
    }
    ,
    UTCDateOnly{

        @Override
        public LocalDate fromString(String text) {
            return LocalDate.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<LocalDate> getValueClass() {
            return LocalDate.class;
        }
    }
    ,
    UTCTimeOnly{

        @Override
        public LocalTime fromString(String text) {
            return LocalTime.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<LocalTime> getValueClass() {
            return LocalTime.class;
        }
    }
    ,
    UTCTimestamp{

        @Override
        public Instant fromString(String text) {
            return Instant.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<Instant> getValueClass() {
            return Instant.class;
        }
    }
    ,
    XMLData{

        @Override
        public String fromString(String text) {
            return text;
        }

        @Override
        public FixType getBaseType() {
            return StringType;
        }

        public Class<String> getValueClass() {
            return String.class;
        }
    }
    ,
    Duration{

        @Override
        public Duration fromString(String text) {
            return java.time.Duration.parse(text);
        }

        @Override
        public FixType getBaseType() {
            return null;
        }

        @Override
        public Class<?> getValueClass() {
            return Duration.class;
        }
    };


    public static FixType forName(String name) {
        String dataTypeString;
        switch (dataTypeString = name) {
            case "String": {
                dataTypeString = "StringType";
                break;
            }
            case "Boolean": {
                dataTypeString = "BooleanType";
                break;
            }
            case "char": {
                dataTypeString = "charType";
                break;
            }
            case "int": {
                dataTypeString = "intType";
                break;
            }
            case "float": {
                dataTypeString = "floatType";
            }
        }
        return FixType.valueOf(dataTypeString);
    }

    public abstract Object fromString(String var1);

    public abstract FixType getBaseType();

    public abstract Class<?> getValueClass();
}

