/*
 * Decompiled with CFR 0.152.
 */
package io.fixprotocol.orchestra.model;

import io.fixprotocol.orchestra.model.FixNode;
import io.fixprotocol.orchestra.model.FixType;
import io.fixprotocol.orchestra.model.ModelException;
import java.util.Objects;

public class FixValue<T>
implements FixNode {
    private final String name;
    private final FixType type;
    private T value;

    public FixValue(FixType type, T value) {
        this(null, type, value);
    }

    public FixValue(String name) {
        this(name, null, null);
    }

    public FixValue(String name, FixType type) {
        this(name, type, null);
    }

    public FixValue(String name, FixType type, T value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public void assign(FixValue<?> operand) throws ModelException {
        Objects.requireNonNull(operand, "Missing operand");
        if (this.type.getBaseType() != operand.getType().getBaseType()) {
            throw new ModelException(String.format("Data type mismatch between %s and %s", new Object[]{this.type, operand.getType()}));
        }
        this.value = operand.getValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixValue other = (FixValue)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public FixType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String toString() {
        return "FixValue [" + (this.name != null ? "name=" + this.name + ", " : "") + (this.type != null ? "type=" + (Object)((Object)this.type) + ", " : "") + (this.value != null ? "value=" + this.value : "") + "]";
    }
}

